<?php

/**
 * Trait for variable products.
 *
 * @link       https://icopydoc.ru
 * @since      0.1.0
 * @version    5.0.23 (15-11-2025)
 *
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/variable
 */

/**
 * The trait adds `get_vendorcode` method.
 * 
 * This method allows you to return the `vendorCode` tag.
 *
 * @since      0.1.0
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/variable
 * @author     Maxim Glazunov <icopydoc@gmail.com>
 * @depends    classes:     Y4YM_Get_Paired_Tag
 *             methods:     get_product
 *                          get_offer
 *                          get_feed_id
 *             functions:   common_option_get
 */
trait Y4YM_T_Variable_Get_Vendorcode {

	/**
	 * Get `vendorCode` tag.
	 * 
	 * @see https://yandex.ru/support/marketplace/assortment/fields/index.html
	 * 
	 * @param string $tag_name
	 * @param string $result_xml
	 * 
	 * @return string Example: `<vendorCode>VNDR-0005A, VNDR-0005B</vendorCode>`.
	 */
	public function get_vendorcode( $tag_name = 'vendorCode', $result_xml = '' ) {

		$vendorcode = common_option_get(
			'y4ym_vendorcode',
			false,
			$this->get_feed_id(),
			'y4ym'
		);
		if ( $vendorcode === 'disabled' ) {
			return $result_xml;
		}
		switch ( $vendorcode ) {
			// disabled, sku
			case "sku":

				$tag_value = $this->get_offer()->get_sku();
				if ( empty( $tag_value ) ) {
					$tag_value = $this->get_product()->get_sku();
				}

				break;
			case 'post_meta':

				$vendorcode_post_meta_id = common_option_get(
					'y4ym_vendorcode_post_meta',
					'',
					$this->get_feed_id(),
					'y4ym'
				);
				$tag_value = $this->get_variable_product_post_meta( $vendorcode_post_meta_id );

				break;
			default:

				$tag_value = apply_filters(
					'y4ym_f_variable_tag_value_switch_barcode',
					'',
					[
						'product' => $this->get_product(),
						'offer' => $this->get_offer(),
						'switch_value' => $vendorcode
					],
					$this->get_feed_id()
				);
				if ( empty( $tag_value ) ) {
					$tag_value = $this->get_variable_global_attribute_value( $vendorcode );
				}
		}

		// ! обернул $tag_value в htmlspecialchars т.к у нас могут быть амперсанды
		$result_xml = $this->get_variable_tag( $tag_name, htmlspecialchars( $tag_value ) );
		return $result_xml;

	}

}