<?php

/**
 * Trait for variable products.
 *
 * @link       https://icopydoc.ru
 * @since      0.1.0
 * @version    5.0.23 (15-11-2025)
 *
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/variable
 */

/**
 * The trait adds `get_keywords` method.
 * 
 * This method allows you to return the `keywords` tag.
 *
 * @since      0.1.0
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/variable
 * @author     Maxim Glazunov <icopydoc@gmail.com>
 * @depends    classes:     Y4YM_Get_Paired_Tag
 *             methods:     get_product
 *                          get_offer
 *                          get_feed_id
 *                          get_variable_tag
 *             functions:   common_option_get
 */
trait Y4YM_T_Variable_Get_Keywords {

	/**
	 * Get `keywords` tag.
	 * 
	 * @param string $tag_name
	 * @param string $result_xml
	 * 
	 * @return string Example: `<keywords>солово_1, солово_2... солово N</keywords>`.
	 */
	public function get_keywords( $tag_name = 'keywords', $result_xml = '' ) {

		$keywords = common_option_get(
			'y4ym_keywords',
			false,
			$this->get_feed_id(),
			'y4ym'
		);
		if ( $keywords === 'enabled' ) {
			$tag_value = $this->get_variable_product_post_meta( 'keywords' );
			$result_xml = $this->get_variable_tag( $tag_name, $tag_value );
		}
		return $result_xml;

	}

}