<?php

/** 
 * Trait for simple products.
 *
 * @link       https://icopydoc.ru
 * @since      0.1.0
 * @version    5.0.0 (25-03-2025)
 *
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/simple
 */

/**
 * The trait adds `get_shipment_options` method.
 * 
 * This method allows you to return the `shipment-options` tag.
 *
 * @since      0.1.0
 * @package    Y4YM
 * @subpackage Y4YM/includes/feeds/traits/simple
 * @author     Maxim Glazunov <icopydoc@gmail.com>
 * @depends    classes:     Y4YM_Get_Paired_Tag
 *             methods:     get_product
 *                          get_feed_id
 *             functions:   
 */
trait Y4YM_T_Simple_Get_Shipment_Options {

	/**
	 * Get `shipment-options` tag.
	 * 
	 * @see https://partner-wiki.megamarket.ru/merchant-api/1-vvedenie/1-1-tovarnyj-fid
	 * 
	 * @param string $tag_name
	 * @param string $result_xml
	 * @param string $depricated
	 * 
	 * @return string Example: `<shipment-options>...</shipment-options>`.
	 */
	public function get_shipment_options( $tag_name = 'shipment-options', $result_xml = '' ) {

		if ( ( get_post_meta( $this->get_product()->get_id(), '_yfym_cost', true ) !== '' )
			&& ( get_post_meta( $this->get_product()->get_id(), '_yfym_days', true ) !== '' ) ) {
			$cost = get_post_meta( $this->get_product()->get_id(), '_yfym_cost', true );
			$days = get_post_meta( $this->get_product()->get_id(), '_yfym_days', true );
			$attr_arr = [ 'cost' => $cost, 'days' => $days ];
			if ( get_post_meta( $this->get_product()->get_id(), '_yfym_order_before', true ) !== '' ) {
				$order_before = get_post_meta( $this->get_product()->get_id(), '_yfym_order_before', true );
				$attr_arr['order-before'] = $order_before;
			}
			$result_xml = new Y4YM_Get_Open_Tag( $tag_name );
			$result_xml = new Y4YM_Get_Open_Tag( 'option', $attr_arr, true );
			$result_xml .= new Y4YM_Get_Closed_Tag( $tag_name );
		}

		$result_xml = apply_filters(
			'y4ym_f_simple_tag_shipment_options',
			$result_xml,
			[ 
				'product' => $this->get_product()
			],
			$this->get_feed_id()
		);

		return $result_xml;

	}

}