<?php
/**
 * This class is responsible for managing the cart discount in the YAYDP system.
 *
 * @package YayPricing\Classes
 */

namespace YAYDP\Core\Manager;

defined( 'ABSPATH' ) || exit;

/**
 * Declare class
 */
class YAYDP_Checkout_Fee_Manager {

	use \YAYDP\Traits\YAYDP_Singleton;

	/**
	 * Constructor
	 */
	private function __construct() {
		add_action( 'woocommerce_before_calculate_totals', array( $this, 'calculate_pricings' ), YAYDP_CHECKOUT_CALCULATE_PRIORITY );
		// add_action( 'woocommerce_cart_calculate_fees', array( $this, 'calculate_pricings' ), 9 );
		add_action( 'wc_ajax_update_shipping_method', array( $this, 'calculate_pricings' ), 9 );
		add_action( 'yaydp_before_calculate_checkout_fee', array( $this, 'before_calculate_pricings' ), 10 );
		add_action( 'yaydp_after_calculate_checkout_fee', array( $this, 'after_calculate_pricings' ), 10 );

		add_filter( 'woocommerce_cart_totals_fee_html', array( $this, 'cart_totals_fee_html' ), 11, 2 );

		$this->handle_use_time();
	}

	/**
	 * Removes discounts generated by YayPricing from the cart.
	 *
	 * @deprecated 2.4.2
	 */
	public function remove_all_fees() {

	}

	/**
	 * This function is called before calculating the pricings for a cart
	 */
	public function before_calculate_pricings() {
		$this->remove_all_fees();
	}

	/**
	 * This function is called after calculating the pricings for a cart
	 */
	public function after_calculate_pricings() {
	}

	/**
	 * Calculate pricings
	 */
	public function calculate_pricings() {

		// if ( \yaydp_has_cart_block() ) {
		// 	if ( apply_filters( 'yaydp_prevent_recalculate_cart_discount', false ) ) {
		// 		return;
		// 	}
		// } else {
		// 	remove_action( 'woocommerce_before_calculate_totals', array( self::get_instance(), 'calculate_pricings' ), YAYDP_CHECKOUT_CALCULATE_PRIORITY );
		// 	remove_action( 'woocommerce_cart_calculate_fees', array( self::get_instance(), 'calculate_pricings' ) );
		// }

		static $has_run = false;
		if ( $has_run ) {
			return;
		}
		$has_run = true;

		do_action( 'yaydp_before_calculate_checkout_fee' );

		global $yaydp_cart;
		if ( is_null( $yaydp_cart ) ) {
			$yaydp_cart                  = new \YAYDP\Core\YAYDP_Cart();
			$product_pricing_adjustments = new \YAYDP\Core\Adjustments\YAYDP_Product_Pricing_Adjustments( $yaydp_cart );
			$product_pricing_adjustments->do_stuff();
		}
		$checkout_fee_adjustments = new \YAYDP\Core\Adjustments\YAYDP_Checkout_Fee_Adjustments( $yaydp_cart );
		$checkout_fee_adjustments->do_stuff();

		do_action( 'yaydp_after_calculate_checkout_fee' );

	}

	/**
	 * Change cart fee html
	 *
	 * @param string $fee_html HTML.
	 */
	public function cart_totals_fee_html( $fee_html, $fee ) {
		$running_rules = \yaydp_get_running_checkout_fee_rules();
		foreach ( $running_rules as $rule ) {
			if ( $rule->get_id() === $fee->id ) {
				return $fee_html . $rule->get_fee_content();
			}
		}
		return $fee_html;
	}

	/**
	 * Handle use time
	 */
	private function handle_use_time() {
		\YAYDP\Core\Use_Time\YAYDP_Checkout_Fee_Use_Time::get_instance();
	}

}
