<?php
/**
 * Translation class
 *
 * Load translation dependences
 *
 * @package YayPricing\Classes
 */

namespace YAYDP;

defined( 'ABSPATH' ) || exit;

/**
 * YAYDP_I18n class
 */
class YAYDP_I18n {

	/**
	 * Load translation file from text domain
	 */
	public static function load_plugin_text_domain() {
		if ( function_exists( 'determine_locale' ) ) {
			$locale = determine_locale();
		} else {
			$locale = is_admin() ? get_user_locale() : get_locale();
		}
		unload_textdomain( 'yaypricing' );
		load_textdomain( 'yaypricing', YAYDP_PLUGIN_PATH . 'languages/yaypricing-' . $locale . '.mo' );
		load_plugin_textdomain( 'yaypricing', false, YAYDP_PLUGIN_PATH . 'languages/' );
	}

	public static function get_translations() {
		return array(
			'Last 7 days'                                  => __( 'Last 7 days', 'yaypricing' ),
			'Product Pricing'                              => __( 'Product Pricing', 'yaypricing' ),
			'Cart Discount'                                => __( 'Cart Discount', 'yaypricing' ),
			'Checkout Fee'                                 => __( 'Checkout Fee', 'yaypricing' ),
			'Time'                                         => __( 'Time', 'yaypricing' ),
			'Split rule'                                   => __( 'Split rule', 'yaypricing' ),
			'Fixed Discount'                               => __( 'Fixed Discount', 'yaypricing' ),
			'Percentage Discount'                          => __( 'Percentage Discount', 'yaypricing' ),
			'Fixed Fee'                                    => __( 'Fixed Fee', 'yaypricing' ),
			'Percentage Fee'                               => __( 'Percentage Fee', 'yaypricing' ),
			'Reduce Shipping Fee'                          => __( 'Reduce Shipping Fee', 'yaypricing' ),
			'Add Custom Fee'                               => __( 'Add Custom Fee', 'yaypricing' ),
			'Add Custom Fee based on Shipping Fee'         => __( 'Add Custom Fee based on Shipping Fee', 'yaypricing' ),
			'Sample rule'                                  => __( 'Sample rule', 'yaypricing' ),
			'You'                                          => __( 'You', 'yaypricing' ),
			'Simple Adjustment'                            => __( 'Simple Adjustment', 'yaypricing' ),
			'Bulk Pricing'                                 => __( 'Bulk Pricing', 'yaypricing' ),
			'Product Bundle'                               => __( 'Product Bundle', 'yaypricing' ),
			'BOGO (same product)'                          => __( 'BOGO (same product)', 'yaypricing' ),
			'Buy X get Y'                                  => __( 'Buy X get Y', 'yaypricing' ),
			'Tiered Pricing'                               => __( 'Tiered Pricing', 'yaypricing' ),
			'Product Fee'                                  => __( 'Product Fee', 'yaypricing' ),
			'Flat Price'                                   => __( 'Flat Price', 'yaypricing' ),
			'All together'                                 => __( 'All together', 'yaypricing' ),
			'Item quantity in each cart line'              => __( 'Item quantity in each cart line', 'yaypricing' ),
			'Each single product/variable products'        => __( 'Each single product/variable products', 'yaypricing' ),
			'Purchase history'                             => __( 'Purchase history', 'yaypricing' ),
			'Customer order count'                         => __( 'Customer order count', 'yaypricing' ),
			'Number of all the orders they have placed in the past.' => __( 'Number of all the orders they have placed in the past.', 'yaypricing' ),
			'Order count from last discount'               => __( 'Order count from last discount', 'yaypricing' ),
			'Number of orders counted from the last time they got a discount from YayPricing.' => __( 'Number of orders counted from the last time they got a discount from YayPricing.', 'yaypricing' ),
			'Previous purchase date'                       => __( 'Previous purchase date', 'yaypricing' ),
			'Purchase date of orders placed in the past.'  => __( 'Purchase date of orders placed in the past.', 'yaypricing' ),
			'Order history product'                        => __( 'Order history product', 'yaypricing' ),
			'Purchased products in a specific order.'      => __( 'Purchased products in a specific order.', 'yaypricing' ),
			'Order history category'                       => __( 'Order history category', 'yaypricing' ),
			'Purchased product categories in a specific order.' => __( 'Purchased product categories in a specific order.', 'yaypricing' ),
			'Purchased products (lifetime)'                => __( 'Purchased products (lifetime)', 'yaypricing' ),
			'Purchased products among all the orders they have placed in the past.' => __( 'Purchased products among all the orders they have placed in the past.', 'yaypricing' ),
			'Account create time'                          => __( 'Account create time', 'yaypricing' ),
			'Account lifetime from the time they are created' => __( 'Account lifetime from the time they are created', 'yaypricing' ),
			'Cart'                                         => __( 'Cart', 'yaypricing' ),
			'Cart subtotal price'                          => __( 'Cart subtotal price', 'yaypricing' ),
			'Cart quantity'                                => __( 'Cart quantity', 'yaypricing' ),
			'Cart total weight'                            => __( 'Cart total weight', 'yaypricing' ),
			'Cart Items'                                   => __( 'Cart Items', 'yaypricing' ),
			'Cart item - product'                          => __( 'Cart item - product', 'yaypricing' ),
			'Cart item - variation'                        => __( 'Cart item - variation', 'yaypricing' ),
			'Cart item - attribute taxonomies'             => __( 'Cart item - attribute taxonomies', 'yaypricing' ),
			'Cart item - category'                         => __( 'Cart item - category', 'yaypricing' ),
			'Cart item - tag'                              => __( 'Cart item - tag', 'yaypricing' ),
			'Customer'                                     => __( 'Customer', 'yaypricing' ),
			'Is logged in customer'                        => __( 'Is logged in customer', 'yaypricing' ),
			'Customer role'                                => __( 'Customer role', 'yaypricing' ),
			'Specific customer'                            => __( 'Specific customer', 'yaypricing' ),
			'Others'                                       => __( 'Others', 'yaypricing' ),
			'Shipping region'                              => __( 'Shipping region', 'yaypricing' ),
			'Billing region'                               => __( 'Billing region', 'yaypricing' ),
			'Payment method'                               => __( 'Payment method', 'yaypricing' ),
			'Shipping method'                              => __( 'Shipping method', 'yaypricing' ),
			'Shipping class'                              => __( 'Shipping class', 'yaypricing' ),
			'Combination'                                  => __( 'Combination', 'yaypricing' ),
			'Combined condition'                           => __( 'Combined condition', 'yaypricing' ),
			'Applied coupons'                              => __( 'Applied coupons', 'yaypricing' ),
			'Total shipping fee'                           => __( 'Total shipping fee', 'yaypricing' ),
			'Items - Product'                              => __( 'Items - Product', 'yaypricing' ),
			'Items - Category'                             => __( 'Items - Category', 'yaypricing' ),
			'Combined items'                               => __( 'Combined items', 'yaypricing' ),
			'Items - Quantity'                             => __( 'Items - Quantity', 'yaypricing' ),
			'Items - Subtotal price'                       => __( 'Items - Subtotal price', 'yaypricing' ),
			'Contain all'                                  => __( 'Contain all', 'yaypricing' ),
			'Contain in list'                              => __( 'Contain in list', 'yaypricing' ),
			'Not contain in list'                          => __( 'Not contain in list', 'yaypricing' ),
			'Greater than'                                 => __( 'Greater than', 'yaypricing' ),
			'Less than'                                    => __( 'Less than', 'yaypricing' ),
			'Greater than or equal'                        => __( 'Greater than or equal', 'yaypricing' ),
			'Less than or equal'                           => __( 'Less than or equal', 'yaypricing' ),
			'In list'                                      => __( 'In list', 'yaypricing' ),
			'Not in list'                                  => __( 'Not in list', 'yaypricing' ),
			'Logged in'                                    => __( 'Logged in', 'yaypricing' ),
			'Not logged in'                                => __( 'Not logged in', 'yaypricing' ),
			'Before'                                       => __( 'Before', 'yaypricing' ),
			'After'                                        => __( 'After', 'yaypricing' ),
			'On'                                           => __( 'On', 'yaypricing' ),
			'In range'                                     => __( 'In range', 'yaypricing' ),
			'Longer than'                                  => __( 'Longer than', 'yaypricing' ),
			'Within'                                       => __( 'Within', 'yaypricing' ),
			'Off'                                          => __( 'Off', 'yaypricing' ),
			'Weekly'                                       => __( 'Weekly', 'yaypricing' ),
			'Monthly'                                      => __( 'Monthly', 'yaypricing' ),
			'Yearly'                                       => __( 'Yearly', 'yaypricing' ),
			'Product exclusions'                           => __( 'Product exclusions', 'yaypricing' ),
			'Coupon exclusions'                            => __( 'Coupon exclusions', 'yaypricing' ),
			'Fixed Discount per Individual Cart Item'      => __( 'Fixed Discount per Individual Cart Item', 'yaypricing' ),
			'Your own campaign'                            => __( 'Your own campaign', 'yaypricing' ),
			'Refers to a tailored pricing or promotional strategy designed specifically for your business or product offerings' => __( 'Refers to a tailored pricing or promotional strategy designed specifically for your business or product offerings', 'yaypricing' ),
			'You want to run a special promotional campaign offering 50% off every item in your store.' => __( 'You want to run a special promotional campaign offering 50% off every item in your store.', 'yaypricing' ),
			'When the promotion is activated, all products in your store automatically receive a 50% discount when added to cart' => __( 'When the promotion is activated, all products in your store automatically receive a 50% discount when added to cart', 'yaypricing' ),
			'Eg:'                                          => __( 'Eg:', 'yaypricing' ),
			'T-shirt:'                                     => __( 'T-shirt:', 'yaypricing' ),
			'Hoodie:'                                      => __( 'Hoodie:', 'yaypricing' ),
			'Belt:'                                        => __( 'Belt:', 'yaypricing' ),
			'Sale 50% all products'                        => __( 'Sale 50% all products', 'yaypricing' ),
			'Sale 10$ all products'                        => __( 'Sale 10$ all products', 'yaypricing' ),
			'Sale [discount_value] all products'           => __( 'Sale [discount_value] all products', 'yaypricing' ),
			'You want to run a special promotional campaign offering 10$ off every item in your store.' => __( 'You want to run a special promotional campaign offering 10$ off every item in your store.', 'yaypricing' ),
			'When the promotion is activated, all products in your store automatically receive a 10$ discount when added to cart' => __( 'When the promotion is activated, all products in your store automatically receive a 10$ discount when added to cart', 'yaypricing' ),
			'Hoodie'                                       => __( 'Hoodie', 'yaypricing' ),
			'Belt'                                         => __( 'Belt', 'yaypricing' ),
			'Buy 3 get 1 free item'                        => __( 'Buy 3 get 1 free item', 'yaypricing' ),
			'Get this free when buy 3 item'                => __( 'Get this free when buy 3 item', 'yaypricing' ),
			'Rewards customers with a free item after purchasing a specified quantity of products.' => __( 'Rewards customers with a free item after purchasing a specified quantity of products.', 'yaypricing' ),
			'In this case, customers who buy 3 items will receive an additional item for free.' => __( 'In this case, customers who buy 3 items will receive an additional item for free.', 'yaypricing' ),
			'For every 3 clothing purchased, a free same type clothing is added to the cart automatically.' => __( 'For every 3 clothing purchased, a free same type clothing is added to the cart automatically.', 'yaypricing' ),
			'Total items in cart:'                         => __( 'Total items in cart:', 'yaypricing' ),
			'Gift'                                         => __( 'Gift', 'yaypricing' ),
			'Sale 30% from the third item'                 => __( 'Sale 30% from the third item', 'yaypricing' ),
			'Discount [discount_value] off from 3rd item'  => __( 'Discount [discount_value] off from 3rd item', 'yaypricing' ),
			'You will get 30% off when buy from 3 items'   => __( 'You will get 30% off when buy from 3 items', 'yaypricing' ),
			'Provides a 30% discount on specific product when they purchase 3 or more items.' => __( 'Provides a 30% discount on specific product when they purchase 3 or more items.', 'yaypricing' ),
			'An store could offer a 30% discount for a purchased clothing type when customers buy 3 or more.' => __( 'An store could offer a 30% discount for a purchased clothing type when customers buy 3 or more.', 'yaypricing' ),
			'Discounted'                                   => __( 'Discounted', 'yaypricing' ),
			'Black Friday Event'                           => __( 'Black Friday Event', 'yaypricing' ),
			'Today is Black Friday, so you will get 70% off when buy all products' => __( 'Today is Black Friday, so you will get 70% off when buy all products', 'yaypricing' ),
			'The Black Friday Event campaign is a one-time, annual promotion that starts on the next Black Friday (the Friday after Thanksgiving this year).' => __( 'The Black Friday Event campaign is a one-time, annual promotion that starts on the next Black Friday (the Friday after Thanksgiving this year).', 'yaypricing' ),
			'Campaign will add a schedule in this rule to detect the next Black Friday.' => __( 'Campaign will add a schedule in this rule to detect the next Black Friday.', 'yaypricing' ),
			'A clothing store could offer up to 70% off on all items and run flash sales on accessories like scarves and gloves.' => __( 'A clothing store could offer up to 70% off on all items and run flash sales on accessories like scarves and gloves.', 'yaypricing' ),
			'Buy 1 get 50% off the second one'             => __( 'Buy 1 get 50% off the second one', 'yaypricing' ),
			'You will get 50% off when buy the this product' => __( 'You will get 50% off when buy the this product', 'yaypricing' ),
			'Promotion that allows customers to purchase one item at full price and receive a same second item at 50% off.' => __( 'Promotion that allows customers to purchase one item at full price and receive a same second item at 50% off.', 'yaypricing' ),
			'Customers buy 1 T-Shirt at full price and get a second one at 50% off.' => __( 'Customers buy 1 T-Shirt at full price and get a second one at 50% off.', 'yaypricing' ),
			'Buy X get Y with discount'                    => __( 'Buy X get Y with discount', 'yaypricing' ),
			'Discount [discount_value] off'                => __( 'Discount [discount_value] off', 'yaypricing' ),
			'You will get [discount_value] discount when buy 1 item of this product' => __( 'You will get [discount_value] discount when buy 1 item of this product', 'yaypricing' ),
			'Campaign allows customers to purchase a specific product (X) and receive a second product (Y) at a discounted price.' => __( 'Campaign allows customers to purchase a specific product (X) and receive a second product (Y) at a discounted price.', 'yaypricing' ),
			'Buy a Hoodie (Product X) and get a T-shirt (Product Y) at 10$ off.' => __( 'Buy a Hoodie (Product X) and get a T-shirt (Product Y) at 10$ off.', 'yaypricing' ),
			'For a limited time, get 50% off when you purchase any 3 selected items in a package.' => __( 'For a limited time, get 50% off when you purchase any 3 selected items in a package.', 'yaypricing' ),
			'Select 3 items from our curated package options and receive 50% off the regular price of the 3 items in the package.' => __( 'Select 3 items from our curated package options and receive 50% off the regular price of the 3 items in the package.', 'yaypricing' ),
			'Package includes Hoodie, T-Shirt, Cap, ...'   => __( 'Package includes Hoodie, T-Shirt, Cap, ...', 'yaypricing' ),
			'Sale 50% off 3 items in package'              => __( 'Sale 50% off 3 items in package', 'yaypricing' ),
			'Sale 30% on the third item'                   => __( 'Sale 30% on the third item', 'yaypricing' ),
			'Provides a 30% discount on a customer’s entire order when they purchase 3 or more items.' => __( 'Provides a 30% discount on a customer’s entire order when they purchase 3 or more items.', 'yaypricing' ),
			'Store could offer a 30% discount for the 3rd purchased T-Shirt or Cap' => __( 'Store could offer a 30% discount for the 3rd purchased T-Shirt or Cap', 'yaypricing' ),
			'Flexible promotional offer that allows you to apply a discount to the entire shopping cart based on custom rules that you define.' => __( 'Flexible promotional offer that allows you to apply a discount to the entire shopping cart based on custom rules that you define.', 'yaypricing' ),
			'Apply 100$ discount to the whole cart.'       => __( 'Apply 100$ discount to the whole cart.', 'yaypricing' ),
			'Cart subtotal:'                               => __( 'Cart subtotal:', 'yaypricing' ),
			'Discount:'                                    => __( 'Discount:', 'yaypricing' ),
			'Final total:'                                 => __( 'Final total:', 'yaypricing' ),
			'Discount 50% campaign'                        => __( 'Discount 50% campaign', 'yaypricing' ),
			'Discount [discount_value] all cart'           => __( 'Discount [discount_value] all cart', 'yaypricing' ),
			'Provides customers with a 50% discount on the total value of their shopping cart' => __( 'Provides customers with a 50% discount on the total value of their shopping cart', 'yaypricing' ),
			'Customer will receive a 50% discount.'        => __( 'Customer will receive a 50% discount.', 'yaypricing' ),
			'Discount'                                     => __( 'Discount', 'yaypricing' ),
			'campaign'                                     => __( 'campaign', 'yaypricing' ),
			'Provides customers with a 10$ discount on the total value of their shopping cart' => __( 'Provides customers with a 10$ discount on the total value of their shopping cart', 'yaypricing' ),
			'Customer will receive a 10$ discount'         => __( 'Customer will receive a 10$ discount', 'yaypricing' ),
			'Black Friday campaign'                        => __( 'Black Friday campaign', 'yaypricing' ),
			'Black friday discount! Discount [discount_value] all cart' => __( 'Black friday discount! Discount [discount_value] all cart', 'yaypricing' ),
			'A clothing store could offer up to 100$ off cart totals on Black Friday' => __( 'A clothing store could offer up to 100$ off cart totals on Black Friday', 'yaypricing' ),
			'Discount 10$ on the total when spending 100$' => __( 'Discount 10$ on the total when spending 100$', 'yaypricing' ),
			'Provides customers with a 10$ discount on the total value of their shopping cart when spending 100$' => __( 'Provides customers with a 10$ discount on the total value of their shopping cart when spending 100$', 'yaypricing' ),
			'If the customer has items worth $100 in their cart, they will receive a 10$ discount, making their final cart total $90.' => __( 'If the customer has items worth $100 in their cart, they will receive a 10$ discount, making their final cart total $90.', 'yaypricing' ),
			'Promotion that allows you to apply a customized fee at checkout based on specific rules that you define. Unlike typical discounts, this campaign lets you add a fee to a customer’s order under certain conditions.' => __( 'Promotion that allows you to apply a customized fee at checkout based on specific rules that you define. Unlike typical discounts, this campaign lets you add a fee to a customer’s order under certain conditions.', 'yaypricing' ),
			'Apply 10$ extra fee to the order'             => __( 'Apply 10$ extra fee to the order', 'yaypricing' ),
			'Fee:'                                         => __( 'Fee:', 'yaypricing' ),
			'Free shipping fee'                            => __( 'Free shipping fee', 'yaypricing' ),
			'Get free shipping'                            => __( 'Get free shipping', 'yaypricing' ),
			'Offers customers free delivery on their orders under certain conditions.' => __( 'Offers customers free delivery on their orders under certain conditions.', 'yaypricing' ),
			'Reduce shipping fee in order to customers get free on shipping.' => __( 'Reduce shipping fee in order to customers get free on shipping.', 'yaypricing' ),
			'Shipping fee:'                                => __( 'Shipping fee:', 'yaypricing' ),
			'Reduce 50% shipping fee for order below'      => __( 'Reduce 50% shipping fee for order below', 'yaypricing' ),
			'Discount 50% of the shipping cost'            => __( 'Discount 50% of the shipping cost', 'yaypricing' ),
			'Offers a 50% discount on the shipping fee for customers who place orders with a total value below $100.' => __( 'Offers a 50% discount on the shipping fee for customers who place orders with a total value below $100.', 'yaypricing' ),
			'A customer spending $80 on kitchen utensils could have their $12 shipping fee reduced to $6, which would encourage them to complete the checkout.' => __( 'A customer spending $80 on kitchen utensils could have their $12 shipping fee reduced to $6, which would encourage them to complete the checkout.', 'yaypricing' ),
			'Add'                                          => __( 'Add', 'yaypricing' ),
			'fee to order'                                 => __( 'fee to order', 'yaypricing' ),
			'Add [discount_value] to the order'            => __( 'Add [discount_value] to the order', 'yaypricing' ),
			'Automatically apply a $10 fee to a customer'  => __( 'Automatically apply a $10 fee to a customer', 'yaypricing' ),
			'A $10 fee is automatically added to the order.' => __( 'A $10 fee is automatically added to the order.', 'yaypricing' ),
			'Extra fee:'                                   => __( 'Extra fee:', 'yaypricing' ),
			'Upgrade'                                      => __( 'Upgrade', 'yaypricing' ),
			'Duplicate of'                                 => __( 'Duplicate of', 'yaypricing' ),
			'Before '                                      => __( 'Before ', 'yaypricing' ),
			'After '                                       => __( 'After ', 'yaypricing' ),
			'Before Product short description'             => __( 'Before Product short description', 'yaypricing' ),
			'After Product short description'              => __( 'After Product short description', 'yaypricing' ),
			'Product meta start'                           => __( 'Product meta start', 'yaypricing' ),
			'Product meta end'                             => __( 'Product meta end', 'yaypricing' ),
			'None'                                         => __( 'None', 'yaypricing' ),
			'Style has been reset'                         => __( 'Style has been reset', 'yaypricing' ),
			'Quantity discounts'                           => __( 'Quantity discounts', 'yaypricing' ),
			'Quantity'                                     => __( 'Quantity', 'yaypricing' ),
			'Price'                                        => __( 'Price', 'yaypricing' ),
			'Pricing table'                                => __( 'Pricing table', 'yaypricing' ),
			'Table position'                               => __( 'Table position', 'yaypricing' ),
			'Table title'                                  => __( 'Table title', 'yaypricing' ),
			'Ex: Quantity discounts'                       => __( 'Ex: Quantity discounts', 'yaypricing' ),
			'Quantity title'                               => __( 'Quantity title', 'yaypricing' ),
			'Ex: Quantity'                                 => __( 'Ex: Quantity', 'yaypricing' ),
			'Discount title'                               => __( 'Discount title', 'yaypricing' ),
			'Ex: Discount'                                 => __( 'Ex: Discount', 'yaypricing' ),
			'Price title'                                  => __( 'Price title', 'yaypricing' ),
			'Ex: Price'                                    => __( 'Ex: Price', 'yaypricing' ),
			'Border color'                                 => __( 'Border color', 'yaypricing' ),
			'Preview'                                      => __( 'Preview', 'yaypricing' ),
			'Reset'                                        => __( 'Reset', 'yaypricing' ),
			'Encourage notice'                             => __( 'Encourage notice', 'yaypricing' ),
			'Show notices after product description to encourage purchasing' => __( 'Show notices after product description to encourage purchasing', 'yaypricing' ),
			'Show notices at bottom of Cart page to encourage purchasing' => __( 'Show notices at bottom of Cart page to encourage purchasing', 'yaypricing' ),
			'Show notices at bottom of Checkout page to encourage purchasing' => __( 'Show notices at bottom of Checkout page to encourage purchasing', 'yaypricing' ),
			'Import successfully'                          => __( 'Import successfully', 'yaypricing' ),
			'Import failed'                                => __( 'Import failed', 'yaypricing' ),
			'Import/Export'                                => __( 'Import/Export', 'yaypricing' ),
			'Export rules'                                 => __( 'Export rules', 'yaypricing' ),
			'Choose file'                                  => __( 'Choose file', 'yaypricing' ),
			'Import'                                       => __( 'Import', 'yaypricing' ),
			'Countdown timer'                              => __( 'Countdown timer', 'yaypricing' ),
			'Show countdown timer'                         => __( 'Show countdown timer', 'yaypricing' ),
			'Discountable price range'                     => __( 'Discountable price range', 'yaypricing' ),
			'Current discount tier'                        => __( 'Current discount tier', 'yaypricing' ),
			'Next discount tier as if 1 more item is added' => __( 'Next discount tier as if 1 more item is added', 'yaypricing' ),
			'Product sale display'                         => __( 'Product sale display', 'yaypricing' ),
			'Show sale tag and discounted price as'        => __( 'Show sale tag and discounted price as', 'yaypricing' ),
			'Product price display'                        => __( 'Product price display', 'yaypricing' ),
			'Show product discounted price'                => __( 'Show product discounted price', 'yaypricing' ),
			'Replace product price with the discounted one' => __( 'Replace product price with the discounted one', 'yaypricing' ),
			'Show product regular price within discounted' => __( 'Show product regular price within discounted', 'yaypricing' ),
			'Regular price is displayed as strike-through text on product price' => __( 'Regular price is displayed as strike-through text on product price', 'yaypricing' ),
			'Saving amount'                                => __( 'Saving amount', 'yaypricing' ),
			'Show order saving amount'                     => __( 'Show order saving amount', 'yaypricing' ),
			'Show products saving amount on cart page (Only for cart shortcode).' => __( 'Show products saving amount on cart page (Only for cart shortcode).', 'yaypricing' ),
			'Position'                                     => __( 'Position', 'yaypricing' ),
			'Before order total'                           => __( 'Before order total', 'yaypricing' ),
			'After order total'                            => __( 'After order total', 'yaypricing' ),
			'General'                                      => __( 'General', 'yaypricing' ),
			'Discount based on'                            => __( 'Discount based on', 'yaypricing' ),
			'Disable product pricing rules when product is on sale' => __( 'Disable product pricing rules when product is on sale', 'yaypricing' ),
			'When product is on sale, it will not be discounted by product pricing rule.' => __( 'When product is on sale, it will not be discounted by product pricing rule.', 'yaypricing' ),
			'Prevent cart discount applied when Single use WC Coupon applied' => __( 'Prevent cart discount applied when Single use WC Coupon applied', 'yaypricing' ),
			'WC coupon cannot be applied when it is single use and cart items have discounted by YayPricing' => __( 'WC coupon cannot be applied when it is single use and cart items have discounted by YayPricing', 'yaypricing' ),
			'Show regular price on cart item'              => __( 'Show regular price on cart item', 'yaypricing' ),
			'Regular price is displayed as strike-through text on cart page and checkout page' => __( 'Regular price is displayed as strike-through text on cart page and checkout page', 'yaypricing' ),
			'Show original subtotal price on cart item'    => __( 'Show original subtotal price on cart item', 'yaypricing' ),
			'Original subtotal price is displayed as strike-through text. This setting cannot affect to WC Block' => __( 'Original subtotal price is displayed as strike-through text. This setting cannot affect to WC Block', 'yaypricing' ),
			'Combine cart discounts'                       => __( 'Combine cart discounts', 'yaypricing' ),
			'All rules will be calculated and combined into a single rule to apply in cart' => __( 'All rules will be calculated and combined into a single rule to apply in cart', 'yaypricing' ),
			'Use discount ID as coupon code'               => __( 'Use discount ID as coupon code', 'yaypricing' ),
			'Automatically generate cart discount ID to be used as a coupon code in the admin order details' => __( 'Automatically generate cart discount ID to be used as a coupon code in the admin order details', 'yaypricing' ),
			'Use cart discount together with Single use WC Coupon' => __( 'Use cart discount together with Single use WC Coupon', 'yaypricing' ),
			'Sale Tag'                                     => __( 'Sale Tag', 'yaypricing' ),
			'Show sale tag for sale products'              => __( 'Show sale tag for sale products', 'yaypricing' ),
			'Display a sale tag on product image on shop page and single product page' => __( 'Display a sale tag on product image on shop page and single product page', 'yaypricing' ),
			'Display a discount range tag on the sale tag' => __( 'Display a discount range tag on the sale tag', 'yaypricing' ),
			'Background color'                             => __( 'Background color', 'yaypricing' ),
			'Text color'                                   => __( 'Text color', 'yaypricing' ),
			'SALE!'                                        => __( 'SALE!', 'yaypricing' ),
			'Up to %s'                                     => __( 'Up to %s', 'yaypricing' ),
			'What'                                         => __( 'What', 'yaypricing' ),
			'Version'                                      => __( 'Version', 'yaypricing' ),
			'Shortcodes'                                   => __( 'Shortcodes', 'yaypricing' ),
			'Shortcode to load all products which has discount through YayPricing' => __( 'Shortcode to load all products which has discount through YayPricing', 'yaypricing' ),
			'Please paste it in your promotion page to show list on sale products' => __( 'Please paste it in your promotion page to show list on sale products', 'yaypricing' ),
			'Select rules for on sale products'            => __( 'Select rules for on sale products', 'yaypricing' ),
			'Apply all applicable rules'                   => __( 'Apply all applicable rules', 'yaypricing' ),
			'Apply the first applicable rule in your list' => __( 'Apply the first applicable rule in your list', 'yaypricing' ),
			'Apply the rule with minimum discount amount'  => __( 'Apply the rule with minimum discount amount', 'yaypricing' ),
			'Apply the rule with maximum discount amount'  => __( 'Apply the rule with maximum discount amount', 'yaypricing' ),
			'How the rules are applied'                    => __( 'How the rules are applied', 'yaypricing' ),
			'Apply to non discount product'                => __( 'Apply to non discount product', 'yaypricing' ),
			'Count quantity by'                            => __( 'Count quantity by', 'yaypricing' ),
			'Is repeat'                                    => __( 'Is repeat', 'yaypricing' ),
			'Discount will apply once or repeat after each quantities matching' => __( 'Discount will apply once or repeat after each quantities matching', 'yaypricing' ),
			'Buy'                                          => __( 'Buy', 'yaypricing' ),
			'Get'                                          => __( 'Get', 'yaypricing' ),
			'Free'                                         => __( 'Free', 'yaypricing' ),
			'Pricing type'                                 => __( 'Pricing type', 'yaypricing' ),
			'Fact: The maximum allowable flat price will be limited to the product price.' => __( 'Fact: The maximum allowable flat price will be limited to the product price.', 'yaypricing' ),
			'Pricing value'                                => __( 'Pricing value', 'yaypricing' ),
			'Maximum value'                                => __( 'Maximum value', 'yaypricing' ),
			'This adds a cap so that the discount amount will not exceed this amount' => __( 'This adds a cap so that the discount amount will not exceed this amount', 'yaypricing' ),
			'Using formula'                                => __( 'Using formula', 'yaypricing' ),
			'E.g: quantity: {n}*2, pricing: {n}*10 => Buy 2 items get 10$ discount. 4 items get 20$ discount, etc. Interpretation: {n} is the quantity of purchased items for a single product. ' => __( 'E.g: quantity: {n}*2, pricing: {n}*10 => Buy 2 items get 10$ discount. 4 items get 20$ discount, etc. Interpretation: {n} is the quantity of purchased items for a single product. ', 'yaypricing' ),
			'Simple discount'                              => __( 'Simple discount', 'yaypricing' ),
			'Product Collection'                           => __( 'Product Collection', 'yaypricing' ),
			'Choose your desired campaign'                 => __( 'Choose your desired campaign', 'yaypricing' ),
			'Cancel'                                       => __( 'Cancel', 'yaypricing' ),
			'Add Campaign'                                 => __( 'Add Campaign', 'yaypricing' ),
			'No campaign found'                            => __( 'No campaign found', 'yaypricing' ),
			'From'                                         => __( 'From', 'yaypricing' ),
			'to'                                           => __( 'to', 'yaypricing' ),
			'Leaving this blank means there will be no restriction on the number of items checked.' => __( 'Leaving this blank means there will be no restriction on the number of items checked.', 'yaypricing' ),
			'Discount will apply to single item. E.g: Buy 4 items, then discount 5$ each item. Or Buy 4 items, then each item has flat price 5$' => __( 'Discount will apply to single item. E.g: Buy 4 items, then discount 5$ each item. Or Buy 4 items, then each item has flat price 5$', 'yaypricing' ),
			'Pricing Ranges'                               => __( 'Pricing Ranges', 'yaypricing' ),
			'Import Data'                                  => __( 'Import Data', 'yaypricing' ),
			'You have no pricing range, please'            => __( 'You have no pricing range, please', 'yaypricing' ),
			'add one'                                      => __( 'add one', 'yaypricing' ),
			'Tiered Pricing Data Import'                   => __( 'Tiered Pricing Data Import', 'yaypricing' ),
			'Bulk Pricing Data Import'                     => __( 'Bulk Pricing Data Import', 'yaypricing' ),
			'Number of items required to be classified as a bundle' => __( 'Number of items required to be classified as a bundle', 'yaypricing' ),
			'Affected Items:'                              => __( 'Affected Items:', 'yaypricing' ),
			'E.g: Apply amount 50$ discount to whole bundle instead of 50$ to each bundle item.' => __( 'E.g: Apply amount 50$ discount to whole bundle instead of 50$ to each bundle item.', 'yaypricing' ),
			'Single item'                                  => __( 'Single item', 'yaypricing' ),
			'Whole bundle'                                 => __( 'Whole bundle', 'yaypricing' ),
			'E.g: quantity: {n}*2, pricing: {n}*10 => Buy 2 items get 10$ discount. 4 items get 20$ discount, etc. Interpretation: {n} is the time when the bundle is purchased. ' => __( 'E.g: quantity: {n}*2, pricing: {n}*10 => Buy 2 items get 10$ discount. 4 items get 20$ discount, etc. Interpretation: {n} is the time when the bundle is purchased. ', 'yaypricing' ),
			'Filter'                                       => __( 'Filter', 'yaypricing' ),
			'Apply discount to only first matching product' => __( 'Apply discount to only first matching product', 'yaypricing' ),
			'Show offer description in product page'       => __( 'Show offer description in product page', 'yaypricing' ),
			'Offer description for X'                      => __( 'Offer description for X', 'yaypricing' ),
			'Offer description for Y'                      => __( 'Offer description for Y', 'yaypricing' ),
			'Show tooltip on cart item price'              => __( 'Show tooltip on cart item price', 'yaypricing' ),
			'Enter your tooltip'                           => __( 'Enter your tooltip', 'yaypricing' ),
			'Enable schedule'                              => __( 'Enable schedule', 'yaypricing' ),
			'Recurring'                                    => __( 'Recurring', 'yaypricing' ),
			'This will grab the start/end '                => __( 'This will grab the start/end ', 'yaypricing' ),
			'Usage limits'                                 => __( 'Usage limits', 'yaypricing' ),
			'Once the discount/pricing rule is applied in the completed order, it is counted as a discount use. The rule will no longer apply if its use count reaches this number' => __( 'Once the discount/pricing rule is applied in the completed order, it is counted as a discount use. The rule will no longer apply if its use count reaches this number', 'yaypricing' ),
			'off'                                          => __( 'off', 'yaypricing' ),
			'if cart subtotal price is greater than 200'   => __( 'if cart subtotal price is greater than 200', 'yaypricing' ),
			'Get 10% off'                                  => __( 'Get 10% off', 'yaypricing' ),
			'if cart quantity is greater than 5'           => __( 'if cart quantity is greater than 5', 'yaypricing' ),
			'if the customers have 10 orders in past'      => __( 'if the customers have 10 orders in past', 'yaypricing' ),
			'And much more'                                => __( 'And much more', 'yaypricing' ),
			'Conditions'                                   => __( 'Conditions', 'yaypricing' ),
			'With conditions feature, you can decide when this rule will be used. It helps you create a product pricing more powerful' => __( 'With conditions feature, you can decide when this rule will be used. It helps you create a product pricing more powerful', 'yaypricing' ),
			'For example'                                  => __( 'For example', 'yaypricing' ),
			'Upgrade to unlock this feature'               => __( 'Upgrade to unlock this feature', 'yaypricing' ),
			'Pricing'                                      => __( 'Pricing', 'yaypricing' ),
			'Settings'                                     => __( 'Settings', 'yaypricing' ),
			'The Simple Discount enables you to set a fixed amount or percentage off the original price.' => __( 'The Simple Discount enables you to set a fixed amount or percentage off the original price.', 'yaypricing' ),
			'The Bulk Pricing rule incentivizes customers to purchase larger quantities of a product by offering tiered discounts based on the volume bought.' => __( 'The Bulk Pricing rule incentivizes customers to purchase larger quantities of a product by offering tiered discounts based on the volume bought.', 'yaypricing' ),
			'The Bundle Discount rule allows customers to save by purchasing multiple related products together as a package.' => __( 'The Bundle Discount rule allows customers to save by purchasing multiple related products together as a package.', 'yaypricing' ),
			'The BOGO (Buy One, Get One) rule entices customers by offering a free or discounted product when they purchase a specific item.' => __( 'The BOGO (Buy One, Get One) rule entices customers by offering a free or discounted product when they purchase a specific item.', 'yaypricing' ),
			'The Buy X, Get Y rule offers customers a strategic incentive to purchase a specified quantity of one product (X) in order to receive another product (Y) at a discount or for free.' => __( 'The Buy X, Get Y rule offers customers a strategic incentive to purchase a specified quantity of one product (X) in order to receive another product (Y) at a discount or for free.', 'yaypricing' ),
			'The Tiered Pricing rule enables businesses to set distinct price levels for a product based on specific quantity ranges, without applying discounts to quantities that do not meet those ranges.' => __( 'The Tiered Pricing rule enables businesses to set distinct price levels for a product based on specific quantity ranges, without applying discounts to quantities that do not meet those ranges.', 'yaypricing' ),
			'Name'                                         => __( 'Name', 'yaypricing' ),
			'Rule name'                                    => __( 'Rule name', 'yaypricing' ),
			'Rule type'                                    => __( 'Rule type', 'yaypricing' ),
			'Upload Image'                                 => __( 'Upload Image', 'yaypricing' ),
			'Source'                                       => __( 'Source', 'yaypricing' ),
			'Show HTML source'                             => __( 'Show HTML source', 'yaypricing' ),
			'Enter your description'                       => __( 'Enter your description', 'yaypricing' ),
			'Inactive'                                     => __( 'Inactive', 'yaypricing' ),
			'Running'                                      => __( 'Running', 'yaypricing' ),
			'Max use reached'                              => __( 'Max use reached', 'yaypricing' ),
			'Completed'                                    => __( 'Completed', 'yaypricing' ),
			'Scheduled'                                    => __( 'Scheduled', 'yaypricing' ),
			'Remove rule'                                  => __( 'Remove rule', 'yaypricing' ),
			'Do you want to remove'                        => __( 'Do you want to remove', 'yaypricing' ),
			'Remove'                                       => __( 'Remove', 'yaypricing' ),
			'Duplicate'                                    => __( 'Duplicate', 'yaypricing' ),
			'Combined condition is empty, please'          => __( 'Combined condition is empty, please', 'yaypricing' ),
			'All Product Pricing rules'                    => __( 'All Product Pricing rules', 'yaypricing' ),
			'Exclude Rules (Product pricing)'              => __( 'Exclude Rules (Product pricing)', 'yaypricing' ),
			'You don'                                      => __( 'You don', 'yaypricing' ),
			'Select at least one rule'                     => __( 'Select at least one rule', 'yaypricing' ),
			'Exclude by coupons'                           => __( 'Exclude by coupons', 'yaypricing' ),
			'Prevent product pricing rules being applied when specific coupons added' => __( 'Prevent product pricing rules being applied when specific coupons added', 'yaypricing' ),
			'Learn more'                                   => __( 'Learn more', 'yaypricing' ),
			'Coupons'                                      => __( 'Coupons', 'yaypricing' ),
			'Exclude selected rules when these coupons are applied' => __( 'Exclude selected rules when these coupons are applied', 'yaypricing' ),
			'All coupons'                                  => __( 'All coupons', 'yaypricing' ),
			'Select at least one coupon'                   => __( 'Select at least one coupon', 'yaypricing' ),
			'Exclude Rules'                                => __( 'Exclude Rules', 'yaypricing' ),
			'Select one rule to exclude'                   => __( 'Select one rule to exclude', 'yaypricing' ),
			'All Product Pricing Rules'                    => __( 'All Product Pricing Rules', 'yaypricing' ),
			'All Cart Discount Rules'                      => __( 'All Cart Discount Rules', 'yaypricing' ),
			'All Checkout Fee Rules'                       => __( 'All Checkout Fee Rules', 'yaypricing' ),
			'This rule is always used'                     => __( 'This rule is always used', 'yaypricing' ),
			'If you want to decide when this rule will be used, please' => __( 'If you want to decide when this rule will be used, please', 'yaypricing' ),
			'add a condition'                              => __( 'add a condition', 'yaypricing' ),
			'This rule will be used if'                    => __( 'This rule will be used if', 'yaypricing' ),
			'Any'                                          => __( 'Any', 'yaypricing' ),
			'All'                                          => __( 'All', 'yaypricing' ),
			'of these conditions is available.'            => __( 'of these conditions is available.', 'yaypricing' ),
			'Exclusions'                                   => __( 'Exclusions', 'yaypricing' ),
			'Product Collections'                          => __( 'Product Collections', 'yaypricing' ),
			'Go Pro'                                       => __( 'Go Pro', 'yaypricing' ),
			'On sale products'                             => __( 'On sale products', 'yaypricing' ),
			'All on sale products'                         => __( 'All on sale products', 'yaypricing' ),
			'Order saved amount'                           => __( 'Order saved amount', 'yaypricing' ),
			'Product pricing countdowns'                   => __( 'Product pricing countdowns', 'yaypricing' ),
			'Cart discount countdowns'                     => __( 'Cart discount countdowns', 'yaypricing' ),
			'Checkout fee countdowns'                      => __( 'Checkout fee countdowns', 'yaypricing' ),
			'Product offer description'                    => __( 'Product offer description', 'yaypricing' ),
			'Product sale tag'                             => __( 'Product sale tag', 'yaypricing' ),
			'Shortcode generator'                          => __( 'Shortcode generator', 'yaypricing' ),
			'Generate shortcode'                           => __( 'Generate shortcode', 'yaypricing' ),
			'Product'                                      => __( 'Product', 'yaypricing' ),
			'Status'                                       => __( 'Status', 'yaypricing' ),
			'In stock'                                     => __( 'In stock', 'yaypricing' ),
			'Selected products'                            => __( 'Selected products', 'yaypricing' ),
			'Loading products'                             => __( 'Loading products', 'yaypricing' ),
			'No product matched'                           => __( 'No product matched', 'yaypricing' ),
			'Show ad countdown timer to let customers know how much time is left until sales on products are over and helps boost your sale.' => __( 'Show ad countdown timer to let customers know how much time is left until sales on products are over and helps boost your sale.', 'yaypricing' ),
			'Contain a pitch of your products that your visitors go through and decide whether they want to buy.' => __( 'Contain a pitch of your products that your visitors go through and decide whether they want to buy.', 'yaypricing' ),
			'Encouraged notice is used to motivate customers to buy more items in order to receive a discount or other promotional offer. It is a marketing strategy aimed at increasing sales and customer loyalty.' => __( 'Encouraged notice is used to motivate customers to buy more items in order to receive a discount or other promotional offer. It is a marketing strategy aimed at increasing sales and customer loyalty.', 'yaypricing' ),
			'Shortcode copied'                             => __( 'Shortcode copied', 'yaypricing' ),
			'Discount type'                                => __( 'Discount type', 'yaypricing' ),
			'Discount value'                               => __( 'Discount value', 'yaypricing' ),
			'This adds a cap so that the discount amount will not exceed this amount. When discount type is ' => __( 'This adds a cap so that the discount amount will not exceed this amount. When discount type is ', 'yaypricing' ),
			'Show tooltip on cart discount'                => __( 'Show tooltip on cart discount', 'yaypricing' ),
			'Used'                                         => __( 'Used', 'yaypricing' ),
			'Add condition'                                => __( 'Add condition', 'yaypricing' ),
			'Default'                                      => __( 'Default', 'yaypricing' ),
			'Discount applies to the items specified below, starting from the left to right' => __( 'Discount applies to the items specified below, starting from the left to right', 'yaypricing' ),
			'Cheapest one'                                 => __( 'Cheapest one', 'yaypricing' ),
			'Discount applies to the items specified below, starting from the cheapest one' => __( 'Discount applies to the items specified below, starting from the cheapest one', 'yaypricing' ),
			'Most expensive one'                           => __( 'Most expensive one', 'yaypricing' ),
			'Discount applies to the items specified below, starting from the most expensive one' => __( 'Discount applies to the items specified below, starting from the most expensive one', 'yaypricing' ),
			'Buy Products'                                 => __( 'Buy Products', 'yaypricing' ),
			'Get Products'                                 => __( 'Get Products', 'yaypricing' ),
			'(Which products will get discount?)'          => __( '(Which products will get discount?)', 'yaypricing' ),
			'(X Products)'                                 => __( '(X Products)', 'yaypricing' ),
			'Item get type'                                => __( 'Item get type', 'yaypricing' ),
			'No product excluded. Please'                  => __( 'No product excluded. Please', 'yaypricing' ),
			'add product'                                  => __( 'add product', 'yaypricing' ),
			'to exclude.'                                  => __( 'to exclude.', 'yaypricing' ),
			'This rule is not assigned to any product. Please' => __( 'This rule is not assigned to any product. Please', 'yaypricing' ),
			'to assign it.'                                => __( 'to assign it.', 'yaypricing' ),
			'Exclude those products that match'            => __( 'Exclude those products that match', 'yaypricing' ),
			'This rule applies to those products that match' => __( 'This rule applies to those products that match', 'yaypricing' ),
			'of these filters'                             => __( 'of these filters', 'yaypricing' ),
			'View selected products'                       => __( 'View selected products', 'yaypricing' ),
			'In a combined condition, you must select the eligible products. Then, the values of cart amount and quantity of items are restricted to these filtered products in the same condition' => __( 'In a combined condition, you must select the eligible products. Then, the values of cart amount and quantity of items are restricted to these filtered products in the same condition', 'yaypricing' ),
			'The discount value. Example: “50%“ or “10$“'  => __( 'The discount value. Example: “50%“ or “10$“', 'yaypricing' ),
			'The calculated value of discount'             => __( 'The calculated value of discount', 'yaypricing' ),
			'Product price after discounting'              => __( 'Product price after discounting', 'yaypricing' ),
			'Name of the campaign'                         => __( 'Name of the campaign', 'yaypricing' ),
			'Timer clock, it will countdown to the schedule day' => __( 'Timer clock, it will countdown to the schedule day', 'yaypricing' ),
			'The action customer need to do to get the discount. Example: “buy more 100$” or “buy more 1 item of Product A” ' => __( 'The action customer need to do to get the discount. Example: “buy more 100$” or “buy more 1 item of Product A” ', 'yaypricing' ),
			'Current discounting product'                  => __( 'Current discounting product', 'yaypricing' ),
			'Copied'                                       => __( 'Copied', 'yaypricing' ),
			'Description'                                  => __( 'Description', 'yaypricing' ),
			'Variables'                                    => __( 'Variables', 'yaypricing' ),
			'Variable list'                                => __( 'Variable list', 'yaypricing' ),
			'Automatically add gift item(s) once the base product(s) are added to cart' => __( 'Automatically add gift item(s) once the base product(s) are added to cart', 'yaypricing' ),
			'Customers need to add the quantity of items specified below to their cart' => __( 'Customers need to add the quantity of items specified below to their cart', 'yaypricing' ),
			'More result'                                  => __( 'More result', 'yaypricing' ),
			'Select at least one product'                  => __( 'Select at least one product', 'yaypricing' ),
			'Select at least one variation'                => __( 'Select at least one variation', 'yaypricing' ),
			'Select at least one category'                 => __( 'Select at least one category', 'yaypricing' ),
			'Select at least one attribute'                => __( 'Select at least one attribute', 'yaypricing' ),
			'Select at least one taxonomy'                 => __( 'Select at least one taxonomy', 'yaypricing' ),
			'Select at least one tag'                      => __( 'Select at least one tag', 'yaypricing' ),
			'Select at least one role'                     => __( 'Select at least one role', 'yaypricing' ),
			'Select at least one customer'                 => __( 'Select at least one customer', 'yaypricing' ),
			'Select at least one region'                   => __( 'Select at least one region', 'yaypricing' ),
			'Select at least one payment'                  => __( 'Select at least one payment', 'yaypricing' ),
			'Select at least one value'                    => __( 'Select at least one value', 'yaypricing' ),
			'Fee type'                                     => __( 'Fee type', 'yaypricing' ),
			'Fee value'                                    => __( 'Fee value', 'yaypricing' ),
			'Show tooltip on checkout fee'                 => __( 'Show tooltip on checkout fee', 'yaypricing' ),
			'Apply to shipping'                            => __( 'Apply to shipping', 'yaypricing' ),
			'Custom Fee'                                   => __( 'Custom Fee', 'yaypricing' ),
			'Features'                                     => __( 'Features', 'yaypricing' ),
			'YayPricing Free'                              => __( 'YayPricing Free', 'yaypricing' ),
			'YayPricing Pro'                               => __( 'YayPricing Pro', 'yaypricing' ),
			'Allow switching gift products on cart page'   => __( 'Allow switching gift products on cart page', 'yaypricing' ),
			'Coupon Exclusions'                            => __( 'Coupon Exclusions', 'yaypricing' ),
			'This setting allows you to apply YayPricing'  => __( 'This setting allows you to apply YayPricing', 'yaypricing' ),
			'Analytics & reports'                          => __( 'Analytics & reports', 'yaypricing' ),
			'View charts and analytics for your pricing rules. You can see how a promotion campaign performs in a date range' => __( 'View charts and analytics for your pricing rules. You can see how a promotion campaign performs in a date range', 'yaypricing' ),
			'Product fee'                                  => __( 'Product fee', 'yaypricing' ),
			'Add handling fees or charge extra fees for product' => __( 'Add handling fees or charge extra fees for product', 'yaypricing' ),
			'Custom fees'                                  => __( 'Custom fees', 'yaypricing' ),
			'Add handling fees or charge extra fees based on shipping region, payment method, and other criteria' => __( 'Add handling fees or charge extra fees based on shipping region, payment method, and other criteria', 'yaypricing' ),
			'Custom Fee based on Shipping Fee'             => __( 'Custom Fee based on Shipping Fee', 'yaypricing' ),
			'Add handling fees which is calculated based on Shipping fee' => __( 'Add handling fees which is calculated based on Shipping fee', 'yaypricing' ),
			'Product pricing conditions'                   => __( 'Product pricing conditions', 'yaypricing' ),
			'Set up additional conditions that need to be met before the promotion is applied' => __( 'Set up additional conditions that need to be met before the promotion is applied', 'yaypricing' ),
			'Combined conditions'                          => __( 'Combined conditions', 'yaypricing' ),
			'Create cart discount conditions that are restricted to those cart items. For example, minimum spend on specific product categories will get the discount' => __( 'Create cart discount conditions that are restricted to those cart items. For example, minimum spend on specific product categories will get the discount', 'yaypricing' ),
			'Use shortcode to output all discounted products on any WordPress page/post' => __( 'Use shortcode to output all discounted products on any WordPress page/post', 'yaypricing' ),
			'Sales triggers'                               => __( 'Sales triggers', 'yaypricing' ),
			'Upselling notices'                            => __( 'Upselling notices', 'yaypricing' ),
			'VIP live chat support'                        => __( 'VIP live chat support', 'yaypricing' ),
			'Latest features & updates'                    => __( 'Latest features & updates', 'yaypricing' ),
			'BOGO'                                         => __( 'BOGO', 'yaypricing' ),
			'Buy X Get Y'                                  => __( 'Buy X Get Y', 'yaypricing' ),
			'Bulk discounts'                               => __( 'Bulk discounts', 'yaypricing' ),
			'Scheduled discounts'                          => __( 'Scheduled discounts', 'yaypricing' ),
			'User role discounts'                          => __( 'User role discounts', 'yaypricing' ),
			'Free shipping'                                => __( 'Free shipping', 'yaypricing' ),
			'Your current'                                 => __( 'Your current', 'yaypricing' ),
			'Get YayPricing Pro'                           => __( 'Get YayPricing Pro', 'yaypricing' ),
			'Consider upgrading to'                        => __( 'Consider upgrading to', 'yaypricing' ),
			'It would be the best move you can make for your ecommerce store. Check it out!' => __( 'It would be the best move you can make for your ecommerce store. Check it out!', 'yaypricing' ),
			'Manage Exclude Rule'                          => __( 'Manage Exclude Rule', 'yaypricing' ),
			'Create rule to decide which products will not be affected by Product pricing rules.' => __( 'Create rule to decide which products will not be affected by Product pricing rules.', 'yaypricing' ),
			'Add Your First Rule'                          => __( 'Add Your First Rule', 'yaypricing' ),
			'Add Rule'                                     => __( 'Add Rule', 'yaypricing' ),
			'Manage Cart Discounts Rule'                   => __( 'Manage Cart Discounts Rule', 'yaypricing' ),
			'Cart discounts rules is used to create cart discount coupons that apply at checkout. You can also combine discount at Settings section.' => __( 'Cart discounts rules is used to create cart discount coupons that apply at checkout. You can also combine discount at Settings section.', 'yaypricing' ),
			'Manage Product Pricing Rule'                  => __( 'Manage Product Pricing Rule', 'yaypricing' ),
			'Create product pricing rules that affect price of products. You can also create product fee or discount.' => __( 'Create product pricing rules that affect price of products. You can also create product fee or discount.', 'yaypricing' ),
			'Manage Checkout Fees Rule'                    => __( 'Manage Checkout Fees Rule', 'yaypricing' ),
			'Fee rules is used to affect fees that apply at checkout.' => __( 'Fee rules is used to affect fees that apply at checkout.', 'yaypricing' ),
			'Save failed'                                  => __( 'Save failed', 'yaypricing' ),
			'Saved'                                        => __( 'Saved', 'yaypricing' ),
			'Save'                                         => __( 'Save', 'yaypricing' ),
			'With Product Collections, you can easily create and manage groups of product filters, allowing you to apply multiple filters with a single click.' => __( 'With Product Collections, you can easily create and manage groups of product filters, allowing you to apply multiple filters with a single click.', 'yaypricing' ),
			'Imported rule'                                => __( 'Imported rule', 'yaypricing' ),
		);
	}
}
