<?php
/**
 * @var $args
 */

$settings = $args['settings'] ?? new stdClass();
$preview  = array();

// XML Sitemap
if ( $settings->enable_sitemap ) {
	$items[] = array(
		'label' => __( 'XML Sitemap', 'xml-sitemap-generator-for-google' ),
		'url'   => sgg_get_sitemap_url( $settings->sitemap_url, 'sitemap_xml' ),
	);
}

// HTML Sitemap (Pro)
if ( sgg_pro_enabled() && $settings->enable_html_sitemap ) {
	$items[] = array(
		'label' => __( 'HTML Sitemap', 'xml-sitemap-generator-for-google' ),
		'url'   => sgg_get_sitemap_url( $settings->html_sitemap_url, 'sitemap_html' ),
	);
}

// Google News
if ( $settings->enable_google_news ) {
	$items[] = array(
		'label' => __( 'Google News', 'xml-sitemap-generator-for-google' ),
		'url'   => sgg_get_sitemap_url( $settings->google_news_url, 'google_news' ),
	);
}

// Image Sitemap
if ( $settings->enable_image_sitemap ) {
	$items[] = array(
		'label' => __( 'Image Sitemap', 'xml-sitemap-generator-for-google' ),
		'url'   => sgg_get_sitemap_url( $settings->image_sitemap_url, 'image_sitemap' ),
	);
}

// Video Sitemap
if ( $settings->enable_video_sitemap ) {
	$items[] = array(
		'label' => __( 'Video Sitemap', 'xml-sitemap-generator-for-google' ),
		'url'   => sgg_get_sitemap_url( $settings->video_sitemap_url, 'video_sitemap' ),
	);
}

$tools = array();

// IndexNow
if ( $settings->enable_indexnow ) {
	$tools[] = array(
		'name'  => 'sgg-indexnow',
		'label' => __( 'Ping IndexNow Protocol', 'xml-sitemap-generator-for-google' ),
		'class' => 'button',
	);
}

// Flush Rewrite Rules
$tools[] = array(
	'name'  => 'sgg-flush-rewrite-rules',
	'label' => __( 'Flush Rewrite Rules', 'xml-sitemap-generator-for-google' ),
	'class' => 'button',
);

// Clear Cache
if ( $settings->enable_cache ) {
	$tools[] = array(
		'name'  => 'sgg-clear-cache',
		'label' => __( 'Clear Sitemaps Cache', 'xml-sitemap-generator-for-google' ),
		'class' => 'button button-link-delete',
	);
}

?>

<div class="grim-header">
	<div class="grim-section grim-nav">
		<div class="grim-nav-wrapper">
			<div class="grim-nav-wrapper-info">
				<div class="grim-nav-wrapper-info-logo">
					<img src="<?php echo esc_url( plugins_url( 'assets/images/sgg-logo.svg', GRIM_SG_FILE ) ); ?>"
						alt="<?php esc_attr_e( 'XML logo', 'xml-sitemap-generator-for-google' ); ?>"
						width="60" height="60"/>
				</div>
				<div class="grim-nav-wrapper-info-title">
					<?php esc_html_e( 'Dynamic XML Sitemaps Generator For Google' ); ?>
				</div>
			</div>
			<div class="grim-settings-search">
				<div class="grim-settings-search-input-wrapper">
					<input type="search" class="grim-input" id="grim-settings-search-input" placeholder="<?php esc_attr_e( 'Search settings...', 'xml-sitemap-generator-for-google' ); ?>">
					<div class="grim-settings-search-cansel grim-button white">
						<span><?php esc_html_e( 'Cancel', 'xml-sitemap-generator-for-google' ); ?></span>
					</div>
				</div>
				<div class="grim-search-results" id="grim-search-results">
					<div class="grim-search-results-list"></div>
				</div>
			</div>
			<div class="grim-nav-wrapper-actions">
				<div class="grim-search-action">
					<div class="grim-search-action-btn">
						<i class="grim-icon-search"></i>
					</div>
				</div>
				<?php if ( ! empty( $tools ) ) : ?>
					<div class="grim-dropdown grim-dropdown-xs-small">
						<div class="grim-dropdown__trigger">
							<span><?php esc_html_e( 'Tools', 'xml-sitemap-generator-for-google' ); ?></span>
							<i class="grim-icon-chevron-down"></i>
						</div>
						<div class="grim-options">
							<?php foreach ( $tools as $tool ) : ?>
								<div class="grim-option">
									<input type="hidden" name="<?php echo esc_attr( $tool['name'] ); ?>" value="">
									<input
										type="submit"
										id="<?php echo esc_attr( $tool['name'] ); ?>"
										name="<?php echo esc_attr( $tool['name'] ); ?>-button"
										value="<?php echo esc_attr( $tool['label'] ); ?>"
										class="<?php echo esc_attr( $tool['class'] ); ?>"
									>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $items ) ) : ?>
					<div class="grim-dropdown grim-dropdown-max-content">
						<div class="grim-dropdown__trigger">
							<span><?php esc_html_e( 'Preview', 'xml-sitemap-generator-for-google' ); ?></span>
							<i class="grim-icon-chevron-down"></i>
						</div>
						<div class="grim-options">
							<?php foreach ( $items as $item ) : ?>
								<div class="grim-option">
									<a href="<?php echo esc_url( $item['url'] ); ?>" target="_blank">
										<?php echo esc_html( $item['label'] ); ?>
									</a>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				<?php endif; ?>
				<button type="submit" name="submit" class="grim-button secondary">
					<span><?php esc_html_e( 'Save changes', 'xml-sitemap-generator-for-google' ); ?></span>
				</button>
			</div>
		</div>
		<nav class="grim-nav-tab nav-tab-wrapper">
			<a href="#" class="grim-nav-tab-item nav-tab nav-tab-active" data-id="general"><i class="grim-icon-home"></i><?php esc_html_e( 'General', 'xml-sitemap-generator-for-google' ); ?></a>
			<a href="#" class="grim-nav-tab-item nav-tab" data-id="google-news"><i class="grim-icon-google"></i><?php esc_html_e( 'Google News', 'xml-sitemap-generator-for-google' ); ?></a>
			<a href="#" class="grim-nav-tab-item nav-tab" data-id="image-sitemap"><i class="grim-icon-image"></i><?php esc_html_e( 'Image Sitemap', 'xml-sitemap-generator-for-google' ); ?></a>
			<a href="#" class="grim-nav-tab-item nav-tab" data-id="video-sitemap"><i class="grim-icon-play-circle"></i><?php esc_html_e( 'Video Sitemap', 'xml-sitemap-generator-for-google' ); ?></a>
			<a href="#" class="grim-nav-tab-item nav-tab" data-id="advanced"><i class="grim-icon-sliders-horizontal"></i><?php esc_html_e( 'Advanced', 'xml-sitemap-generator-for-google' ); ?></a>
		</nav>
	</div>
</div>
