<?php
$plugin_actions = array(
	array(
		'title' => esc_html__( 'Documentation', 'xml-sitemap-generator-for-google' ),
		'icon'  => 'grim-icon-file-text',
		'link'  => 'https://wpgrim.com/docs/google-xml-sitemaps-generator/?utm_source=sgg-plugin&utm_medium=documentation&utm_campaign=xml_sitemap',
	),
	array(
		'title' => esc_html__( 'Support Forum', 'xml-sitemap-generator-for-google' ),
		'icon'  => 'grim-icon-help',
		'link'  => esc_url( sgg_get_support_url() ),
	),
	array(
		'title' =>	sprintf(
				esc_html__( 'Rate %s', 'xml-sitemap-generator-for-google' ),
				'<strong>' . esc_html__( '★★★★★', 'xml-sitemap-generator-for-google' ) . '</strong>'
				),
		'icon'  => 'grim-icon-star',
		'link'  => esc_url( sgg_get_review_url() ),
		'class' => 'grim-rate-button',
	),
);

if ( sgg_pro_enabled() ) {
	array_unshift( $plugin_actions, array(
		'title'  => esc_html__( 'Account & Premium Support', 'xml-sitemap-generator-for-google' ),
		'icon'   => 'grim-icon-user',
		'link'   => 'https://wpgrim.com/account?utm_source=sgg-plugin&utm_medium=account&utm_campaign=xml_sitemap',
	) );
}

$links = array(
	array(
		'title' => esc_html__( 'Google Search Console', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://search.google.com/search-console',
	),
	array(
		'title' => esc_html__( 'Google News Help Center', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://support.google.com/googlenews/',
	),
	array(
		'title' => esc_html__( 'Show up in Google News', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://support.google.com/news/publisher-center/answer/9607025',
	),
	array(
		'title' => esc_html__( 'IndexNow Protocol', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://www.indexnow.org/',
	),
	array(
		'title' => esc_html__( 'Bing Webmaster Tools', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://www.bing.com/webmasters',
	),
	array(
		'title' => esc_html__( 'Yandex Webmaster', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://webmaster.yandex.com/sites/',
	),
	array(
		'title' => esc_html__( 'XML Sitemap Validator', 'xml-sitemap-generator-for-google' ),
		'link'  => 'https://www.xml-sitemaps.com/validate-xml-sitemap.html',
	),
);

?>

<div class="grim-section grim-footer">
	<div class="grim-footer-wrapper-info">
		<div class="grim-footer-wrapper-info-logo">
			<img src="<?php echo esc_url( plugins_url( 'assets/images/sgg-logo.svg', GRIM_SG_FILE ) ); ?>"
				 alt="<?php esc_attr_e( 'XML logo', 'xml-sitemap-generator-for-google' ); ?>"
				 width="60" height="60"/>
		</div>
		<div class="grim-footer-wrapper-info-title">
			<?php esc_html_e( 'Dynamic XML Sitemaps Generator For Google' ); ?>
		</div>
	</div>
	<div class="grim-footer-actions">
		<?php foreach ( $plugin_actions as $action ) : ?>
			<div class="grim-footer-actions-item">
				<a class="grim-button white <?php echo ! empty( $action['class'] ) ? esc_attr( $action['class'] ) : ''; ?>" href="<?php echo esc_url( $action['link'] ); ?>" target="_blank">
					<span>
						<i class="<?php echo esc_attr( $action['icon'] ); ?>"></i><?php echo wp_kses_post( $action['title'] ); ?>
					</span>
				</a>
			</div>
		<?php endforeach; ?>
	</div>
	<div class="grim-footer-links">
		<?php foreach ( $links as $link ) : ?>
			<a class="grim-footer-links-item" target="_blank" href="<?php echo esc_url( $link['link'] ); ?>"><?php echo esc_html( $link['title'] ); ?></a>
		<?php endforeach; ?>
	</div>
</div>
