<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsUpdateScheduledInstall File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* WindowsUpdateScheduledInstall class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsUpdateScheduledInstall extends WindowsUpdateInstallScheduleType
{
    /**
     * Set the @odata.type since this type is immediately descended from an abstract
     * type that is referenced as the type in an entity.
     * @param array $propDict The property dictionary
     */
    public function __construct($propDict = array())
    {
        parent::__construct($propDict);
        $this->setODataType("#microsoft.graph.windowsUpdateScheduledInstall");
    }
    /**
     * Gets the scheduledInstallDay
     * Scheduled Install Day in week. Possible values are: userDefined, everyday, sunday, monday, tuesday, wednesday, thursday, friday, saturday.
     *
     * @return WeeklySchedule|null The scheduledInstallDay
     */
    public function getScheduledInstallDay()
    {
        if (array_key_exists("scheduledInstallDay", $this->_propDict)) {
            if (is_a($this->_propDict["scheduledInstallDay"], "XCloner\\Microsoft\\Graph\\Model\\WeeklySchedule") || is_null($this->_propDict["scheduledInstallDay"])) {
                return $this->_propDict["scheduledInstallDay"];
            } else {
                $this->_propDict["scheduledInstallDay"] = new WeeklySchedule($this->_propDict["scheduledInstallDay"]);
                return $this->_propDict["scheduledInstallDay"];
            }
        }
        return null;
    }
    /**
     * Sets the scheduledInstallDay
     * Scheduled Install Day in week. Possible values are: userDefined, everyday, sunday, monday, tuesday, wednesday, thursday, friday, saturday.
     *
     * @param WeeklySchedule $val The value to assign to the scheduledInstallDay
     *
     * @return WindowsUpdateScheduledInstall The WindowsUpdateScheduledInstall
     */
    public function setScheduledInstallDay($val)
    {
        $this->_propDict["scheduledInstallDay"] = $val;
        return $this;
    }
    /**
     * Gets the scheduledInstallTime
     * Scheduled Install Time during day
     *
     * @return TimeOfDay|null The scheduledInstallTime
     */
    public function getScheduledInstallTime()
    {
        if (array_key_exists("scheduledInstallTime", $this->_propDict)) {
            if (is_a($this->_propDict["scheduledInstallTime"], "XCloner\\Microsoft\\Graph\\Model\\TimeOfDay") || is_null($this->_propDict["scheduledInstallTime"])) {
                return $this->_propDict["scheduledInstallTime"];
            } else {
                $this->_propDict["scheduledInstallTime"] = new TimeOfDay($this->_propDict["scheduledInstallTime"]);
                return $this->_propDict["scheduledInstallTime"];
            }
        }
        return null;
    }
    /**
     * Sets the scheduledInstallTime
     * Scheduled Install Time during day
     *
     * @param TimeOfDay $val The value to assign to the scheduledInstallTime
     *
     * @return WindowsUpdateScheduledInstall The WindowsUpdateScheduledInstall
     */
    public function setScheduledInstallTime($val)
    {
        $this->_propDict["scheduledInstallTime"] = $val;
        return $this;
    }
}
