<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* RoleAssignment File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* RoleAssignment class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class RoleAssignment extends Entity
{
    /**
     * Gets the description
     * Description of the Role Assignment.
     *
     * @return string|null The description
     */
    public function getDescription()
    {
        if (array_key_exists("description", $this->_propDict)) {
            return $this->_propDict["description"];
        } else {
            return null;
        }
    }
    /**
     * Sets the description
     * Description of the Role Assignment.
     *
     * @param string $val The description
     *
     * @return RoleAssignment
     */
    public function setDescription($val)
    {
        $this->_propDict["description"] = $val;
        return $this;
    }
    /**
     * Gets the displayName
     * The display or friendly name of the role Assignment.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * The display or friendly name of the role Assignment.
     *
     * @param string $val The displayName
     *
     * @return RoleAssignment
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the resourceScopes
     * List of ids of role scope member security groups.  These are IDs from Azure Active Directory.
     *
     * @return array|null The resourceScopes
     */
    public function getResourceScopes()
    {
        if (array_key_exists("resourceScopes", $this->_propDict)) {
            return $this->_propDict["resourceScopes"];
        } else {
            return null;
        }
    }
    /**
     * Sets the resourceScopes
     * List of ids of role scope member security groups.  These are IDs from Azure Active Directory.
     *
     * @param string[] $val The resourceScopes
     *
     * @return RoleAssignment
     */
    public function setResourceScopes($val)
    {
        $this->_propDict["resourceScopes"] = $val;
        return $this;
    }
    /**
     * Gets the roleDefinition
     * Role definition this assignment is part of.
     *
     * @return RoleDefinition|null The roleDefinition
     */
    public function getRoleDefinition()
    {
        if (array_key_exists("roleDefinition", $this->_propDict)) {
            if (is_a($this->_propDict["roleDefinition"], "XCloner\\Microsoft\\Graph\\Model\\RoleDefinition") || is_null($this->_propDict["roleDefinition"])) {
                return $this->_propDict["roleDefinition"];
            } else {
                $this->_propDict["roleDefinition"] = new RoleDefinition($this->_propDict["roleDefinition"]);
                return $this->_propDict["roleDefinition"];
            }
        }
        return null;
    }
    /**
     * Sets the roleDefinition
     * Role definition this assignment is part of.
     *
     * @param RoleDefinition $val The roleDefinition
     *
     * @return RoleAssignment
     */
    public function setRoleDefinition($val)
    {
        $this->_propDict["roleDefinition"] = $val;
        return $this;
    }
}
