<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ProvisioningSystem File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* ProvisioningSystem class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ProvisioningSystem extends Identity
{
    /**
     * Gets the details
     * Details of the system.
     *
     * @return DetailsInfo|null The details
     */
    public function getDetails()
    {
        if (array_key_exists("details", $this->_propDict)) {
            if (is_a($this->_propDict["details"], "XCloner\\Microsoft\\Graph\\Model\\DetailsInfo") || is_null($this->_propDict["details"])) {
                return $this->_propDict["details"];
            } else {
                $this->_propDict["details"] = new DetailsInfo($this->_propDict["details"]);
                return $this->_propDict["details"];
            }
        }
        return null;
    }
    /**
     * Sets the details
     * Details of the system.
     *
     * @param DetailsInfo $val The value to assign to the details
     *
     * @return ProvisioningSystem The ProvisioningSystem
     */
    public function setDetails($val)
    {
        $this->_propDict["details"] = $val;
        return $this;
    }
}
