<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ManagedIOSLobApp File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* ManagedIOSLobApp class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ManagedIOSLobApp extends ManagedMobileLobApp
{
    /**
     * Gets the applicableDeviceType
     * The iOS architecture for which this app can run on.
     *
     * @return IosDeviceType|null The applicableDeviceType
     */
    public function getApplicableDeviceType()
    {
        if (array_key_exists("applicableDeviceType", $this->_propDict)) {
            if (is_a($this->_propDict["applicableDeviceType"], "XCloner\\Microsoft\\Graph\\Model\\IosDeviceType") || is_null($this->_propDict["applicableDeviceType"])) {
                return $this->_propDict["applicableDeviceType"];
            } else {
                $this->_propDict["applicableDeviceType"] = new IosDeviceType($this->_propDict["applicableDeviceType"]);
                return $this->_propDict["applicableDeviceType"];
            }
        }
        return null;
    }
    /**
     * Sets the applicableDeviceType
     * The iOS architecture for which this app can run on.
     *
     * @param IosDeviceType $val The applicableDeviceType
     *
     * @return ManagedIOSLobApp
     */
    public function setApplicableDeviceType($val)
    {
        $this->_propDict["applicableDeviceType"] = $val;
        return $this;
    }
    /**
     * Gets the buildNumber
     * The build number of managed iOS Line of Business (LoB) app.
     *
     * @return string|null The buildNumber
     */
    public function getBuildNumber()
    {
        if (array_key_exists("buildNumber", $this->_propDict)) {
            return $this->_propDict["buildNumber"];
        } else {
            return null;
        }
    }
    /**
     * Sets the buildNumber
     * The build number of managed iOS Line of Business (LoB) app.
     *
     * @param string $val The buildNumber
     *
     * @return ManagedIOSLobApp
     */
    public function setBuildNumber($val)
    {
        $this->_propDict["buildNumber"] = $val;
        return $this;
    }
    /**
     * Gets the bundleId
     * The Identity Name.
     *
     * @return string|null The bundleId
     */
    public function getBundleId()
    {
        if (array_key_exists("bundleId", $this->_propDict)) {
            return $this->_propDict["bundleId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the bundleId
     * The Identity Name.
     *
     * @param string $val The bundleId
     *
     * @return ManagedIOSLobApp
     */
    public function setBundleId($val)
    {
        $this->_propDict["bundleId"] = $val;
        return $this;
    }
    /**
     * Gets the expirationDateTime
     * The expiration time.
     *
     * @return \DateTime|null The expirationDateTime
     */
    public function getExpirationDateTime()
    {
        if (array_key_exists("expirationDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["expirationDateTime"], "\\DateTime") || is_null($this->_propDict["expirationDateTime"])) {
                return $this->_propDict["expirationDateTime"];
            } else {
                $this->_propDict["expirationDateTime"] = new \DateTime($this->_propDict["expirationDateTime"]);
                return $this->_propDict["expirationDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the expirationDateTime
     * The expiration time.
     *
     * @param \DateTime $val The expirationDateTime
     *
     * @return ManagedIOSLobApp
     */
    public function setExpirationDateTime($val)
    {
        $this->_propDict["expirationDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the minimumSupportedOperatingSystem
     * The value for the minimum applicable operating system.
     *
     * @return IosMinimumOperatingSystem|null The minimumSupportedOperatingSystem
     */
    public function getMinimumSupportedOperatingSystem()
    {
        if (array_key_exists("minimumSupportedOperatingSystem", $this->_propDict)) {
            if (is_a($this->_propDict["minimumSupportedOperatingSystem"], "XCloner\\Microsoft\\Graph\\Model\\IosMinimumOperatingSystem") || is_null($this->_propDict["minimumSupportedOperatingSystem"])) {
                return $this->_propDict["minimumSupportedOperatingSystem"];
            } else {
                $this->_propDict["minimumSupportedOperatingSystem"] = new IosMinimumOperatingSystem($this->_propDict["minimumSupportedOperatingSystem"]);
                return $this->_propDict["minimumSupportedOperatingSystem"];
            }
        }
        return null;
    }
    /**
     * Sets the minimumSupportedOperatingSystem
     * The value for the minimum applicable operating system.
     *
     * @param IosMinimumOperatingSystem $val The minimumSupportedOperatingSystem
     *
     * @return ManagedIOSLobApp
     */
    public function setMinimumSupportedOperatingSystem($val)
    {
        $this->_propDict["minimumSupportedOperatingSystem"] = $val;
        return $this;
    }
    /**
     * Gets the versionNumber
     * The version number of managed iOS Line of Business (LoB) app.
     *
     * @return string|null The versionNumber
     */
    public function getVersionNumber()
    {
        if (array_key_exists("versionNumber", $this->_propDict)) {
            return $this->_propDict["versionNumber"];
        } else {
            return null;
        }
    }
    /**
     * Sets the versionNumber
     * The version number of managed iOS Line of Business (LoB) app.
     *
     * @param string $val The versionNumber
     *
     * @return ManagedIOSLobApp
     */
    public function setVersionNumber($val)
    {
        $this->_propDict["versionNumber"] = $val;
        return $this;
    }
}
