<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MailTipsError File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MailTipsError class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MailTipsError extends Entity
{
    /**
     * Gets the code
     * The error code.
     *
     * @return string|null The code
     */
    public function getCode()
    {
        if (array_key_exists("code", $this->_propDict)) {
            return $this->_propDict["code"];
        } else {
            return null;
        }
    }
    /**
     * Sets the code
     * The error code.
     *
     * @param string $val The value of the code
     *
     * @return MailTipsError
     */
    public function setCode($val)
    {
        $this->_propDict["code"] = $val;
        return $this;
    }
    /**
     * Gets the message
     * The error message.
     *
     * @return string|null The message
     */
    public function getMessage()
    {
        if (array_key_exists("message", $this->_propDict)) {
            return $this->_propDict["message"];
        } else {
            return null;
        }
    }
    /**
     * Sets the message
     * The error message.
     *
     * @param string $val The value of the message
     *
     * @return MailTipsError
     */
    public function setMessage($val)
    {
        $this->_propDict["message"] = $val;
        return $this;
    }
}
