<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MacOSGeneralDeviceConfiguration File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MacOSGeneralDeviceConfiguration class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MacOSGeneralDeviceConfiguration extends DeviceConfiguration
{
    /**
     * Gets the compliantAppListType
     * List that is in the CompliantAppsList. Possible values are: none, appsInListCompliant, appsNotInListCompliant.
     *
     * @return AppListType|null The compliantAppListType
     */
    public function getCompliantAppListType()
    {
        if (array_key_exists("compliantAppListType", $this->_propDict)) {
            if (is_a($this->_propDict["compliantAppListType"], "XCloner\\Microsoft\\Graph\\Model\\AppListType") || is_null($this->_propDict["compliantAppListType"])) {
                return $this->_propDict["compliantAppListType"];
            } else {
                $this->_propDict["compliantAppListType"] = new AppListType($this->_propDict["compliantAppListType"]);
                return $this->_propDict["compliantAppListType"];
            }
        }
        return null;
    }
    /**
     * Sets the compliantAppListType
     * List that is in the CompliantAppsList. Possible values are: none, appsInListCompliant, appsNotInListCompliant.
     *
     * @param AppListType $val The compliantAppListType
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setCompliantAppListType($val)
    {
        $this->_propDict["compliantAppListType"] = $val;
        return $this;
    }
    /**
     * Gets the compliantAppsList
     * List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
     *
     * @return array|null The compliantAppsList
     */
    public function getCompliantAppsList()
    {
        if (array_key_exists("compliantAppsList", $this->_propDict)) {
            return $this->_propDict["compliantAppsList"];
        } else {
            return null;
        }
    }
    /**
     * Sets the compliantAppsList
     * List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
     *
     * @param AppListItem[] $val The compliantAppsList
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setCompliantAppsList($val)
    {
        $this->_propDict["compliantAppsList"] = $val;
        return $this;
    }
    /**
     * Gets the emailInDomainSuffixes
     * An email address lacking a suffix that matches any of these strings will be considered out-of-domain.
     *
     * @return array|null The emailInDomainSuffixes
     */
    public function getEmailInDomainSuffixes()
    {
        if (array_key_exists("emailInDomainSuffixes", $this->_propDict)) {
            return $this->_propDict["emailInDomainSuffixes"];
        } else {
            return null;
        }
    }
    /**
     * Sets the emailInDomainSuffixes
     * An email address lacking a suffix that matches any of these strings will be considered out-of-domain.
     *
     * @param string[] $val The emailInDomainSuffixes
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setEmailInDomainSuffixes($val)
    {
        $this->_propDict["emailInDomainSuffixes"] = $val;
        return $this;
    }
    /**
     * Gets the passwordBlockSimple
     * Block simple passwords.
     *
     * @return bool|null The passwordBlockSimple
     */
    public function getPasswordBlockSimple()
    {
        if (array_key_exists("passwordBlockSimple", $this->_propDict)) {
            return $this->_propDict["passwordBlockSimple"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordBlockSimple
     * Block simple passwords.
     *
     * @param bool $val The passwordBlockSimple
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordBlockSimple($val)
    {
        $this->_propDict["passwordBlockSimple"] = boolval($val);
        return $this;
    }
    /**
     * Gets the passwordExpirationDays
     * Number of days before the password expires.
     *
     * @return int|null The passwordExpirationDays
     */
    public function getPasswordExpirationDays()
    {
        if (array_key_exists("passwordExpirationDays", $this->_propDict)) {
            return $this->_propDict["passwordExpirationDays"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordExpirationDays
     * Number of days before the password expires.
     *
     * @param int $val The passwordExpirationDays
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordExpirationDays($val)
    {
        $this->_propDict["passwordExpirationDays"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordMinimumCharacterSetCount
     * Number of character sets a password must contain. Valid values 0 to 4
     *
     * @return int|null The passwordMinimumCharacterSetCount
     */
    public function getPasswordMinimumCharacterSetCount()
    {
        if (array_key_exists("passwordMinimumCharacterSetCount", $this->_propDict)) {
            return $this->_propDict["passwordMinimumCharacterSetCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordMinimumCharacterSetCount
     * Number of character sets a password must contain. Valid values 0 to 4
     *
     * @param int $val The passwordMinimumCharacterSetCount
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordMinimumCharacterSetCount($val)
    {
        $this->_propDict["passwordMinimumCharacterSetCount"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordMinimumLength
     * Minimum length of passwords.
     *
     * @return int|null The passwordMinimumLength
     */
    public function getPasswordMinimumLength()
    {
        if (array_key_exists("passwordMinimumLength", $this->_propDict)) {
            return $this->_propDict["passwordMinimumLength"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordMinimumLength
     * Minimum length of passwords.
     *
     * @param int $val The passwordMinimumLength
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordMinimumLength($val)
    {
        $this->_propDict["passwordMinimumLength"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordMinutesOfInactivityBeforeLock
     * Minutes of inactivity required before a password is required.
     *
     * @return int|null The passwordMinutesOfInactivityBeforeLock
     */
    public function getPasswordMinutesOfInactivityBeforeLock()
    {
        if (array_key_exists("passwordMinutesOfInactivityBeforeLock", $this->_propDict)) {
            return $this->_propDict["passwordMinutesOfInactivityBeforeLock"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordMinutesOfInactivityBeforeLock
     * Minutes of inactivity required before a password is required.
     *
     * @param int $val The passwordMinutesOfInactivityBeforeLock
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordMinutesOfInactivityBeforeLock($val)
    {
        $this->_propDict["passwordMinutesOfInactivityBeforeLock"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordMinutesOfInactivityBeforeScreenTimeout
     * Minutes of inactivity required before the screen times out.
     *
     * @return int|null The passwordMinutesOfInactivityBeforeScreenTimeout
     */
    public function getPasswordMinutesOfInactivityBeforeScreenTimeout()
    {
        if (array_key_exists("passwordMinutesOfInactivityBeforeScreenTimeout", $this->_propDict)) {
            return $this->_propDict["passwordMinutesOfInactivityBeforeScreenTimeout"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordMinutesOfInactivityBeforeScreenTimeout
     * Minutes of inactivity required before the screen times out.
     *
     * @param int $val The passwordMinutesOfInactivityBeforeScreenTimeout
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordMinutesOfInactivityBeforeScreenTimeout($val)
    {
        $this->_propDict["passwordMinutesOfInactivityBeforeScreenTimeout"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordPreviousPasswordBlockCount
     * Number of previous passwords to block.
     *
     * @return int|null The passwordPreviousPasswordBlockCount
     */
    public function getPasswordPreviousPasswordBlockCount()
    {
        if (array_key_exists("passwordPreviousPasswordBlockCount", $this->_propDict)) {
            return $this->_propDict["passwordPreviousPasswordBlockCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordPreviousPasswordBlockCount
     * Number of previous passwords to block.
     *
     * @param int $val The passwordPreviousPasswordBlockCount
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordPreviousPasswordBlockCount($val)
    {
        $this->_propDict["passwordPreviousPasswordBlockCount"] = intval($val);
        return $this;
    }
    /**
     * Gets the passwordRequired
     * Whether or not to require a password.
     *
     * @return bool|null The passwordRequired
     */
    public function getPasswordRequired()
    {
        if (array_key_exists("passwordRequired", $this->_propDict)) {
            return $this->_propDict["passwordRequired"];
        } else {
            return null;
        }
    }
    /**
     * Sets the passwordRequired
     * Whether or not to require a password.
     *
     * @param bool $val The passwordRequired
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordRequired($val)
    {
        $this->_propDict["passwordRequired"] = boolval($val);
        return $this;
    }
    /**
     * Gets the passwordRequiredType
     * Type of password that is required. Possible values are: deviceDefault, alphanumeric, numeric.
     *
     * @return RequiredPasswordType|null The passwordRequiredType
     */
    public function getPasswordRequiredType()
    {
        if (array_key_exists("passwordRequiredType", $this->_propDict)) {
            if (is_a($this->_propDict["passwordRequiredType"], "XCloner\\Microsoft\\Graph\\Model\\RequiredPasswordType") || is_null($this->_propDict["passwordRequiredType"])) {
                return $this->_propDict["passwordRequiredType"];
            } else {
                $this->_propDict["passwordRequiredType"] = new RequiredPasswordType($this->_propDict["passwordRequiredType"]);
                return $this->_propDict["passwordRequiredType"];
            }
        }
        return null;
    }
    /**
     * Sets the passwordRequiredType
     * Type of password that is required. Possible values are: deviceDefault, alphanumeric, numeric.
     *
     * @param RequiredPasswordType $val The passwordRequiredType
     *
     * @return MacOSGeneralDeviceConfiguration
     */
    public function setPasswordRequiredType($val)
    {
        $this->_propDict["passwordRequiredType"] = $val;
        return $this;
    }
}
