<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AssignedLicense File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* AssignedLicense class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AssignedLicense extends Entity
{
    /**
     * Gets the disabledPlans
     * A collection of the unique identifiers for plans that have been disabled.
     *
     * @return string|null The disabledPlans
     */
    public function getDisabledPlans()
    {
        if (array_key_exists("disabledPlans", $this->_propDict)) {
            return $this->_propDict["disabledPlans"];
        } else {
            return null;
        }
    }
    /**
     * Sets the disabledPlans
     * A collection of the unique identifiers for plans that have been disabled.
     *
     * @param string $val The value of the disabledPlans
     *
     * @return AssignedLicense
     */
    public function setDisabledPlans($val)
    {
        $this->_propDict["disabledPlans"] = $val;
        return $this;
    }
    /**
     * Gets the skuId
     * The unique identifier for the SKU.
     *
     * @return string|null The skuId
     */
    public function getSkuId()
    {
        if (array_key_exists("skuId", $this->_propDict)) {
            return $this->_propDict["skuId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the skuId
     * The unique identifier for the SKU.
     *
     * @param string $val The value of the skuId
     *
     * @return AssignedLicense
     */
    public function setSkuId($val)
    {
        $this->_propDict["skuId"] = $val;
        return $this;
    }
}
