<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* Sharepoint File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\TenantAdmin\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* Sharepoint class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class Sharepoint extends \XCloner\Beta\Microsoft\Graph\Model\Entity
{
    /**
     * Gets the settings
     * Represents the tenant-level settings for SharePoint and OneDrive.
     *
     * @return Settings|null The settings
     */
    public function getSettings()
    {
        if (array_key_exists("settings", $this->_propDict)) {
            if (is_a($this->_propDict["settings"], "XCloner\\Beta\\Microsoft\\Graph\\TenantAdmin\\Model\\Settings") || is_null($this->_propDict["settings"])) {
                return $this->_propDict["settings"];
            } else {
                $this->_propDict["settings"] = new Settings($this->_propDict["settings"]);
                return $this->_propDict["settings"];
            }
        }
        return null;
    }
    /**
     * Sets the settings
     * Represents the tenant-level settings for SharePoint and OneDrive.
     *
     * @param Settings $val The settings
     *
     * @return Sharepoint
     */
    public function setSettings($val)
    {
        $this->_propDict["settings"] = $val;
        return $this;
    }
}
