<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* CaseOperation File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\SecurityNamespace\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* CaseOperation class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class CaseOperation extends \XCloner\Beta\Microsoft\Graph\Model\Entity
{
    /**
     * Gets the action
     * The type of action the operation represents. Possible values are: addToReviewSet,applyTags,contentExport,convertToPdf,estimateStatistics, purgeData
     *
     * @return CaseAction|null The action
     */
    public function getAction()
    {
        if (array_key_exists("action", $this->_propDict)) {
            if (is_a($this->_propDict["action"], "XCloner\\Beta\\Microsoft\\Graph\\SecurityNamespace\\Model\\CaseAction") || is_null($this->_propDict["action"])) {
                return $this->_propDict["action"];
            } else {
                $this->_propDict["action"] = new CaseAction($this->_propDict["action"]);
                return $this->_propDict["action"];
            }
        }
        return null;
    }
    /**
     * Sets the action
     * The type of action the operation represents. Possible values are: addToReviewSet,applyTags,contentExport,convertToPdf,estimateStatistics, purgeData
     *
     * @param CaseAction $val The action
     *
     * @return CaseOperation
     */
    public function setAction($val)
    {
        $this->_propDict["action"] = $val;
        return $this;
    }
    /**
     * Gets the completedDateTime
     * The date and time the operation was completed.
     *
     * @return \DateTime|null The completedDateTime
     */
    public function getCompletedDateTime()
    {
        if (array_key_exists("completedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["completedDateTime"], "\\DateTime") || is_null($this->_propDict["completedDateTime"])) {
                return $this->_propDict["completedDateTime"];
            } else {
                $this->_propDict["completedDateTime"] = new \DateTime($this->_propDict["completedDateTime"]);
                return $this->_propDict["completedDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the completedDateTime
     * The date and time the operation was completed.
     *
     * @param \DateTime $val The completedDateTime
     *
     * @return CaseOperation
     */
    public function setCompletedDateTime($val)
    {
        $this->_propDict["completedDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the createdBy
     * The user that created the operation.
     *
     * @return \Beta\Microsoft\Graph\Model\IdentitySet|null The createdBy
     */
    public function getCreatedBy()
    {
        if (array_key_exists("createdBy", $this->_propDict)) {
            if (is_a($this->_propDict["createdBy"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\IdentitySet") || is_null($this->_propDict["createdBy"])) {
                return $this->_propDict["createdBy"];
            } else {
                $this->_propDict["createdBy"] = new \XCloner\Beta\Microsoft\Graph\Model\IdentitySet($this->_propDict["createdBy"]);
                return $this->_propDict["createdBy"];
            }
        }
        return null;
    }
    /**
     * Sets the createdBy
     * The user that created the operation.
     *
     * @param \Beta\Microsoft\Graph\Model\IdentitySet $val The createdBy
     *
     * @return CaseOperation
     */
    public function setCreatedBy($val)
    {
        $this->_propDict["createdBy"] = $val;
        return $this;
    }
    /**
     * Gets the createdDateTime
     * The date and time the operation was created.
     *
     * @return \DateTime|null The createdDateTime
     */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the createdDateTime
     * The date and time the operation was created.
     *
     * @param \DateTime $val The createdDateTime
     *
     * @return CaseOperation
     */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the percentProgress
     * The progress of the operation.
     *
     * @return int|null The percentProgress
     */
    public function getPercentProgress()
    {
        if (array_key_exists("percentProgress", $this->_propDict)) {
            return $this->_propDict["percentProgress"];
        } else {
            return null;
        }
    }
    /**
     * Sets the percentProgress
     * The progress of the operation.
     *
     * @param int $val The percentProgress
     *
     * @return CaseOperation
     */
    public function setPercentProgress($val)
    {
        $this->_propDict["percentProgress"] = intval($val);
        return $this;
    }
    /**
     * Gets the resultInfo
     * Contains success and failure-specific result information.
     *
     * @return \Beta\Microsoft\Graph\Model\ResultInfo|null The resultInfo
     */
    public function getResultInfo()
    {
        if (array_key_exists("resultInfo", $this->_propDict)) {
            if (is_a($this->_propDict["resultInfo"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\ResultInfo") || is_null($this->_propDict["resultInfo"])) {
                return $this->_propDict["resultInfo"];
            } else {
                $this->_propDict["resultInfo"] = new \XCloner\Beta\Microsoft\Graph\Model\ResultInfo($this->_propDict["resultInfo"]);
                return $this->_propDict["resultInfo"];
            }
        }
        return null;
    }
    /**
     * Sets the resultInfo
     * Contains success and failure-specific result information.
     *
     * @param \Beta\Microsoft\Graph\Model\ResultInfo $val The resultInfo
     *
     * @return CaseOperation
     */
    public function setResultInfo($val)
    {
        $this->_propDict["resultInfo"] = $val;
        return $this;
    }
    /**
     * Gets the status
     * The status of the case operation. Possible values are: notStarted, submissionFailed, running, succeeded, partiallySucceeded, failed.
     *
     * @return CaseOperationStatus|null The status
     */
    public function getStatus()
    {
        if (array_key_exists("status", $this->_propDict)) {
            if (is_a($this->_propDict["status"], "XCloner\\Beta\\Microsoft\\Graph\\SecurityNamespace\\Model\\CaseOperationStatus") || is_null($this->_propDict["status"])) {
                return $this->_propDict["status"];
            } else {
                $this->_propDict["status"] = new CaseOperationStatus($this->_propDict["status"]);
                return $this->_propDict["status"];
            }
        }
        return null;
    }
    /**
     * Sets the status
     * The status of the case operation. Possible values are: notStarted, submissionFailed, running, succeeded, partiallySucceeded, failed.
     *
     * @param CaseOperationStatus $val The status
     *
     * @return CaseOperation
     */
    public function setStatus($val)
    {
        $this->_propDict["status"] = $val;
        return $this;
    }
}
