<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareStateCount File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* WindowsMalwareStateCount class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareStateCount extends Entity
{
    /**
     * Gets the deviceCount
     * Count of devices with malware detections for this malware State
     *
     * @return int|null The deviceCount
     */
    public function getDeviceCount()
    {
        if (array_key_exists("deviceCount", $this->_propDict)) {
            return $this->_propDict["deviceCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceCount
     * Count of devices with malware detections for this malware State
     *
     * @param int $val The value of the deviceCount
     *
     * @return WindowsMalwareStateCount
     */
    public function setDeviceCount($val)
    {
        $this->_propDict["deviceCount"] = $val;
        return $this;
    }
    /**
     * Gets the distinctMalwareCount
     * Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
     *
     * @return int|null The distinctMalwareCount
     */
    public function getDistinctMalwareCount()
    {
        if (array_key_exists("distinctMalwareCount", $this->_propDict)) {
            return $this->_propDict["distinctMalwareCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the distinctMalwareCount
     * Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
     *
     * @param int $val The value of the distinctMalwareCount
     *
     * @return WindowsMalwareStateCount
     */
    public function setDistinctMalwareCount($val)
    {
        $this->_propDict["distinctMalwareCount"] = $val;
        return $this;
    }
    /**
     * Gets the lastUpdateDateTime
     * The Timestamp of the last update for the device count in UTC
     *
     * @return \DateTime|null The lastUpdateDateTime
     */
    public function getLastUpdateDateTime()
    {
        if (array_key_exists("lastUpdateDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastUpdateDateTime"], "\\DateTime") || is_null($this->_propDict["lastUpdateDateTime"])) {
                return $this->_propDict["lastUpdateDateTime"];
            } else {
                $this->_propDict["lastUpdateDateTime"] = new \DateTime($this->_propDict["lastUpdateDateTime"]);
                return $this->_propDict["lastUpdateDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastUpdateDateTime
     * The Timestamp of the last update for the device count in UTC
     *
     * @param \DateTime $val The value to assign to the lastUpdateDateTime
     *
     * @return WindowsMalwareStateCount The WindowsMalwareStateCount
     */
    public function setLastUpdateDateTime($val)
    {
        $this->_propDict["lastUpdateDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the malwareDetectionCount
     * Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
     *
     * @return int|null The malwareDetectionCount
     */
    public function getMalwareDetectionCount()
    {
        if (array_key_exists("malwareDetectionCount", $this->_propDict)) {
            return $this->_propDict["malwareDetectionCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the malwareDetectionCount
     * Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
     *
     * @param int $val The value of the malwareDetectionCount
     *
     * @return WindowsMalwareStateCount
     */
    public function setMalwareDetectionCount($val)
    {
        $this->_propDict["malwareDetectionCount"] = $val;
        return $this;
    }
    /**
     * Gets the state
     * Malware Threat State. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     *
     * @return WindowsMalwareThreatState|null The state
     */
    public function getState()
    {
        if (array_key_exists("state", $this->_propDict)) {
            if (is_a($this->_propDict["state"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\WindowsMalwareThreatState") || is_null($this->_propDict["state"])) {
                return $this->_propDict["state"];
            } else {
                $this->_propDict["state"] = new WindowsMalwareThreatState($this->_propDict["state"]);
                return $this->_propDict["state"];
            }
        }
        return null;
    }
    /**
     * Sets the state
     * Malware Threat State. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     *
     * @param WindowsMalwareThreatState $val The value to assign to the state
     *
     * @return WindowsMalwareStateCount The WindowsMalwareStateCount
     */
    public function setState($val)
    {
        $this->_propDict["state"] = $val;
        return $this;
    }
}
