<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareExecutionStateCount File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* WindowsMalwareExecutionStateCount class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareExecutionStateCount extends Entity
{
    /**
     * Gets the deviceCount
     * Count of devices with malware detections for this malware execution state
     *
     * @return int|null The deviceCount
     */
    public function getDeviceCount()
    {
        if (array_key_exists("deviceCount", $this->_propDict)) {
            return $this->_propDict["deviceCount"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceCount
     * Count of devices with malware detections for this malware execution state
     *
     * @param int $val The value of the deviceCount
     *
     * @return WindowsMalwareExecutionStateCount
     */
    public function setDeviceCount($val)
    {
        $this->_propDict["deviceCount"] = $val;
        return $this;
    }
    /**
     * Gets the executionState
     * Malware execution state. Possible values are: unknown, blocked, allowed, running, notRunning.
     *
     * @return WindowsMalwareExecutionState|null The executionState
     */
    public function getExecutionState()
    {
        if (array_key_exists("executionState", $this->_propDict)) {
            if (is_a($this->_propDict["executionState"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\WindowsMalwareExecutionState") || is_null($this->_propDict["executionState"])) {
                return $this->_propDict["executionState"];
            } else {
                $this->_propDict["executionState"] = new WindowsMalwareExecutionState($this->_propDict["executionState"]);
                return $this->_propDict["executionState"];
            }
        }
        return null;
    }
    /**
     * Sets the executionState
     * Malware execution state. Possible values are: unknown, blocked, allowed, running, notRunning.
     *
     * @param WindowsMalwareExecutionState $val The value to assign to the executionState
     *
     * @return WindowsMalwareExecutionStateCount The WindowsMalwareExecutionStateCount
     */
    public function setExecutionState($val)
    {
        $this->_propDict["executionState"] = $val;
        return $this;
    }
    /**
     * Gets the lastUpdateDateTime
     * The Timestamp of the last update for the device count in UTC
     *
     * @return \DateTime|null The lastUpdateDateTime
     */
    public function getLastUpdateDateTime()
    {
        if (array_key_exists("lastUpdateDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastUpdateDateTime"], "\\DateTime") || is_null($this->_propDict["lastUpdateDateTime"])) {
                return $this->_propDict["lastUpdateDateTime"];
            } else {
                $this->_propDict["lastUpdateDateTime"] = new \DateTime($this->_propDict["lastUpdateDateTime"]);
                return $this->_propDict["lastUpdateDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastUpdateDateTime
     * The Timestamp of the last update for the device count in UTC
     *
     * @param \DateTime $val The value to assign to the lastUpdateDateTime
     *
     * @return WindowsMalwareExecutionStateCount The WindowsMalwareExecutionStateCount
     */
    public function setLastUpdateDateTime($val)
    {
        $this->_propDict["lastUpdateDateTime"] = $val;
        return $this;
    }
}
