<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* Windows10VpnConnectionType File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
use XCloner\Microsoft\Graph\Core\Enum;
/**
* Windows10VpnConnectionType class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class Windows10VpnConnectionType extends Enum
{
    /**
     * The Enum Windows10VpnConnectionType
     */
    const PULSE_SECURE = "pulseSecure";
    const F5_EDGE_CLIENT = "f5EdgeClient";
    const DELL_SONIC_WALL_MOBILE_CONNECT = "dellSonicWallMobileConnect";
    const CHECK_POINT_CAPSULE_VPN = "checkPointCapsuleVpn";
    const AUTOMATIC = "automatic";
    const IK_EV2 = "ikEv2";
    const L2TP = "l2tp";
    const PPTP = "pptp";
    const CITRIX = "citrix";
    const PALO_ALTO_GLOBAL_PROTECT = "paloAltoGlobalProtect";
    const CISCO_ANY_CONNECT = "ciscoAnyConnect";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
    const MICROSOFT_TUNNEL = "microsoftTunnel";
}
