<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PinnedChatMessageInfo File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* PinnedChatMessageInfo class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PinnedChatMessageInfo extends Entity
{
    /**
     * Gets the message
     * Represents details about the chat message that is pinned.
     *
     * @return ChatMessage|null The message
     */
    public function getMessage()
    {
        if (array_key_exists("message", $this->_propDict)) {
            if (is_a($this->_propDict["message"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\ChatMessage") || is_null($this->_propDict["message"])) {
                return $this->_propDict["message"];
            } else {
                $this->_propDict["message"] = new ChatMessage($this->_propDict["message"]);
                return $this->_propDict["message"];
            }
        }
        return null;
    }
    /**
     * Sets the message
     * Represents details about the chat message that is pinned.
     *
     * @param ChatMessage $val The message
     *
     * @return PinnedChatMessageInfo
     */
    public function setMessage($val)
    {
        $this->_propDict["message"] = $val;
        return $this;
    }
}
