<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* Picture File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* Picture class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class Picture extends Entity
{
    /**
     * Gets the content
     *
     * @return \GuzzleHttp\Psr7\Stream|null The content
     */
    public function getContent()
    {
        if (array_key_exists("content", $this->_propDict)) {
            if (is_a($this->_propDict["content"], "XCloner\\GuzzleHttp\\Psr7\\Stream") || is_null($this->_propDict["content"])) {
                return $this->_propDict["content"];
            } else {
                $this->_propDict["content"] = \XCloner\GuzzleHttp\Psr7\Utils::streamFor($this->_propDict["content"]);
                return $this->_propDict["content"];
            }
        }
        return null;
    }
    /**
     * Sets the content
     *
     * @param \GuzzleHttp\Psr7\Stream $val The content
     *
     * @return Picture
     */
    public function setContent($val)
    {
        $this->_propDict["content"] = $val;
        return $this;
    }
    /**
     * Gets the contentType
     *
     * @return string|null The contentType
     */
    public function getContentType()
    {
        if (array_key_exists("contentType", $this->_propDict)) {
            return $this->_propDict["contentType"];
        } else {
            return null;
        }
    }
    /**
     * Sets the contentType
     *
     * @param string $val The contentType
     *
     * @return Picture
     */
    public function setContentType($val)
    {
        $this->_propDict["contentType"] = $val;
        return $this;
    }
    /**
     * Gets the height
     *
     * @return int|null The height
     */
    public function getHeight()
    {
        if (array_key_exists("height", $this->_propDict)) {
            return $this->_propDict["height"];
        } else {
            return null;
        }
    }
    /**
     * Sets the height
     *
     * @param int $val The height
     *
     * @return Picture
     */
    public function setHeight($val)
    {
        $this->_propDict["height"] = intval($val);
        return $this;
    }
    /**
     * Gets the width
     *
     * @return int|null The width
     */
    public function getWidth()
    {
        if (array_key_exists("width", $this->_propDict)) {
            return $this->_propDict["width"];
        } else {
            return null;
        }
    }
    /**
     * Sets the width
     *
     * @param int $val The width
     *
     * @return Picture
     */
    public function setWidth($val)
    {
        $this->_propDict["width"] = intval($val);
        return $this;
    }
}
