<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PersonWebsite File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* PersonWebsite class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PersonWebsite extends ItemFacet
{
    /**
     * Gets the categories
     * Contains categories a user has associated with the website (for example, personal, recipes).
     *
     * @return array|null The categories
     */
    public function getCategories()
    {
        if (array_key_exists("categories", $this->_propDict)) {
            return $this->_propDict["categories"];
        } else {
            return null;
        }
    }
    /**
     * Sets the categories
     * Contains categories a user has associated with the website (for example, personal, recipes).
     *
     * @param string[] $val The categories
     *
     * @return PersonWebsite
     */
    public function setCategories($val)
    {
        $this->_propDict["categories"] = $val;
        return $this;
    }
    /**
     * Gets the description
     * Contains a description of the website.
     *
     * @return string|null The description
     */
    public function getDescription()
    {
        if (array_key_exists("description", $this->_propDict)) {
            return $this->_propDict["description"];
        } else {
            return null;
        }
    }
    /**
     * Sets the description
     * Contains a description of the website.
     *
     * @param string $val The description
     *
     * @return PersonWebsite
     */
    public function setDescription($val)
    {
        $this->_propDict["description"] = $val;
        return $this;
    }
    /**
     * Gets the displayName
     * Contains a friendly name for the website.
     *
     * @return string|null The displayName
     */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the displayName
     * Contains a friendly name for the website.
     *
     * @param string $val The displayName
     *
     * @return PersonWebsite
     */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }
    /**
     * Gets the thumbnailUrl
     *
     * @return string|null The thumbnailUrl
     */
    public function getThumbnailUrl()
    {
        if (array_key_exists("thumbnailUrl", $this->_propDict)) {
            return $this->_propDict["thumbnailUrl"];
        } else {
            return null;
        }
    }
    /**
     * Sets the thumbnailUrl
     *
     * @param string $val The thumbnailUrl
     *
     * @return PersonWebsite
     */
    public function setThumbnailUrl($val)
    {
        $this->_propDict["thumbnailUrl"] = $val;
        return $this;
    }
    /**
     * Gets the webUrl
     * Contains a link to the website itself.
     *
     * @return string|null The webUrl
     */
    public function getWebUrl()
    {
        if (array_key_exists("webUrl", $this->_propDict)) {
            return $this->_propDict["webUrl"];
        } else {
            return null;
        }
    }
    /**
     * Sets the webUrl
     * Contains a link to the website itself.
     *
     * @param string $val The webUrl
     *
     * @return PersonWebsite
     */
    public function setWebUrl($val)
    {
        $this->_propDict["webUrl"] = $val;
        return $this;
    }
}
