<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MediaContentRatingNewZealand File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MediaContentRatingNewZealand class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MediaContentRatingNewZealand extends Entity
{
    /**
     * Gets the movieRating
     * Movies rating selected for New Zealand. Possible values are: allAllowed, allBlocked, general, parentalGuidance, mature, agesAbove13, agesAbove15, agesAbove16, agesAbove18, restricted, agesAbove16Restricted.
     *
     * @return RatingNewZealandMoviesType|null The movieRating
     */
    public function getMovieRating()
    {
        if (array_key_exists("movieRating", $this->_propDict)) {
            if (is_a($this->_propDict["movieRating"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\RatingNewZealandMoviesType") || is_null($this->_propDict["movieRating"])) {
                return $this->_propDict["movieRating"];
            } else {
                $this->_propDict["movieRating"] = new RatingNewZealandMoviesType($this->_propDict["movieRating"]);
                return $this->_propDict["movieRating"];
            }
        }
        return null;
    }
    /**
     * Sets the movieRating
     * Movies rating selected for New Zealand. Possible values are: allAllowed, allBlocked, general, parentalGuidance, mature, agesAbove13, agesAbove15, agesAbove16, agesAbove18, restricted, agesAbove16Restricted.
     *
     * @param RatingNewZealandMoviesType $val The value to assign to the movieRating
     *
     * @return MediaContentRatingNewZealand The MediaContentRatingNewZealand
     */
    public function setMovieRating($val)
    {
        $this->_propDict["movieRating"] = $val;
        return $this;
    }
    /**
     * Gets the tvRating
     * TV rating selected for New Zealand. Possible values are: allAllowed, allBlocked, general, parentalGuidance, adults.
     *
     * @return RatingNewZealandTelevisionType|null The tvRating
     */
    public function getTvRating()
    {
        if (array_key_exists("tvRating", $this->_propDict)) {
            if (is_a($this->_propDict["tvRating"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\RatingNewZealandTelevisionType") || is_null($this->_propDict["tvRating"])) {
                return $this->_propDict["tvRating"];
            } else {
                $this->_propDict["tvRating"] = new RatingNewZealandTelevisionType($this->_propDict["tvRating"]);
                return $this->_propDict["tvRating"];
            }
        }
        return null;
    }
    /**
     * Sets the tvRating
     * TV rating selected for New Zealand. Possible values are: allAllowed, allBlocked, general, parentalGuidance, adults.
     *
     * @param RatingNewZealandTelevisionType $val The value to assign to the tvRating
     *
     * @return MediaContentRatingNewZealand The MediaContentRatingNewZealand
     */
    public function setTvRating($val)
    {
        $this->_propDict["tvRating"] = $val;
        return $this;
    }
}
