<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ManagedAppRegistration File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* ManagedAppRegistration class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ManagedAppRegistration extends Entity
{
    /**
     * Gets the appIdentifier
     * The app package Identifier
     *
     * @return MobileAppIdentifier|null The appIdentifier
     */
    public function getAppIdentifier()
    {
        if (array_key_exists("appIdentifier", $this->_propDict)) {
            if (is_a($this->_propDict["appIdentifier"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\MobileAppIdentifier") || is_null($this->_propDict["appIdentifier"])) {
                return $this->_propDict["appIdentifier"];
            } else {
                $this->_propDict["appIdentifier"] = new MobileAppIdentifier($this->_propDict["appIdentifier"]);
                return $this->_propDict["appIdentifier"];
            }
        }
        return null;
    }
    /**
     * Sets the appIdentifier
     * The app package Identifier
     *
     * @param MobileAppIdentifier $val The appIdentifier
     *
     * @return ManagedAppRegistration
     */
    public function setAppIdentifier($val)
    {
        $this->_propDict["appIdentifier"] = $val;
        return $this;
    }
    /**
     * Gets the applicationVersion
     * App version
     *
     * @return string|null The applicationVersion
     */
    public function getApplicationVersion()
    {
        if (array_key_exists("applicationVersion", $this->_propDict)) {
            return $this->_propDict["applicationVersion"];
        } else {
            return null;
        }
    }
    /**
     * Sets the applicationVersion
     * App version
     *
     * @param string $val The applicationVersion
     *
     * @return ManagedAppRegistration
     */
    public function setApplicationVersion($val)
    {
        $this->_propDict["applicationVersion"] = $val;
        return $this;
    }
    /**
     * Gets the azureADDeviceId
     * The Azure Active Directory Device identifier of the host device. Value could be empty even when the host device is Azure Active Directory registered.
     *
     * @return string|null The azureADDeviceId
     */
    public function getAzureADDeviceId()
    {
        if (array_key_exists("azureADDeviceId", $this->_propDict)) {
            return $this->_propDict["azureADDeviceId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the azureADDeviceId
     * The Azure Active Directory Device identifier of the host device. Value could be empty even when the host device is Azure Active Directory registered.
     *
     * @param string $val The azureADDeviceId
     *
     * @return ManagedAppRegistration
     */
    public function setAzureADDeviceId($val)
    {
        $this->_propDict["azureADDeviceId"] = $val;
        return $this;
    }
    /**
     * Gets the createdDateTime
     * Date and time of creation
     *
     * @return \DateTime|null The createdDateTime
     */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the createdDateTime
     * Date and time of creation
     *
     * @param \DateTime $val The createdDateTime
     *
     * @return ManagedAppRegistration
     */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the deviceManufacturer
     * The device manufacturer for the current app registration
     *
     * @return string|null The deviceManufacturer
     */
    public function getDeviceManufacturer()
    {
        if (array_key_exists("deviceManufacturer", $this->_propDict)) {
            return $this->_propDict["deviceManufacturer"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceManufacturer
     * The device manufacturer for the current app registration
     *
     * @param string $val The deviceManufacturer
     *
     * @return ManagedAppRegistration
     */
    public function setDeviceManufacturer($val)
    {
        $this->_propDict["deviceManufacturer"] = $val;
        return $this;
    }
    /**
     * Gets the deviceModel
     * The device model for the current app registration
     *
     * @return string|null The deviceModel
     */
    public function getDeviceModel()
    {
        if (array_key_exists("deviceModel", $this->_propDict)) {
            return $this->_propDict["deviceModel"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceModel
     * The device model for the current app registration
     *
     * @param string $val The deviceModel
     *
     * @return ManagedAppRegistration
     */
    public function setDeviceModel($val)
    {
        $this->_propDict["deviceModel"] = $val;
        return $this;
    }
    /**
     * Gets the deviceName
     * Host device name
     *
     * @return string|null The deviceName
     */
    public function getDeviceName()
    {
        if (array_key_exists("deviceName", $this->_propDict)) {
            return $this->_propDict["deviceName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceName
     * Host device name
     *
     * @param string $val The deviceName
     *
     * @return ManagedAppRegistration
     */
    public function setDeviceName($val)
    {
        $this->_propDict["deviceName"] = $val;
        return $this;
    }
    /**
     * Gets the deviceTag
     * App management SDK generated tag, which helps relate apps hosted on the same device. Not guaranteed to relate apps in all conditions.
     *
     * @return string|null The deviceTag
     */
    public function getDeviceTag()
    {
        if (array_key_exists("deviceTag", $this->_propDict)) {
            return $this->_propDict["deviceTag"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceTag
     * App management SDK generated tag, which helps relate apps hosted on the same device. Not guaranteed to relate apps in all conditions.
     *
     * @param string $val The deviceTag
     *
     * @return ManagedAppRegistration
     */
    public function setDeviceTag($val)
    {
        $this->_propDict["deviceTag"] = $val;
        return $this;
    }
    /**
     * Gets the deviceType
     * Host device type
     *
     * @return string|null The deviceType
     */
    public function getDeviceType()
    {
        if (array_key_exists("deviceType", $this->_propDict)) {
            return $this->_propDict["deviceType"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceType
     * Host device type
     *
     * @param string $val The deviceType
     *
     * @return ManagedAppRegistration
     */
    public function setDeviceType($val)
    {
        $this->_propDict["deviceType"] = $val;
        return $this;
    }
    /**
     * Gets the flaggedReasons
     * Zero or more reasons an app registration is flagged. E.g. app running on rooted device
     *
     * @return array|null The flaggedReasons
     */
    public function getFlaggedReasons()
    {
        if (array_key_exists("flaggedReasons", $this->_propDict)) {
            return $this->_propDict["flaggedReasons"];
        } else {
            return null;
        }
    }
    /**
     * Sets the flaggedReasons
     * Zero or more reasons an app registration is flagged. E.g. app running on rooted device
     *
     * @param ManagedAppFlaggedReason[] $val The flaggedReasons
     *
     * @return ManagedAppRegistration
     */
    public function setFlaggedReasons($val)
    {
        $this->_propDict["flaggedReasons"] = $val;
        return $this;
    }
    /**
     * Gets the lastSyncDateTime
     * Date and time of last the app synced with management service.
     *
     * @return \DateTime|null The lastSyncDateTime
     */
    public function getLastSyncDateTime()
    {
        if (array_key_exists("lastSyncDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastSyncDateTime"], "\\DateTime") || is_null($this->_propDict["lastSyncDateTime"])) {
                return $this->_propDict["lastSyncDateTime"];
            } else {
                $this->_propDict["lastSyncDateTime"] = new \DateTime($this->_propDict["lastSyncDateTime"]);
                return $this->_propDict["lastSyncDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastSyncDateTime
     * Date and time of last the app synced with management service.
     *
     * @param \DateTime $val The lastSyncDateTime
     *
     * @return ManagedAppRegistration
     */
    public function setLastSyncDateTime($val)
    {
        $this->_propDict["lastSyncDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the managedDeviceId
     * The Managed Device identifier of the host device. Value could be empty even when the host device is managed.
     *
     * @return string|null The managedDeviceId
     */
    public function getManagedDeviceId()
    {
        if (array_key_exists("managedDeviceId", $this->_propDict)) {
            return $this->_propDict["managedDeviceId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the managedDeviceId
     * The Managed Device identifier of the host device. Value could be empty even when the host device is managed.
     *
     * @param string $val The managedDeviceId
     *
     * @return ManagedAppRegistration
     */
    public function setManagedDeviceId($val)
    {
        $this->_propDict["managedDeviceId"] = $val;
        return $this;
    }
    /**
     * Gets the managementSdkVersion
     * App management SDK version
     *
     * @return string|null The managementSdkVersion
     */
    public function getManagementSdkVersion()
    {
        if (array_key_exists("managementSdkVersion", $this->_propDict)) {
            return $this->_propDict["managementSdkVersion"];
        } else {
            return null;
        }
    }
    /**
     * Sets the managementSdkVersion
     * App management SDK version
     *
     * @param string $val The managementSdkVersion
     *
     * @return ManagedAppRegistration
     */
    public function setManagementSdkVersion($val)
    {
        $this->_propDict["managementSdkVersion"] = $val;
        return $this;
    }
    /**
     * Gets the platformVersion
     * Operating System version
     *
     * @return string|null The platformVersion
     */
    public function getPlatformVersion()
    {
        if (array_key_exists("platformVersion", $this->_propDict)) {
            return $this->_propDict["platformVersion"];
        } else {
            return null;
        }
    }
    /**
     * Sets the platformVersion
     * Operating System version
     *
     * @param string $val The platformVersion
     *
     * @return ManagedAppRegistration
     */
    public function setPlatformVersion($val)
    {
        $this->_propDict["platformVersion"] = $val;
        return $this;
    }
    /**
     * Gets the userId
     * The user Id to who this app registration belongs.
     *
     * @return string|null The userId
     */
    public function getUserId()
    {
        if (array_key_exists("userId", $this->_propDict)) {
            return $this->_propDict["userId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userId
     * The user Id to who this app registration belongs.
     *
     * @param string $val The userId
     *
     * @return ManagedAppRegistration
     */
    public function setUserId($val)
    {
        $this->_propDict["userId"] = $val;
        return $this;
    }
    /**
     * Gets the version
     * Version of the entity.
     *
     * @return string|null The version
     */
    public function getVersion()
    {
        if (array_key_exists("version", $this->_propDict)) {
            return $this->_propDict["version"];
        } else {
            return null;
        }
    }
    /**
     * Sets the version
     * Version of the entity.
     *
     * @param string $val The version
     *
     * @return ManagedAppRegistration
     */
    public function setVersion($val)
    {
        $this->_propDict["version"] = $val;
        return $this;
    }
    /**
     * Gets the appliedPolicies
     * Zero or more policys already applied on the registered app when it last synchronized with managment service.
     *
     * @return array|null The appliedPolicies
     */
    public function getAppliedPolicies()
    {
        if (array_key_exists("appliedPolicies", $this->_propDict)) {
            return $this->_propDict["appliedPolicies"];
        } else {
            return null;
        }
    }
    /**
     * Sets the appliedPolicies
     * Zero or more policys already applied on the registered app when it last synchronized with managment service.
     *
     * @param ManagedAppPolicy[] $val The appliedPolicies
     *
     * @return ManagedAppRegistration
     */
    public function setAppliedPolicies($val)
    {
        $this->_propDict["appliedPolicies"] = $val;
        return $this;
    }
    /**
     * Gets the intendedPolicies
     * Zero or more policies admin intended for the app as of now.
     *
     * @return array|null The intendedPolicies
     */
    public function getIntendedPolicies()
    {
        if (array_key_exists("intendedPolicies", $this->_propDict)) {
            return $this->_propDict["intendedPolicies"];
        } else {
            return null;
        }
    }
    /**
     * Sets the intendedPolicies
     * Zero or more policies admin intended for the app as of now.
     *
     * @param ManagedAppPolicy[] $val The intendedPolicies
     *
     * @return ManagedAppRegistration
     */
    public function setIntendedPolicies($val)
    {
        $this->_propDict["intendedPolicies"] = $val;
        return $this;
    }
    /**
     * Gets the operations
     * Zero or more long running operations triggered on the app registration.
     *
     * @return array|null The operations
     */
    public function getOperations()
    {
        if (array_key_exists("operations", $this->_propDict)) {
            return $this->_propDict["operations"];
        } else {
            return null;
        }
    }
    /**
     * Sets the operations
     * Zero or more long running operations triggered on the app registration.
     *
     * @param ManagedAppOperation[] $val The operations
     *
     * @return ManagedAppRegistration
     */
    public function setOperations($val)
    {
        $this->_propDict["operations"] = $val;
        return $this;
    }
}
