<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* MacOSVpnConfiguration File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* MacOSVpnConfiguration class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class MacOSVpnConfiguration extends AppleVpnConfiguration
{
    /**
     * Gets the identityCertificate
     * Identity certificate for client authentication when authentication method is certificate.
     *
     * @return MacOSCertificateProfileBase|null The identityCertificate
     */
    public function getIdentityCertificate()
    {
        if (array_key_exists("identityCertificate", $this->_propDict)) {
            if (is_a($this->_propDict["identityCertificate"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\MacOSCertificateProfileBase") || is_null($this->_propDict["identityCertificate"])) {
                return $this->_propDict["identityCertificate"];
            } else {
                $this->_propDict["identityCertificate"] = new MacOSCertificateProfileBase($this->_propDict["identityCertificate"]);
                return $this->_propDict["identityCertificate"];
            }
        }
        return null;
    }
    /**
     * Sets the identityCertificate
     * Identity certificate for client authentication when authentication method is certificate.
     *
     * @param MacOSCertificateProfileBase $val The identityCertificate
     *
     * @return MacOSVpnConfiguration
     */
    public function setIdentityCertificate($val)
    {
        $this->_propDict["identityCertificate"] = $val;
        return $this;
    }
}
