<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* EvaluateLabelJobResponse File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* EvaluateLabelJobResponse class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class EvaluateLabelJobResponse extends JobResponseBase
{
    /**
     * Gets the result
     *
     * @return EvaluateLabelJobResultGroup|null The result
     */
    public function getResult()
    {
        if (array_key_exists("result", $this->_propDict)) {
            if (is_a($this->_propDict["result"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\EvaluateLabelJobResultGroup") || is_null($this->_propDict["result"])) {
                return $this->_propDict["result"];
            } else {
                $this->_propDict["result"] = new EvaluateLabelJobResultGroup($this->_propDict["result"]);
                return $this->_propDict["result"];
            }
        }
        return null;
    }
    /**
     * Sets the result
     *
     * @param EvaluateLabelJobResultGroup $val The result
     *
     * @return EvaluateLabelJobResponse
     */
    public function setResult($val)
    {
        $this->_propDict["result"] = $val;
        return $this;
    }
}
