<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* DeviceManagementIntentDeviceState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* DeviceManagementIntentDeviceState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class DeviceManagementIntentDeviceState extends Entity
{
    /**
     * Gets the deviceDisplayName
     * Device name that is being reported
     *
     * @return string|null The deviceDisplayName
     */
    public function getDeviceDisplayName()
    {
        if (array_key_exists("deviceDisplayName", $this->_propDict)) {
            return $this->_propDict["deviceDisplayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceDisplayName
     * Device name that is being reported
     *
     * @param string $val The deviceDisplayName
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setDeviceDisplayName($val)
    {
        $this->_propDict["deviceDisplayName"] = $val;
        return $this;
    }
    /**
     * Gets the deviceId
     * Device id that is being reported
     *
     * @return string|null The deviceId
     */
    public function getDeviceId()
    {
        if (array_key_exists("deviceId", $this->_propDict)) {
            return $this->_propDict["deviceId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the deviceId
     * Device id that is being reported
     *
     * @param string $val The deviceId
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setDeviceId($val)
    {
        $this->_propDict["deviceId"] = $val;
        return $this;
    }
    /**
     * Gets the lastReportedDateTime
     * Last modified date time of an intent report
     *
     * @return \DateTime|null The lastReportedDateTime
     */
    public function getLastReportedDateTime()
    {
        if (array_key_exists("lastReportedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastReportedDateTime"], "\\DateTime") || is_null($this->_propDict["lastReportedDateTime"])) {
                return $this->_propDict["lastReportedDateTime"];
            } else {
                $this->_propDict["lastReportedDateTime"] = new \DateTime($this->_propDict["lastReportedDateTime"]);
                return $this->_propDict["lastReportedDateTime"];
            }
        }
        return null;
    }
    /**
     * Sets the lastReportedDateTime
     * Last modified date time of an intent report
     *
     * @param \DateTime $val The lastReportedDateTime
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setLastReportedDateTime($val)
    {
        $this->_propDict["lastReportedDateTime"] = $val;
        return $this;
    }
    /**
     * Gets the state
     * Device state for an intent. Possible values are: unknown, notApplicable, compliant, remediated, nonCompliant, error, conflict, notAssigned.
     *
     * @return ComplianceStatus|null The state
     */
    public function getState()
    {
        if (array_key_exists("state", $this->_propDict)) {
            if (is_a($this->_propDict["state"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\ComplianceStatus") || is_null($this->_propDict["state"])) {
                return $this->_propDict["state"];
            } else {
                $this->_propDict["state"] = new ComplianceStatus($this->_propDict["state"]);
                return $this->_propDict["state"];
            }
        }
        return null;
    }
    /**
     * Sets the state
     * Device state for an intent. Possible values are: unknown, notApplicable, compliant, remediated, nonCompliant, error, conflict, notAssigned.
     *
     * @param ComplianceStatus $val The state
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setState($val)
    {
        $this->_propDict["state"] = $val;
        return $this;
    }
    /**
     * Gets the userName
     * The user name that is being reported on a device
     *
     * @return string|null The userName
     */
    public function getUserName()
    {
        if (array_key_exists("userName", $this->_propDict)) {
            return $this->_propDict["userName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userName
     * The user name that is being reported on a device
     *
     * @param string $val The userName
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setUserName($val)
    {
        $this->_propDict["userName"] = $val;
        return $this;
    }
    /**
     * Gets the userPrincipalName
     * The user principal name that is being reported on a device
     *
     * @return string|null The userPrincipalName
     */
    public function getUserPrincipalName()
    {
        if (array_key_exists("userPrincipalName", $this->_propDict)) {
            return $this->_propDict["userPrincipalName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userPrincipalName
     * The user principal name that is being reported on a device
     *
     * @param string $val The userPrincipalName
     *
     * @return DeviceManagementIntentDeviceState
     */
    public function setUserPrincipalName($val)
    {
        $this->_propDict["userPrincipalName"] = $val;
        return $this;
    }
}
