<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* DeviceManagementConfigurationSimpleSettingInstance File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* DeviceManagementConfigurationSimpleSettingInstance class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class DeviceManagementConfigurationSimpleSettingInstance extends DeviceManagementConfigurationSettingInstance
{
    /**
     * Set the @odata.type since this type is immediately descended from an abstract
     * type that is referenced as the type in an entity.
     * @param array $propDict The property dictionary
     */
    public function __construct($propDict = array())
    {
        parent::__construct($propDict);
        $this->setODataType("#microsoft.graph.deviceManagementConfigurationSimpleSettingInstance");
    }
    /**
     * Gets the simpleSettingValue
     * Simple setting instance value
     *
     * @return DeviceManagementConfigurationSimpleSettingValue|null The simpleSettingValue
     */
    public function getSimpleSettingValue()
    {
        if (array_key_exists("simpleSettingValue", $this->_propDict)) {
            if (is_a($this->_propDict["simpleSettingValue"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\DeviceManagementConfigurationSimpleSettingValue") || is_null($this->_propDict["simpleSettingValue"])) {
                return $this->_propDict["simpleSettingValue"];
            } else {
                $this->_propDict["simpleSettingValue"] = new DeviceManagementConfigurationSimpleSettingValue($this->_propDict["simpleSettingValue"]);
                return $this->_propDict["simpleSettingValue"];
            }
        }
        return null;
    }
    /**
     * Sets the simpleSettingValue
     * Simple setting instance value
     *
     * @param DeviceManagementConfigurationSimpleSettingValue $val The value to assign to the simpleSettingValue
     *
     * @return DeviceManagementConfigurationSimpleSettingInstance The DeviceManagementConfigurationSimpleSettingInstance
     */
    public function setSimpleSettingValue($val)
    {
        $this->_propDict["simpleSettingValue"] = $val;
        return $this;
    }
}
