<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ChromeOSOnboardingStatus File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
use XCloner\Microsoft\Graph\Core\Enum;
/**
* ChromeOSOnboardingStatus class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ChromeOSOnboardingStatus extends Enum
{
    /**
     * The Enum ChromeOSOnboardingStatus
     */
    const UNKNOWN = "unknown";
    const INPROGRESS = "inprogress";
    const ONBOARDED = "onboarded";
    const FAILED = "failed";
    const OFFBOARDING = "offboarding";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
