<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AuthenticationContext File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* AuthenticationContext class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AuthenticationContext extends Entity
{
    /**
     * Gets the detail
     * Describes how the conditional access authentication context was triggered. A value of previouslySatisfied means the auth context was because the user already satisfied the requirements for that authentication context in some previous authentication event. A value of required means the user had to meet the authentication context requirement as part of the sign-in flow. The possible values are: required, previouslySatisfied, notApplicable, unknownFutureValue.
     *
     * @return AuthenticationContextDetail|null The detail
     */
    public function getDetail()
    {
        if (array_key_exists("detail", $this->_propDict)) {
            if (is_a($this->_propDict["detail"], "XCloner\\Beta\\Microsoft\\Graph\\Model\\AuthenticationContextDetail") || is_null($this->_propDict["detail"])) {
                return $this->_propDict["detail"];
            } else {
                $this->_propDict["detail"] = new AuthenticationContextDetail($this->_propDict["detail"]);
                return $this->_propDict["detail"];
            }
        }
        return null;
    }
    /**
     * Sets the detail
     * Describes how the conditional access authentication context was triggered. A value of previouslySatisfied means the auth context was because the user already satisfied the requirements for that authentication context in some previous authentication event. A value of required means the user had to meet the authentication context requirement as part of the sign-in flow. The possible values are: required, previouslySatisfied, notApplicable, unknownFutureValue.
     *
     * @param AuthenticationContextDetail $val The value to assign to the detail
     *
     * @return AuthenticationContext The AuthenticationContext
     */
    public function setDetail($val)
    {
        $this->_propDict["detail"] = $val;
        return $this;
    }
    /**
     * Gets the id
     * The identifier of a authentication context in your tenant.
     *
     * @return string|null The id
     */
    public function getId()
    {
        if (array_key_exists("id", $this->_propDict)) {
            return $this->_propDict["id"];
        } else {
            return null;
        }
    }
    /**
     * Sets the id
     * The identifier of a authentication context in your tenant.
     *
     * @param string $val The value of the id
     *
     * @return AuthenticationContext
     */
    public function setId($val)
    {
        $this->_propDict["id"] = $val;
        return $this;
    }
}
