<?php

/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AccessReviewInstanceDecisionItemUserTarget File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace XCloner\Beta\Microsoft\Graph\Model;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
/**
* AccessReviewInstanceDecisionItemUserTarget class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AccessReviewInstanceDecisionItemUserTarget extends AccessReviewInstanceDecisionItemTarget
{
    /**
     * Set the @odata.type since this type is immediately descended from an abstract
     * type that is referenced as the type in an entity.
     * @param array $propDict The property dictionary
     */
    public function __construct($propDict = array())
    {
        parent::__construct($propDict);
        $this->setODataType("#microsoft.graph.accessReviewInstanceDecisionItemUserTarget");
    }
    /**
     * Gets the userDisplayName
     * The name of user.
     *
     * @return string|null The userDisplayName
     */
    public function getUserDisplayName()
    {
        if (array_key_exists("userDisplayName", $this->_propDict)) {
            return $this->_propDict["userDisplayName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userDisplayName
     * The name of user.
     *
     * @param string $val The value of the userDisplayName
     *
     * @return AccessReviewInstanceDecisionItemUserTarget
     */
    public function setUserDisplayName($val)
    {
        $this->_propDict["userDisplayName"] = $val;
        return $this;
    }
    /**
     * Gets the userId
     * The identifier of user.
     *
     * @return string|null The userId
     */
    public function getUserId()
    {
        if (array_key_exists("userId", $this->_propDict)) {
            return $this->_propDict["userId"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userId
     * The identifier of user.
     *
     * @param string $val The value of the userId
     *
     * @return AccessReviewInstanceDecisionItemUserTarget
     */
    public function setUserId($val)
    {
        $this->_propDict["userId"] = $val;
        return $this;
    }
    /**
     * Gets the userPrincipalName
     * The user principal name.
     *
     * @return string|null The userPrincipalName
     */
    public function getUserPrincipalName()
    {
        if (array_key_exists("userPrincipalName", $this->_propDict)) {
            return $this->_propDict["userPrincipalName"];
        } else {
            return null;
        }
    }
    /**
     * Sets the userPrincipalName
     * The user principal name.
     *
     * @param string $val The value of the userPrincipalName
     *
     * @return AccessReviewInstanceDecisionItemUserTarget
     */
    public function setUserPrincipalName($val)
    {
        $this->_propDict["userPrincipalName"] = $val;
        return $this;
    }
}
