<?php

namespace XCloner\As247\CloudStorages\Cache\Stores;

if (!defined('ABSPATH') && \PHP_SAPI !== 'cli') {
    die;
}
use XCloner\As247\CloudStorages\Support\Path;
class GoogleDrivePersistentStore extends GoogleDriveStore
{
    protected $sqliteCache;
    public function __construct($cacheFile)
    {
        $this->sqliteCache = new SqliteCache($cacheFile);
    }
    public function put($key, $data, $seconds = 3600)
    {
        $key = Path::clean($key);
        if (!$data) {
            //parent::put($key,$data);//Keep false item in object cache
            if (is_null($data)) {
                $this->sqliteCache->forget($key);
                $this->complete($key, \false);
            } else {
                $this->sqliteCache->put($key, $data);
            }
        } else {
            //parent::put($key,null);
            $this->sqliteCache->forever($key, $data);
        }
    }
    public function get($key)
    {
        if (null !== $parentValue = parent::get($key)) {
            return $parentValue;
        }
        $key = Path::clean($key);
        $cache = $this->sqliteCache->get($key);
        return $cache;
    }
    function query($path, $deep = 1)
    {
        $path = Path::clean($path);
        $directory = $path;
        if ($deep >= 1) {
            //Like /dirname/% and not like /dirname/%/%
            $directory = $path === '/' ? $path : $path . '/';
        }
        //Like /dirname%
        $list = $this->sqliteCache->pathQuery($directory, $deep);
        if ($deep === 0) {
            return $list;
        }
        unset($list[$path]);
        return $list;
    }
    public function complete($path, $isCompleted = \true)
    {
        $path = Path::clean($path);
        return $this->sqliteCache->complete($path, $isCompleted);
    }
    public function isCompleted($path)
    {
        $path = Path::clean($path);
        return $this->sqliteCache->isCompleted($path);
        // TODO: Change the autogenerated stub
    }
    public function getCompleted($path)
    {
        $path = Path::clean($path);
        return $this->sqliteCache->getCompleted($path);
        // TODO: Change the autogenerated stub
    }
}
