<?php

	// Get ID of form (0 = New)
	$ws_form_form_id = absint(WS_Form_Common::get_query_var('id', 0));

	// Loader icon
	WS_Form_Common::loader();
?>
<!-- Layout Editor -->
<div id="wsf-layout-editor">

<!-- Header -->
<div class="wsf-loading-hidden">
<div id="wsf-header">
<h1><?php esc_html_e('Edit Form', 'ws-form') ?></h1>

<!-- Form actions -->
<?php

	// Publish
	if(WS_Form_Common::can_user('publish_form')) {
?>
<button data-action="wsf-publish" class="wsf-button wsf-button-small wsf-button-information" disabled><?php WS_Form_Common::render_icon_16_svg('publish'); ?> <?php esc_html_e('Publish', 'ws-form'); ?></button>
<?php
	}

	// Preview
?>
<a data-action="wsf-preview" class="wsf-button wsf-button-small" href="<?php WS_Form_Common::echo_esc_url(WS_Form_Common::get_preview_url($ws_form_form_id)); ?>" target="wsf-preview-<?php WS_Form_Common::echo_esc_attr($ws_form_form_id); ?>"><?php WS_Form_Common::render_icon_16_svg('visible'); ?> <?php esc_html_e('Preview', 'ws-form'); ?></a>
<?php

	// Style
	if(WS_Form_Common::styler_visible_admin()) {
?>
<a data-action="wsf-style" class="wsf-button wsf-button-small" href="#" target="wsf-style-<?php WS_Form_Common::echo_esc_attr($ws_form_form_id); ?>"><?php WS_Form_Common::render_icon_16_svg('style'); ?> <?php esc_html_e('Style', 'ws-form'); ?></a>
<?php
	}

	// Submissions
	if(WS_Form_Common::can_user('read_submission')) {
?>
<a data-action="wsf-submission" class="wsf-button wsf-button-small" href="<?php WS_Form_Common::echo_esc_url(admin_url('admin.php?page=ws-form-submit&id=' . $ws_form_form_id)); ?>"><?php WS_Form_Common::render_icon_16_svg('table'); ?> <?php esc_html_e('Submissions', 'ws-form'); ?></a>
<?php
	}

	// Hook for additional buttons
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- All hooks prefixed with wsf_
	do_action('wsf_form_edit_nav_left', $ws_form_form_id);
?>
<ul class="wsf-settings wsf-settings-form">
<?php
	// Download
	if(WS_Form_Common::can_user('export_form')) {
?>
<li data-action="wsf-form-download"<?php WS_Form_Common::echo_esc_attr_tooltip(__('Export Form', 'ws-form'), 'bottom-center'); ?>><?php WS_Form_Common::render_icon_16_svg('download'); ?></li>
<?php
	}
	
	// Upload
	if(WS_Form_Common::can_user('import_form')) {
?>
<li data-action="wsf-form-upload"<?php WS_Form_Common::echo_esc_attr_tooltip(__('Import Form', 'ws-form'), 'bottom-center'); ?>><?php WS_Form_Common::render_icon_16_svg('upload'); ?></li>
<?php
	}
?>
<li data-action="wsf-redo"<?php WS_Form_Common::echo_esc_attr_tooltip(__('Redo', 'ws-form'), 'bottom-center'); ?> class="wsf-redo-inactive"><?php WS_Form_Common::render_icon_16_svg('redo'); ?></li>
<li data-action="wsf-undo"<?php WS_Form_Common::echo_esc_attr_tooltip(__('Undo', 'ws-form'), 'bottom-center'); ?> class="wsf-undo-inactive"><?php WS_Form_Common::render_icon_16_svg('undo'); ?></li>
</ul>
<?php

	// Upload
	if(WS_Form_Common::can_user('import_form')) {
?>
<input type="file" id="wsf-object-upload-file" class="wsf-file-upload" accept=".json" aria-hidden aria-label="<?php esc_html_e('File upload', 'ws-form'); ?>"/>
<?php
	}
?>
</div>
</div>
<!-- /Header -->
<?php

	// Review nag
	WS_Form_Common::review();
?>
<!-- Wrapper -->
<div id="poststuff" class="wsf-loading-hidden">

<hr class="wp-header-end">

<!-- Label -->
<div id="titlediv">
<div id="titlewrap">

<label class="screen-reader-text" id="title-prompt-text" for="title"><?php esc_html_e('Form Label', 'ws-form'); ?></label>
<input type="text" id="title" class="wsf-field" placeholder="<?php esc_html_e('Form Label', 'ws-form'); ?>" data-action="wsf-form-label" name="form_label" size="30" value="" spellcheck="true" autocomplete="off" />
<button data-action="wsf-label-save" class="wsf-button wsf-button-small wsf-button-primary"><?php esc_html_e('Save', 'ws-form'); ?></button>

</div>
</div>
<!-- /Label -->

<!-- Form -->
<div id="wsf-form" class="wsf-form wsf-form-canvas"></div>
<!-- /Form -->

</div>
<!-- /Wrapper -->

<!-- Breakpoints -->
<div id="wsf-breakpoints"></div>
<!-- /Breakpoints -->

</div>
<!-- /Layout Editor -->

<!-- Popover -->
<div id="wsf-popover" class="wsf-ui-cancel"></div>
<!-- /Popover -->

<!-- Field Draggable Container (Fixes Chrome bug) -->
<div class="wsf-field-selector"><div id="wsf-field-draggable"><ul></ul></div></div>
<!-- /Field Draggable Container (Fixes Chrome bug) -->

<!-- Section Draggable Container (Fixes Chrome bug) -->
<div class="wsf-section-selector"><div id="wsf-section-draggable"><ul></ul></div></div>
<!-- /Section Draggable Container (Fixes Chrome bug) -->

<!-- Sidebars -->
<div id="wsf-sidebars"></div>
<!-- /Sidebars -->

<!-- Variable Helper -->
<div id="wsf-variable-helper-modal" class="wsf-modal">

<div id="wsf-variable-helper">

<!-- Variable Helper - Header -->
<div id="wsf-variable-helper-header">

<div class="wsf-modal-title"><?php

	WS_Form_Common::echo_get_admin_icon('#002e5f', false);	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

?><h2><?php

	WS_Form_Common::echo_esc_html(__('Variables', 'ws-form'));	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

?></h2></div>

<div class="wsf-modal-close" data-action="wsf-close" title="<?php esc_attr_e('Close', 'ws-form'); ?>"></div>

</div>
<!-- /Variable Helper - Header -->

<!-- Variable Helper - Content -->
<div class="wsf-modal-content">

<!-- Variable Helper - Search -->
<div id="wsf-variable-helper-search">

<input id="wsf-variable-helper-search-input" class="wsf-field" type="search" placeholder="<?php

	WS_Form_Common::echo_esc_html(__('Variable search...', 'ws-form'));	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

?>" />

</div>
<!-- Variable Helper - /Search -->

<!-- Variable Helper - Search - No Results -->
<div id="wsf-variable-helper-search-no-results">
	
<p><?php

	WS_Form_Common::echo_esc_html(__('No results', 'ws-form'));	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

?>
</div>
<!-- /Variable Helper - /Search - No Results -->

<!-- Variable Helper - Tabs -->
<div id="wsf-variable-helper-variables"></div>
<!-- /Variable Helper - /Tabs -->

</div>
<!-- /Variable Helper - Content -->

</div>

</div>
<!-- /Variable Helper -->

<script>

<?php

	// Get form data
	try {

		$ws_form_form = new WS_Form_Form();
		$ws_form_form->id = $ws_form_form_id;
		$ws_form_form_object = $ws_form_form->db_read(true, true);
		$ws_form_json_form = wp_json_encode($ws_form_form_object);

	} catch(Exception $e) {

		$ws_form_json_form = false;
	}
?>

	// Embed form data
	var wsf_form_json = { <?php

	WS_Form_Common::echo_esc_html(absint($ws_form_form_id));

?>: <?php

	WS_Form_Common::echo_json($ws_form_json_form);
?> };

	var wsf_obj = null;

	(function($) {

		'use strict';

		// On load
		$(function() {

			// Initialize WS Form
			var wsf_obj = new $.WS_Form();

			// Highlight menu item
			wsf_obj.menu_highlight();

			// Render form
			wsf_obj.render({

				'obj': '#wsf-form',
				'form_id': <?php WS_Form_Common::echo_esc_attr($ws_form_form_id); ?>
			});
		});

	})(jQuery);

</script>
