// Custom SVG icons for form fields
const FormIcons = {
    multiCheckbox: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6 16.2503C6.96621 16.2503 7.75 17.0341 7.75 18.0003V20.0003C7.74985 20.9664 6.96612 21.7503 6 21.7503H4C3.03388 21.7503 2.25015 20.9664 2.25 20.0003V18.0003C2.25 17.0341 3.03379 16.2503 4 16.2503H6ZM4 17.7503C3.86221 17.7503 3.75 17.8626 3.75 18.0003V20.0003C3.75015 20.138 3.86231 20.2503 4 20.2503H6C6.13769 20.2503 6.24985 20.138 6.25 20.0003V18.0003C6.25 17.8626 6.13779 17.7503 6 17.7503H4Z" fill="black"/>
			<path d="M21 18.2503C21.4142 18.2503 21.75 18.5861 21.75 19.0003C21.7498 19.4144 21.4141 19.7503 21 19.7503H11C10.5859 19.7503 10.2502 19.4144 10.25 19.0003C10.25 18.5861 10.5858 18.2503 11 18.2503H21Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6 9.25035C6.96621 9.25035 7.75 10.0341 7.75 11.0003V13.0003C7.74985 13.9664 6.96612 14.7503 6 14.7503H4C3.03388 14.7503 2.25015 13.9664 2.25 13.0003V11.0003C2.25 10.0341 3.03379 9.25035 4 9.25035H6ZM4 10.7503C3.86221 10.7503 3.75 10.8626 3.75 11.0003V13.0003C3.75015 13.138 3.86231 13.2503 4 13.2503H6C6.13769 13.2503 6.24985 13.138 6.25 13.0003V11.0003C6.25 10.8626 6.13779 10.7503 6 10.7503H4Z" fill="black"/>
			<path d="M21 11.2503C21.4142 11.2503 21.75 11.5861 21.75 12.0003C21.7498 12.4144 21.4141 12.7503 21 12.7503H11C10.5859 12.7503 10.2502 12.4144 10.25 12.0003C10.25 11.5861 10.5858 11.2503 11 11.2503H21Z" fill="black"/>
			<path d="M6.02539 3.47007C6.31823 3.17724 6.79303 3.17735 7.08594 3.47007C7.37869 3.76298 7.37878 4.23777 7.08594 4.53062L4.86426 6.7523C4.58965 7.02677 4.1549 7.04436 3.86035 6.80406L3.80371 6.75328L2.46973 5.42027L2.41797 5.36265C2.17794 5.06822 2.19549 4.63333 2.46973 4.35875C2.74427 4.08437 3.17909 4.06685 3.47363 4.30699L3.53027 4.35875L4.33301 5.16148L6.02539 3.47007Z" fill="black"/>
			<path d="M21 4.25035C21.4142 4.25035 21.75 4.58613 21.75 5.00035C21.7498 5.41443 21.4141 5.75035 21 5.75035H11C10.5859 5.75035 10.2502 5.41443 10.25 5.00035C10.25 4.58613 10.5858 4.25035 11 4.25035H21Z" fill="black"/>
		</svg>
    ),
    checkbox: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M15.2188 9.38867C15.5132 9.14876 15.9481 9.16617 16.2227 9.44043C16.5152 9.73322 16.5151 10.2081 16.2227 10.501L11.4355 15.2891C11.295 15.4297 11.1041 15.5087 10.9053 15.5088C10.7065 15.5088 10.5156 15.4296 10.375 15.2891L8.18164 13.0957L8.12988 13.0391C7.8899 12.7445 7.90716 12.3096 8.18164 12.0352C8.4563 11.7607 8.89105 11.744 9.18555 11.9844L9.24219 12.0352L10.9043 13.6973L15.1611 9.44043L15.2188 9.38867Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M19 2.25C20.5192 2.25 21.75 3.48079 21.75 5V19C21.75 20.5192 20.5192 21.75 19 21.75H5C3.48079 21.75 2.25 20.5192 2.25 19V5C2.25 3.48079 3.48079 2.25 5 2.25H19ZM5 3.75C4.30921 3.75 3.75 4.30921 3.75 5V19C3.75 19.6908 4.30921 20.25 5 20.25H19C19.6908 20.25 20.25 19.6908 20.25 19V5C20.25 4.30921 19.6908 3.75 19 3.75H5Z" fill="black"/>
		</svg>
    ),
    emailInput: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12 2.25C17.3852 2.25 21.75 6.61479 21.75 12V13.5C21.75 15.2952 20.2952 16.75 18.5 16.75C17.2652 16.75 16.1917 16.0617 15.6416 15.0479C14.7702 16.0878 13.4628 16.75 12 16.75C9.37679 16.75 7.25 14.6232 7.25 12C7.25 9.37679 9.37679 7.25 12 7.25C14.6232 7.25 16.75 9.37679 16.75 12V13.5C16.75 14.4668 17.5332 15.25 18.5 15.25C19.4668 15.25 20.25 14.4668 20.25 13.5V12C20.25 7.44321 16.5568 3.75 12 3.75C7.44321 3.75 3.75 7.44321 3.75 12C3.75 16.5568 7.44321 20.25 12 20.25C13.0536 20.25 14.1241 20.0502 15.1572 19.6221L15.5654 19.4395C15.9663 19.2457 16.3459 19.0203 16.7051 18.7705C17.0451 18.5341 17.5125 18.618 17.749 18.958C17.9852 19.298 17.9014 19.7655 17.5615 20.002C17.0723 20.3422 16.5444 20.6466 15.9766 20.9014L15.7314 21.0078C14.5106 21.5137 13.2444 21.75 12 21.75C6.61479 21.75 2.25 17.3852 2.25 12C2.25 6.61479 6.61479 2.25 12 2.25ZM12 8.75C10.2052 8.75 8.75 10.2052 8.75 12C8.75 13.7948 10.2052 15.25 12 15.25C13.7948 15.25 15.25 13.7948 15.25 12C15.25 10.2052 13.7948 8.75 12 8.75Z" fill="black"/>
		</svg>
    ),
    label: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.31934 7.15039C7.73681 6.81004 8.33936 6.81004 8.75684 7.15039L8.84375 7.22852L8.92188 7.31543C9.28647 7.76279 9.26065 8.42294 8.84375 8.83984C8.39898 9.28456 7.67723 9.2845 7.23242 8.83984C6.78763 8.39505 6.78766 7.67333 7.23242 7.22852L7.31934 7.15039Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10.3594 2.26172C10.902 2.31138 11.4169 2.52263 11.8379 2.86621L12.041 3.04883L20.9453 11.958L21.1338 12.167C21.9559 13.1752 21.9561 14.6306 21.1338 15.6387L20.9453 15.8477L15.8516 20.9443C14.7776 22.0194 13.0339 22.0196 11.96 20.9443L3.0498 12.0303C2.53815 11.5186 2.25002 10.8235 2.25 10.0986V7.28711C2.25 6.56225 2.53815 5.86714 3.0498 5.35547L5.3291 3.0752L5.52832 2.89551C6.00878 2.50097 6.61107 2.28141 7.2373 2.27637L10.0859 2.25L10.3594 2.26172ZM7.25098 3.77539C6.96915 3.77756 6.69636 3.87645 6.47949 4.05469L6.39062 4.13574L4.11035 6.41602C3.88006 6.64633 3.75 6.96001 3.75 7.28711V10.0986C3.75002 10.4257 3.88005 10.7394 4.11035 10.9697L13.0215 19.8838L13.1162 19.9697C13.6072 20.3708 14.3324 20.342 14.79 19.8838L19.8848 14.7871L19.9707 14.6914C20.3441 14.2332 20.3442 13.5714 19.9707 13.1133L19.8848 13.0186L10.9814 4.11133L10.8896 4.02832C10.6988 3.87257 10.4662 3.77719 10.2227 3.75488L10.0996 3.75L7.25098 3.77539Z" fill="black"/>
		</svg>
    ),
    nameInput: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.4238 15.25C15.4257 15.25 16.3853 15.6291 17.1182 16.3086L17.2764 16.4639C17.5836 16.7819 17.8362 17.1488 18.0225 17.5508L18.1104 17.7539L18.1348 17.8271C18.2385 18.1928 18.0504 18.5853 17.6895 18.7285C17.3288 18.8715 16.9233 18.7149 16.748 18.3779L16.7158 18.3076L16.6611 18.1816C16.5264 17.891 16.3362 17.6283 16.0996 17.4092C15.6426 16.9852 15.0456 16.75 14.4238 16.75H9.57617C9.03239 16.75 8.50773 16.9297 8.07812 17.2588L7.89941 17.4092C7.62976 17.6589 7.41914 17.9656 7.28223 18.3086L7.25098 18.3789C7.07514 18.716 6.66831 18.8715 6.30762 18.7275C5.92315 18.5739 5.73617 18.1375 5.88965 17.7529L5.97656 17.5498C6.19385 17.0822 6.49996 16.6605 6.87988 16.3086L7.02051 16.1846C7.73408 15.5831 8.6366 15.25 9.57617 15.25H14.4238Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M8.99512 6.91699C10.6548 5.25734 13.3452 5.25735 15.0049 6.91699L15.1562 7.0752C16.6635 8.74353 16.6127 11.3189 15.0049 12.9268C13.3451 14.5865 10.6549 14.5865 8.99512 12.9268C7.33546 11.267 7.33541 8.5767 8.99512 6.91699ZM13.7354 7.78809C12.6552 6.90756 11.0623 6.97092 10.0557 7.97754C8.98174 9.05146 8.98179 10.7923 10.0557 11.8662C11.1296 12.9402 12.8704 12.9402 13.9443 11.8662C14.951 10.8595 15.0144 9.26663 14.1338 8.18652L13.9443 7.97754L13.7354 7.78809Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M19 2.25C20.5192 2.25 21.75 3.48079 21.75 5V19C21.75 20.5192 20.5192 21.75 19 21.75H5C3.48079 21.75 2.25 20.5192 2.25 19V5C2.25 3.48079 3.48079 2.25 5 2.25H19ZM5 3.75C4.30921 3.75 3.75 4.30921 3.75 5V19C3.75 19.6908 4.30921 20.25 5 20.25H19C19.6908 20.25 20.25 19.6908 20.25 19V5C20.25 4.30921 19.6908 3.75 19 3.75H5Z" fill="black"/>
		</svg>
    ),
    phoneInput: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.95704 3.25C7.55364 3.2501 8.12599 3.48731 8.54786 3.90918L10.4648 5.82617L10.6533 6.03516C11.4758 7.0434 11.4759 8.49863 10.6533 9.50684L10.4648 9.71582L9.31543 10.8643C10.0742 12.5648 11.4344 13.9246 13.1348 14.6836L14.2842 13.5352L14.4863 13.3525C14.9757 12.9516 15.5913 12.7295 16.2295 12.7295C16.9587 12.7296 17.6582 13.0195 18.1738 13.5352L20.0908 15.4521L20.2451 15.623C20.9182 16.448 20.9183 17.6389 20.2451 18.4639L20.0908 18.6348L19.2324 19.4932C18.4788 20.2468 17.4735 20.6907 16.4141 20.7441L16.2012 20.75C12.7654 20.7529 9.4695 19.3894 7.04004 16.96C4.6106 14.5305 3.24706 11.2346 3.25 7.79883L3.25586 7.58594C3.30933 6.5265 3.75323 5.52125 4.50684 4.76758L5.36524 3.90918L5.53028 3.75977C5.93071 3.43153 6.43474 3.25 6.95704 3.25ZM6.95704 4.75C6.80799 4.75 6.66326 4.79456 6.54102 4.87598L6.42676 4.96973L5.56739 5.82812C5.04452 6.35106 4.7507 7.06031 4.75 7.7998L4.76368 8.36816C4.90187 11.1989 6.08704 13.8859 8.10059 15.8994C10.2484 18.0473 13.1627 19.2526 16.2002 19.25L16.4756 19.2363C17.1139 19.1725 17.7143 18.8902 18.1719 18.4326L19.0303 17.5732L19.082 17.5166C19.3061 17.2418 19.306 16.8452 19.082 16.5703L19.0303 16.5127L17.1133 14.5957C16.879 14.3614 16.5609 14.2296 16.2295 14.2295C15.9393 14.2295 15.659 14.3303 15.4365 14.5127L15.3447 14.5957L13.8418 16.0986C13.6342 16.3061 13.3248 16.374 13.0498 16.2715C10.5884 15.3535 8.64647 13.4116 7.72852 10.9502C7.62603 10.6752 7.69387 10.3658 7.90137 10.1582L9.4043 8.6543L9.49024 8.55957C9.8637 8.10146 9.86363 7.44057 9.49024 6.98242L9.4043 6.88672L7.48731 4.96973C7.34675 4.82917 7.15581 4.7501 6.95704 4.75Z" fill="black"/>
		</svg>
    ),
    textInput: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M16 20.25C16.4142 20.25 16.75 20.5858 16.75 21C16.75 21.4142 16.4142 21.75 16 21.75H4C3.58579 21.75 3.25 21.4142 3.25 21C3.25 20.5858 3.58579 20.25 4 20.25H16Z" fill="black"/>
			<path d="M20 16.25C20.4142 16.25 20.75 16.5858 20.75 17C20.75 17.4142 20.4142 17.75 20 17.75H4C3.58579 17.75 3.25 17.4142 3.25 17C3.25 16.5858 3.58579 16.25 4 16.25H20Z" fill="black"/>
			<path d="M4.71484 13.3115C4.55067 13.6914 4.10961 13.8669 3.72949 13.7031C3.34915 13.5391 3.17384 13.0971 3.33789 12.7168L4.71484 13.3115Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M7.95215 3.25294C7.98573 3.25469 8.01894 3.2575 8.05176 3.26368C8.08353 3.26964 8.11508 3.27781 8.14648 3.28809C8.1557 3.29111 8.16474 3.29449 8.17383 3.29786C8.18613 3.30241 8.19875 3.30628 8.21094 3.31153C8.23146 3.32038 8.25119 3.33041 8.27051 3.34083C8.27744 3.34457 8.2842 3.34858 8.29102 3.35254C8.31685 3.36754 8.34081 3.38473 8.36426 3.40235C8.38566 3.41844 8.40512 3.43665 8.4248 3.45508C8.44089 3.47014 8.4571 3.48469 8.47168 3.50098C8.48741 3.51857 8.50148 3.53742 8.51562 3.55665C8.53027 3.57652 8.54504 3.59607 8.55762 3.61719C8.56119 3.62322 8.56591 3.62862 8.56934 3.63477L8.60352 3.70411L11.7871 11.1094C11.7895 11.1152 11.7917 11.1211 11.7939 11.127L12.4785 12.7178C12.642 13.0983 12.4654 13.5395 12.085 13.7031C11.7045 13.8665 11.2632 13.6909 11.0996 13.3106L10.5996 12.1465H5.21777L4.71484 13.3115L4.02637 13.0137L3.33789 12.7168L4.0127 11.1514C4.02486 11.1163 4.03865 11.0823 4.05566 11.0498L7.22559 3.70313C7.24287 3.66307 7.2631 3.6252 7.28613 3.58985C7.34153 3.50484 7.41477 3.4308 7.50293 3.37305C7.51576 3.36466 7.52968 3.35817 7.54297 3.35059C7.56739 3.33666 7.59173 3.32191 7.61816 3.31055C7.62262 3.30864 7.62737 3.30749 7.63184 3.30567C7.64109 3.30191 7.65076 3.29929 7.66016 3.2959C7.69741 3.28244 7.73461 3.27098 7.77246 3.26368C7.77761 3.26268 7.78292 3.26261 7.78809 3.26172C7.82854 3.2548 7.86886 3.25121 7.90918 3.25098C7.92351 3.25088 7.93777 3.25221 7.95215 3.25294ZM5.86426 10.6465H9.9541L7.91211 5.89649L5.86426 10.6465Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M14.9326 7.69532C16.1478 6.5966 17.9515 6.50718 19.2627 7.42676C19.3264 7.07715 19.632 6.81153 20 6.81153C20.4141 6.81153 20.7497 7.14754 20.75 7.56153V13C20.7497 13.414 20.4141 13.75 20 13.75C19.6318 13.75 19.3262 13.4847 19.2627 13.1348C17.951 14.0553 16.1483 13.9676 14.9326 12.8682L14.8027 12.7451C13.4422 11.3844 13.4417 9.17843 14.8027 7.81837L14.9326 7.69532ZM18.5186 8.74317C17.74 8.10732 16.5901 8.15282 15.8643 8.87891L15.8633 8.87989C15.0889 9.65378 15.0882 10.9094 15.8633 11.6846L16.0146 11.8213C16.7931 12.4564 17.9423 12.4112 18.6689 11.6846L18.8057 11.5342C19.3987 10.8076 19.3982 9.75786 18.8047 9.03028L18.6689 8.87891L18.5186 8.74317Z" fill="black"/>
		</svg>
    ),
    radio: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.26444 16.8661C4.32421 16.0022 5.87557 16.049 6.88456 17.0018L6.88749 17.0038L6.94413 17.0556L7.13358 17.2645C7.95522 18.2725 7.95526 19.7273 7.13358 20.7352L6.94413 20.9442C5.93749 21.9509 4.34456 22.0141 3.26444 21.1337L3.05546 20.9442C1.98151 19.8703 1.98151 18.1295 3.05546 17.0556L3.26444 16.8661ZM5.78885 18.0302C5.33063 17.6564 4.66898 17.6564 4.21073 18.0302L4.116 18.1161C3.62785 18.6043 3.62785 19.3955 4.116 19.8837L4.21073 19.9696C4.7017 20.37 5.42597 20.3413 5.88358 19.8837L5.96952 19.789C6.34322 19.3307 6.34319 18.6691 5.96952 18.2108L5.88358 18.1161L5.78885 18.0302Z" fill="black"/>
			<path d="M20.9998 18.2499C21.4139 18.25 21.7498 18.5857 21.7498 18.9999C21.7498 19.414 21.4139 19.7498 20.9998 19.7499H10.9998C10.5856 19.7499 10.2498 19.4141 10.2498 18.9999C10.2498 18.5857 10.5856 18.2499 10.9998 18.2499H20.9998Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.26444 9.8661C4.32421 9.00218 5.87557 9.04904 6.88456 10.0018L6.88749 10.0038L6.94413 10.0556L7.13358 10.2645C7.95522 11.2725 7.95526 12.7273 7.13358 13.7352L6.94413 13.9442C5.93749 14.9509 4.34456 15.0141 3.26444 14.1337L3.05546 13.9442C1.98151 12.8703 1.98151 11.1295 3.05546 10.0556L3.26444 9.8661ZM5.78885 11.0302C5.33063 10.6564 4.66898 10.6564 4.21073 11.0302L4.116 11.1161C3.62785 11.6043 3.62785 12.3955 4.116 12.8837L4.21073 12.9696C4.7017 13.37 5.42597 13.3413 5.88358 12.8837L5.96952 12.789C6.34322 12.3307 6.34319 11.6691 5.96952 11.2108L5.88358 11.1161L5.78885 11.0302Z" fill="black"/>
			<path d="M20.9998 11.2499C21.4139 11.25 21.7498 11.5857 21.7498 11.9999C21.7498 12.414 21.4139 12.7498 20.9998 12.7499H10.9998C10.5856 12.7499 10.2498 12.4141 10.2498 11.9999C10.2498 11.5857 10.5856 11.2499 10.9998 11.2499H20.9998Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.26444 2.8661C4.32421 2.00217 5.87557 2.04904 6.88456 3.00184L6.88749 3.0038L6.94413 3.05555L7.13358 3.26454C7.95522 4.27247 7.95526 5.72733 7.13358 6.73524L6.94413 6.94422C5.93749 7.95086 4.34456 8.01414 3.26444 7.13368L3.05546 6.94422C1.98151 5.87028 1.98151 4.1295 3.05546 3.05555L3.26444 2.8661ZM5.78885 4.03016C5.33063 3.65639 4.66898 3.65644 4.21073 4.03016L4.116 4.1161C3.62785 4.60426 3.62785 5.39552 4.116 5.88368L4.21073 5.96962C4.7017 6.36996 5.42597 6.34129 5.88358 5.88368L5.96952 5.78895C6.34323 5.33075 6.34318 4.66906 5.96952 4.21083L5.88358 4.1161L5.78885 4.03016Z" fill="black"/>
			<path d="M20.9998 4.24989C21.4139 4.25 21.7498 4.58575 21.7498 4.99989C21.7498 5.414 21.4139 5.74978 20.9998 5.74989H10.9998C10.5856 5.74989 10.2498 5.41407 10.2498 4.99989C10.2498 4.58568 10.5856 4.24989 10.9998 4.24989H20.9998Z" fill="black"/>
		</svg>
    ),
    select: (
		<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M15.3223 14.8086C15.3223 13.424 16.9988 12.7245 17.9805 13.708L17.9795 13.709L23.293 19.0205C24.2426 19.9701 23.6215 21.5746 22.3193 21.6738L22.1914 21.6777H19.6084L17.9756 23.2969C16.9923 24.2704 15.3224 23.575 15.3223 22.1914V14.8086ZM16.8574 14.7559C16.8421 14.7622 16.833 14.7709 16.8291 14.7764C16.8275 14.7786 16.8262 14.7812 16.8252 14.7842C16.8243 14.7871 16.8223 14.7952 16.8223 14.8086V22.1914C16.8223 22.2045 16.8242 22.2117 16.8252 22.2148C16.8262 22.2179 16.8276 22.2204 16.8291 22.2227C16.8329 22.228 16.842 22.2377 16.8574 22.2441C16.8726 22.2504 16.8851 22.2501 16.8916 22.249C16.8945 22.2485 16.8973 22.2477 16.9004 22.2461C16.9033 22.2446 16.9096 22.2406 16.9189 22.2314L18.7715 20.3955L18.8848 20.3027C19.0066 20.222 19.1506 20.1778 19.2988 20.1777H22.1914C22.2052 20.1777 22.2127 20.1758 22.2158 20.1748C22.2191 20.1738 22.2213 20.1725 22.2236 20.1709C22.2289 20.1672 22.2378 20.1587 22.2441 20.1436C22.2504 20.1286 22.251 20.1159 22.25 20.1094C22.2495 20.1066 22.2486 20.1035 22.2471 20.1006C22.2456 20.0978 22.242 20.0906 22.2324 20.0811L16.918 14.7676C16.9086 14.7583 16.9021 14.7543 16.8994 14.7529C16.8967 14.7516 16.8942 14.7514 16.8916 14.751C16.8854 14.7499 16.873 14.7494 16.8574 14.7559Z" fill="black"/>
			<path d="M17.4756 1.25C18.8698 1.25 20 2.3802 20 3.77441V10.625C20 11.0392 19.6642 11.375 19.25 11.375C18.8358 11.375 18.5 11.0392 18.5 10.625V3.77441C18.5 3.20863 18.0414 2.75 17.4756 2.75H3.77441C3.20863 2.75 2.75 3.20863 2.75 3.77441V17.4756C2.75 18.0414 3.20863 18.5 3.77441 18.5H12C12.4142 18.5 12.75 18.8358 12.75 19.25C12.75 19.6642 12.4142 20 12 20H3.77441C2.3802 20 1.25 18.8698 1.25 17.4756V3.77441C1.25 2.3802 2.3802 1.25 3.77441 1.25H17.4756Z" fill="black"/>
			<path d="M5.58203 14.3525C5.95754 14.0463 6.49541 14.0593 6.85938 14.3682C6.86576 14.3733 6.87169 14.3794 6.87793 14.3848L6.91797 14.4189L6.96973 14.4756C7.3098 14.8687 7.29328 15.4625 6.91992 15.8359C6.52905 16.2267 5.89673 16.2267 5.50586 15.8359C5.11519 15.4451 5.11513 14.8127 5.50586 14.4219L5.58203 14.3525Z" fill="black"/>
			<path d="M12.0762 14.3789C12.4545 14.4172 12.75 14.7366 12.75 15.125C12.75 15.5134 12.4545 15.8328 12.0762 15.8711L12 15.875H10.3447C9.93051 15.875 9.59473 15.5392 9.59473 15.125C9.59473 14.7108 9.93051 14.375 10.3447 14.375H12L12.0762 14.3789Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M5.49609 9.84668C5.86949 9.54497 6.40882 9.55213 6.77539 9.86621C6.79408 9.88147 6.81259 9.89771 6.83008 9.91504L6.83203 9.91699L6.90137 9.99316C7.2219 10.3861 7.19829 10.9656 6.83203 11.332C6.44119 11.7227 5.80881 11.7227 5.41797 11.332C5.02726 10.9411 5.02714 10.3078 5.41797 9.91699L5.41992 9.91504L5.49609 9.84668ZM6.31543 10.4336L6.30176 10.4473L6.12598 10.625L6.44824 10.3008L6.47754 10.2705L6.47656 10.2695L6.31543 10.4336Z" fill="black"/>
			<path d="M15.5918 9.87891C15.9699 9.91742 16.2646 10.2368 16.2646 10.625C16.2646 11.0132 15.9699 11.3326 15.5918 11.3711L15.5146 11.375H10.2549C9.84072 11.3749 9.50488 11.0392 9.50488 10.625C9.50488 10.2108 9.84072 9.87506 10.2549 9.875H15.5146L15.5918 9.87891Z" fill="black"/>
			<path d="M5.49414 5.35156C5.86967 5.04531 6.40754 5.05828 6.77148 5.36719C6.77789 5.37235 6.78377 5.37837 6.79004 5.38379L6.83008 5.41797L6.88184 5.47461C7.2219 5.86773 7.20535 6.46151 6.83203 6.83496C6.44116 7.22573 5.80884 7.22573 5.41797 6.83496C5.02724 6.44409 5.02721 5.81176 5.41797 5.4209L5.49414 5.35156Z" fill="black"/>
			<path d="M15.5918 5.37891C15.9699 5.41742 16.2646 5.73675 16.2646 6.125C16.2646 6.51325 15.9699 6.83258 15.5918 6.87109L15.5146 6.875H10.2549C9.84072 6.87494 9.50488 6.53917 9.50488 6.125C9.50488 5.71083 9.84072 5.37506 10.2549 5.375H15.5146L15.5918 5.37891Z" fill="black"/>
		</svg>
    ),
    submit: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10.2012 9.97168C10.7781 9.73057 11.4437 9.85955 11.8887 10.2988L18.29 16.6182L18.3701 16.7041C18.7527 17.1437 18.8586 17.7653 18.6348 18.3105C18.4108 18.8559 17.8987 19.2238 17.3174 19.2676L17.2002 19.2715H13.9658L11.8838 21.3096C11.4658 21.7187 10.8561 21.8555 10.3076 21.6719L10.1982 21.6309C9.62319 21.389 9.24916 20.826 9.24902 20.2021V11.4023C9.24902 10.7772 9.6245 10.2129 10.2012 9.97168ZM10.7803 11.3555C10.7615 11.3633 10.749 11.3821 10.749 11.4023V20.2021C10.7492 20.2223 10.7617 20.2402 10.7803 20.248L10.8086 20.251C10.8182 20.2492 10.8277 20.2444 10.835 20.2373L13.1348 17.9863L13.249 17.8945C13.3703 17.8151 13.5132 17.7715 13.6602 17.7715H17.2002L17.2285 17.7637C17.2367 17.7582 17.2432 17.7497 17.2471 17.7402C17.2507 17.7311 17.2518 17.7212 17.25 17.7119L17.2354 17.6855L10.835 11.3662C10.8206 11.352 10.7989 11.3478 10.7803 11.3555Z" fill="black"/>
			<path d="M19.0029 2.24609C20.5221 2.24619 21.7539 3.47886 21.7539 4.99805V11C21.7536 12.519 20.5219 13.7509 19.0029 13.751H18.002C17.5881 13.7508 17.2522 13.4148 17.252 13.001C17.2521 12.587 17.588 12.2512 18.002 12.251H19.0029C19.6935 12.2509 20.2536 11.6905 20.2539 11V4.99805C20.2539 4.30729 19.6937 3.74716 19.0029 3.74707H4.99707C4.30625 3.74707 3.74609 4.30723 3.74609 4.99805V11C3.74636 11.6906 4.30642 12.251 4.99707 12.251H6.99805L7.07422 12.2549C7.45242 12.2932 7.74792 12.6127 7.74805 13.001C7.7478 13.3891 7.45234 13.7088 7.07422 13.7471L6.99805 13.751H4.99707C3.47799 13.751 2.24636 12.519 2.24609 11V4.99805C2.24609 3.4788 3.47783 2.24609 4.99707 2.24609H19.0029Z" fill="black"/>
		</svg>
    ),
    textarea: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19 3.25C20.5192 3.25 21.75 4.48079 21.75 6V18C21.75 19.5192 20.5192 20.75 19 20.75H6C4.48079 20.75 3.25 19.5192 3.25 18V14C3.25 13.5858 3.58579 13.25 4 13.25C4.41421 13.25 4.75 13.5858 4.75 14V18C4.75 18.6908 5.30921 19.25 6 19.25H19C19.6908 19.25 20.25 18.6908 20.25 18V6C20.25 5.30921 19.6908 4.75 19 4.75H14C13.5858 4.75 13.25 4.41421 13.25 4C13.25 3.58579 13.5858 3.25 14 3.25H19Z" fill="black"/>
			<path d="M17 15.25C17.4142 15.25 17.75 15.5858 17.75 16C17.75 16.4142 17.4142 16.75 17 16.75H8C7.58579 16.75 7.25 16.4142 7.25 16C7.25 15.5858 7.58579 15.25 8 15.25H17Z" fill="black"/>
			<path d="M17 11.25C17.4142 11.25 17.75 11.5858 17.75 12C17.75 12.4142 17.4142 12.75 17 12.75H12C11.5858 12.75 11.25 12.4142 11.25 12C11.25 11.5858 11.5858 11.25 12 11.25H17Z" fill="black"/>
			<path d="M9.66699 3.25C10.2652 3.25 10.75 3.73479 10.75 4.33301V5.3584C10.7498 5.77243 10.4141 6.1084 10 6.1084C9.58592 6.1084 9.25022 5.77243 9.25 5.3584V4.75H7.75V9.25H8.5C8.91421 9.25 9.25 9.58579 9.25 10C9.25 10.4142 8.91421 10.75 8.5 10.75H5.5C5.08579 10.75 4.75 10.4142 4.75 10C4.75 9.58579 5.08579 9.25 5.5 9.25H6.25V4.75H4.75V5.3584C4.74978 5.77243 4.41408 6.1084 4 6.1084C3.58592 6.1084 3.25022 5.77243 3.25 5.3584V4.33301C3.25 3.73479 3.73479 3.25 4.33301 3.25H9.66699Z" fill="black"/>
			<path d="M17 7.25C17.4142 7.25 17.75 7.58579 17.75 8C17.75 8.41421 17.4142 8.75 17 8.75H13C12.5858 8.75 12.25 8.41421 12.25 8C12.25 7.58579 12.5858 7.25 13 7.25H17Z" fill="black"/>
		</svg>
    ),
    websiteInput: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12 9.75C14.6282 9.75 16.75 11.8718 16.75 14.5C16.75 17.1282 14.6282 19.25 12 19.25C9.37179 19.25 7.25 17.1282 7.25 14.5C7.25 11.8718 9.37179 9.75 12 9.75ZM14.2607 15.25C14.1818 15.9469 13.9922 16.6321 13.6924 17.2764C14.4225 16.8316 14.9618 16.1075 15.1631 15.25H14.2607ZM8.83691 15.25C9.03806 16.1068 9.57653 16.8305 10.3057 17.2754C10.0063 16.6315 9.81714 15.9465 9.73828 15.25H8.83691ZM11.252 15.25C11.3554 15.9526 11.604 16.6363 12 17.2461C12.3961 16.6363 12.6446 15.9527 12.748 15.25H11.252ZM10.3066 11.7227C9.57671 12.1675 9.0382 12.8926 8.83691 13.75H9.73828C9.81727 13.0528 10.0066 12.3671 10.3066 11.7227ZM12 11.7539C11.6038 12.3635 11.3554 13.0473 11.252 13.75H12.748C12.6446 13.0473 12.3962 12.3636 12 11.7539ZM13.6924 11.7227C13.9925 12.3671 14.1817 13.0528 14.2607 13.75H15.1631C14.9617 12.8923 14.4227 12.1674 13.6924 11.7227Z" fill="black"/>
			<path d="M4.85645 4.74414C4.87328 4.74586 4.88977 4.74914 4.90625 4.75195C4.90915 4.75245 4.91214 4.7524 4.91504 4.75293C4.93888 4.75729 4.96138 4.7659 4.98438 4.77246C5.0122 4.78032 5.04066 4.78739 5.06836 4.79883L5.07324 4.7998C5.15731 4.83517 5.23987 4.88733 5.31348 4.96094C5.47394 5.1214 5.53418 5.32318 5.53418 5.49512C5.53418 5.66705 5.47394 5.86884 5.31348 6.0293C5.15302 6.18976 4.95123 6.25 4.7793 6.25C4.60736 6.25 4.40558 6.18976 4.24512 6.0293C4.12488 5.90906 4.06074 5.76555 4.03613 5.62891L4.02441 5.49512L4.03613 5.36133C4.06074 5.22469 4.12488 5.08118 4.24512 4.96094C4.31872 4.88733 4.40128 4.83517 4.48535 4.7998L4.48926 4.79883C4.51693 4.78736 4.54544 4.78035 4.57324 4.77246C4.59622 4.76587 4.61875 4.75732 4.64258 4.75293C4.64548 4.7524 4.64847 4.75245 4.65137 4.75195C4.69299 4.74479 4.73563 4.74023 4.7793 4.74023L4.85645 4.74414Z" fill="black"/>
			<path d="M7.39941 4.74414C7.41625 4.74586 7.43274 4.74914 7.44922 4.75195C7.45211 4.75245 7.45511 4.7524 7.45801 4.75293C7.48185 4.75729 7.50435 4.7659 7.52734 4.77246C7.55517 4.78032 7.58363 4.78739 7.61133 4.79883L7.61621 4.7998C7.70028 4.83517 7.78284 4.88733 7.85645 4.96094C8.01691 5.1214 8.07715 5.32318 8.07715 5.49512C8.07715 5.66705 8.01691 5.86884 7.85645 6.0293C7.69599 6.18976 7.4942 6.25 7.32227 6.25C7.10372 6.25 6.93315 6.15787 6.8252 6.06348C6.7183 5.96995 6.60085 5.80964 6.57324 5.5918L6.56738 5.49512L6.5791 5.36133C6.60371 5.22469 6.66784 5.08118 6.78809 4.96094C6.86169 4.88733 6.94425 4.83517 7.02832 4.7998L7.03223 4.79883C7.0599 4.78736 7.08841 4.78035 7.11621 4.77246C7.13919 4.76587 7.16172 4.75732 7.18555 4.75293C7.18845 4.7524 7.19144 4.75245 7.19434 4.75195C7.23596 4.74479 7.2786 4.74023 7.32227 4.74023L7.39941 4.74414Z" fill="black"/>
			<path d="M9.93848 4.74414C9.95531 4.74586 9.9718 4.74914 9.98828 4.75195C9.99118 4.75245 9.99417 4.7524 9.99707 4.75293C10.0209 4.75729 10.0434 4.7659 10.0664 4.77246C10.0942 4.78032 10.1227 4.78739 10.1504 4.79883L10.1553 4.7998C10.2393 4.83517 10.3219 4.88733 10.3955 4.96094C10.556 5.1214 10.6162 5.32318 10.6162 5.49512C10.6162 5.66705 10.556 5.86884 10.3955 6.0293C10.235 6.18976 10.0333 6.25 9.86133 6.25C9.68939 6.25 9.48761 6.18976 9.32715 6.0293C9.20691 5.90906 9.14277 5.76555 9.11816 5.62891L9.10645 5.49512L9.11816 5.36133C9.14277 5.22469 9.20691 5.08118 9.32715 4.96094C9.40075 4.88733 9.48331 4.83517 9.56738 4.7998L9.57129 4.79883C9.59897 4.78736 9.62747 4.78035 9.65527 4.77246C9.67826 4.76587 9.70078 4.75732 9.72461 4.75293C9.72751 4.7524 9.7305 4.75245 9.7334 4.75195C9.77502 4.74479 9.81766 4.74023 9.86133 4.74023L9.93848 4.74414Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M20 2.25C21.5192 2.25 22.75 3.48079 22.75 5V19C22.75 20.5192 21.5192 21.75 20 21.75H4C2.48079 21.75 1.25 20.5192 1.25 19V5C1.25 3.48079 2.48079 2.25 4 2.25H20ZM2.75 19C2.75 19.6908 3.30921 20.25 4 20.25H20C20.6908 20.25 21.25 19.6908 21.25 19V8.75H2.75V19ZM4 3.75C3.30921 3.75 2.75 4.30921 2.75 5V7.25H21.25V5C21.25 4.30921 20.6908 3.75 20 3.75H4Z" fill="black"/>
		</svg>
    ),
    date: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.11523 15.9844C7.61864 16.0356 8.01367 16.4601 8.01367 16.9795C8.01341 17.5315 7.56572 17.9795 7.01367 17.9795C6.49623 17.9795 6.07012 17.5859 6.01855 17.082L6.01367 16.9795C6.0126 16.4245 6.46333 15.9795 7.0127 15.9795L7.11523 15.9844Z" fill="black"/>
			<path d="M12.1152 15.9844C12.6186 16.0356 13.0137 16.4601 13.0137 16.9795C13.0134 17.5315 12.5657 17.9795 12.0137 17.9795C11.4962 17.9795 11.0701 17.5859 11.0186 17.082L11.0137 16.9795C11.0126 16.4245 11.4633 15.9795 12.0127 15.9795L12.1152 15.9844Z" fill="black"/>
			<path d="M12.1152 11.9844C12.6186 12.0356 13.0137 12.4601 13.0137 12.9795C13.0134 13.5315 12.5657 13.9795 12.0137 13.9795C11.4962 13.9795 11.0701 13.5859 11.0186 13.082L11.0137 12.9795C11.0126 12.4245 11.4633 11.9795 12.0127 11.9795L12.1152 11.9844Z" fill="black"/>
			<path d="M17.1152 11.9844C17.6186 12.0356 18.0137 12.4601 18.0137 12.9795C18.0134 13.5315 17.5657 13.9795 17.0137 13.9795C16.4962 13.9795 16.0701 13.5859 16.0186 13.082L16.0137 12.9795C16.0126 12.4245 16.4633 11.9795 17.0127 11.9795L17.1152 11.9844Z" fill="black"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M16 1.25C16.4142 1.25 16.75 1.58579 16.75 2V3.25H19C20.5192 3.25 21.75 4.48079 21.75 6V19C21.75 20.5192 20.5192 21.75 19 21.75H5C3.48079 21.75 2.25 20.5192 2.25 19V6C2.25 4.48079 3.48079 3.25 5 3.25H7.25V2C7.25 1.58579 7.58579 1.25 8 1.25C8.41421 1.25 8.75 1.58579 8.75 2V3.25H15.25V2C15.25 1.58579 15.5858 1.25 16 1.25ZM3.75 19C3.75 19.6908 4.30921 20.25 5 20.25H19C19.6908 20.25 20.25 19.6908 20.25 19V9.75H3.75V19ZM5 4.75C4.30921 4.75 3.75 5.30921 3.75 6V8.25H20.25V6C20.25 5.30921 19.6908 4.75 19 4.75H16.75V6C16.75 6.41421 16.4142 6.75 16 6.75C15.5858 6.75 15.25 6.41421 15.25 6V4.75H8.75V6C8.75 6.41421 8.41421 6.75 8 6.75C7.58579 6.75 7.25 6.41421 7.25 6V4.75H5Z" fill="black"/>
		</svg>
    ),
    upload: (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.68652 3.26367C10.1821 3.32522 10.632 3.59626 10.917 4.01465L12.3223 6.08008L12.3623 6.12695C12.4076 6.16735 12.4672 6.19043 12.5293 6.19043H19L19.2812 6.2041C20.6679 6.345 21.7499 7.51663 21.75 8.94043V18L21.7363 18.2715C21.674 18.9012 21.3957 19.493 20.9443 19.9443C20.493 20.3957 19.9012 20.674 19.2715 20.7363L19 20.75H16C15.5858 20.75 15.25 20.4142 15.25 20C15.25 19.5858 15.5858 19.25 16 19.25H19L19.124 19.2441C19.4101 19.2157 19.6787 19.0888 19.8838 18.8838C20.0888 18.6787 20.2157 18.4101 20.2441 18.124L20.25 18V8.94043C20.25 8.29326 19.7582 7.76039 19.1279 7.69629L19 7.69043H12.5293C12.0221 7.69041 11.5437 7.46991 11.2139 7.09375L11.082 6.92383L9.67676 4.85938C9.6419 4.80819 9.58998 4.77251 9.53125 4.75781L9.4707 4.75H5C4.66851 4.74991 4.35061 4.88181 4.11621 5.11621C3.88181 5.35061 3.74991 5.66851 3.75 6V18L3.75586 18.124C3.78425 18.4101 3.91117 18.6787 4.11621 18.8838C4.35061 19.1182 4.66851 19.2501 5 19.25H8C8.41421 19.25 8.75 19.5858 8.75 20C8.75 20.4142 8.41421 20.75 8 20.75H5C4.27061 20.7501 3.57142 20.4601 3.05566 19.9443C2.6043 19.493 2.32601 18.9012 2.26367 18.2715L2.25 18V6C2.24985 5.27061 2.53991 4.57142 3.05566 4.05566C3.57142 3.53991 4.27061 3.24985 5 3.25H9.4707L9.68652 3.26367Z" fill="black"/>
			<path d="M12.0254 13.251C12.0319 13.2512 12.0384 13.2516 12.0449 13.252C12.0839 13.2543 12.122 13.2595 12.1592 13.2676C12.1925 13.2748 12.2246 13.2861 12.2568 13.2979C12.2693 13.3024 12.2828 13.3044 12.2949 13.3096C12.314 13.3177 12.3311 13.33 12.3496 13.3398C12.3734 13.3525 12.3977 13.3639 12.4199 13.3789C12.4588 13.4052 12.4959 13.4353 12.5303 13.4697L14.5303 15.4697L14.582 15.5264C14.8223 15.8209 14.8049 16.2557 14.5303 16.5303C14.2557 16.8049 13.8209 16.8223 13.5264 16.582L13.4697 16.5303L12.75 15.8105V20C12.75 20.4142 12.4142 20.75 12 20.75C11.5858 20.75 11.25 20.4142 11.25 20V15.8105L10.5303 16.5303C10.2374 16.8232 9.76262 16.8232 9.46973 16.5303C9.17683 16.2374 9.17683 15.7626 9.46973 15.4697L11.4697 13.4697L11.5264 13.418C11.5366 13.4097 11.5481 13.4032 11.5586 13.3955C11.5741 13.3841 11.59 13.3734 11.6064 13.3633C11.6303 13.3485 11.6546 13.3351 11.6797 13.3232C11.6979 13.3146 11.7164 13.307 11.7354 13.2998C11.7629 13.2894 11.7909 13.2814 11.8193 13.2744C11.8394 13.2694 11.8592 13.2631 11.8799 13.2598C11.8909 13.258 11.902 13.2562 11.9131 13.2549C11.9416 13.2516 11.9706 13.25 12 13.25C12.0085 13.25 12.017 13.2507 12.0254 13.251Z" fill="black"/>
		</svg>
    )
};

export default FormIcons; 