<?php

namespace WPSynchro\Utilities\Actions;

use WPSynchro\Utilities\Actions\Action;
use WPSynchro\Migration\MigrationFactory;
use WPSynchro\Migration\Job;

/**
 * Action: Send success email
 */
class EmailOnSyncSuccess implements Action
{
    /**
     * Initialize
     */
    public function init()
    {
        static $added = null;
        if ($added !== true) {
            add_action("wpsynchro_migration_completed", function ($migration_id, $job_id) {
                (new self())->doAction(func_get_args());
            }, 10, 2);
        }
        $added = true;
    }

    /**
     * Execute action
     */
    public function doAction($params)
    {
        $migration_id = $params[0];
        $job_id = $params[1];

        // Get migration
        $migration_factory = MigrationFactory::getInstance();
        $migration = $migration_factory->retrieveMigration($migration_id);
        if (!$migration) {
            return;
        }

        // Get job
        $job = new Job();
        $job->load($migration_id, $job_id);
        if (!$job) {
            return;
        }

        // Get emails to send to, and send
        $emails = $migration->getSuccessEmailList();
        if (count($emails) > 0) {
            $subject = $this->getSubject($job->to_client_home_url, $job->from_client_home_url);
            $content = $this->getContent($job->to_client_home_url, $job->from_client_home_url);
            $headers = ['Content-Type: text/plain; charset=UTF-8'];
            foreach ($emails as $email) {
                wp_mail($email, $subject, $content, $headers);
            }
        }
    }

    /**
     * Get subject
     */
    public function getSubject($to, $from)
    {
        return sprintf(__("[Migration success] - From %s to %s", "wpsynchro"), $from, $to);
    }

    /**
     * Get email content
     */
    public function getContent($to, $from)
    {
        $current_url = get_home_url();

        return sprintf(
            __(
                "Hi, \r\n
We just want to notify you that a migration was successful.
The migration was from %s to %s  \r\n
Migration is running on %s \r\n
This is an automated email generated by WP Synchro plugin.",
                "wpsynchro"
            ),
            $from,
            $to,
            $current_url
        );
    }
}
