# WpStream - Live Streaming for WordPress

**WpStream** is a WordPress plugin designed for live streaming, video on demand (VOD), and pay-per-view monetization. It seamlessly integrates with **WooCommerce** to help creators, businesses, and influencers monetize video content.

## 🚀 Features

- **Live Streaming**: Stream directly from your browser or using RTMP apps like OBS, StreamYard, Zoom, and more.
- **Video on Demand (VOD)**: Record live streams or upload video files for on-demand viewing.
- **Monetization**: Sell live streams or VODs with WooCommerce (pay-per-view, subscriptions).
- **Frontend Streaming**: Allow users to go live on your site (similar to Twitch).
- **Custom Branding**: Add logos, protect streams, and control access.
- **WordPress Page Builder Support**: Works with Elementor, WPBakery, and more.

## 🎥 Getting Started

1. **Install & Activate**: Search for **WpStream** in the WordPress plugin directory.
2. **Create an Account**: Sign up at [WpStream.net](https://wpstream.net/).
3. **Set Up Streaming**:
   - Create a **Live Channel** or **VOD**.
   - Click **"Broadcast to Channel"** and start streaming.
4. **Monetization (Optional)**:
   - Install **WooCommerce** to sell pay-per-view or subscription-based content.

## 📌 Shortcodes & Widgets

- **Embed Live or VOD Players**: `[wpstream_player]`
- **List Live Channels**: `[wpstream_channel_list]`
- **Frontend Streaming (Twitch-style)**: `[wpstream_start_streaming]`

## 🌐 Useful Links

- 📖 **[Documentation](https://docs.wpstream.net/docs-category/getting-started/)**
- 📺 **[YouTube Tutorials](https://www.youtube.com/channel/UCIjItiJc4Z7aJApj3W6ArJA)**
- 💡 **[Live Streaming Guide](https://wpstream.net/live-streaming/)**

### 📢 Follow Us

[YouTube](https://www.youtube.com/channel/UCIjItiJc4Z7aJApj3W6ArJA) |  
[Facebook](http://facebook.com/wpstreamsoftware) |  
[Twitter](http://twitter.com/streaming4wp) |  
[LinkedIn](http://linkedin.com/company/wpstream)

---

🔗 **[WpStream.net](https://wpstream.net/)** – The ultimate live streaming solution for WordPress.
