<h1>WPSSO Core - Complete Schema Markup and Meta Tags</h1>

<table>
<tr><th align="right" valign="top" nowrap>Plugin Name</th><td>WPSSO Core</td></tr>
<tr><th align="right" valign="top" nowrap>Summary</th><td>Present your content at its best for social sites and search results, no matter how URLs are shared, reshared, messaged, posted, embedded, or crawled.</td></tr>
<tr><th align="right" valign="top" nowrap>Stable Version</th><td>21.9.0</td></tr>
<tr><th align="right" valign="top" nowrap>Requires PHP</th><td>7.4.33 or newer</td></tr>
<tr><th align="right" valign="top" nowrap>Requires WordPress</th><td>5.9 or newer</td></tr>
<tr><th align="right" valign="top" nowrap>Tested Up To WordPress</th><td>6.9</td></tr>
<tr><th align="right" valign="top" nowrap>Tested Up To WooCommerce</th><td>10.3.6</td></tr>
<tr><th align="right" valign="top" nowrap>Contributors</th><td>jsmoriss</td></tr>
<tr><th align="right" valign="top" nowrap>License</th><td><a href="https://www.gnu.org/licenses/gpl.txt">GPLv3</a></td></tr>
<tr><th align="right" valign="top" nowrap>Tags / Keywords</th><td>schema, woocommerce, search results, optimize, meta tags</td></tr>
</table>

<h2>Description</h2>

<h3 class="top">Complete Schema Markup and Meta Tags for WordPress</h3>

<p>Present your content at its best for social sites and search results, no matter how URLs are shared, reshared, messaged, posted, embedded, or crawled.</p>

<!-- about -->

<p><strong>The most comprehensive and accurate Schema markup plugin for WooCommerce products.</strong></p>

<p>Supports over 500 different Schema types and sub-types (including Schema Event, Product Group, and the Service type for WooCommerce products).</p>

<p><strong>Provides complete Schema markup and meta tags for:</strong></p>

<ul>
    <li>Facebook / Open Graph</li>
    <li>Google Knowledge Graph</li>
    <li>Google Merchant Feed XML</li>
    <li>Google Rich Results / Rich Snippets</li>
    <li>Image and Video SEO</li>
    <li>Instagram Catalog Feed XMLs</li>
    <li>Meta (Facebook and Instagram) Catalog Feed XMLs</li>
    <li>Mobile Web Browsers</li>
    <li>oEmbed for LinkedIn, Discord, and Drupal</li>
    <li>Pinterest Rich Pins</li>
    <li>Schema JSON-LD Markup</li>
    <li>Slack</li>
    <li>WhatsApp and Messaging Apps</li>
    <li>WordPress REST API</li>
    <li>WordPress Sitemaps XML</li>
    <li>X (Twitter) Cards</li>
</ul>

<!-- /about -->

<p><strong>Fixes all Google Rich Results and Google Merchant errors, including:</strong></p>

<ul>
<li><em>A value for the headline field is required</em></li>
<li><em>A value for the image field is required</em></li>
<li><em>A value for the logo field is required</em></li>
<li><em>A value for the publisher field is required</em></li>
<li><em>Either "price" or "priceSpecification" should be specified (in "offers")</em></li>
<li><em>Invalid value in field "priceSpecification"</em></li>
<li><em>The aggregateRating field is recommended</em></li>
<li><em>The brand field is recommended</em></li>
<li><em>The headline field is recommended</em></li>
<li><em>The image field is recommended</em></li>
<li><em>The review field is recommended</em></li>
<li><em>Missing field "address"</em></li>
<li><em>Missing field "aggregateRating"</em></li>
<li><em>Missing field "brand"</em></li>
<li><em>Missing field "businessDays"</em></li>
<li><em>Missing field "cutoffTime"</em></li>
<li><em>Missing field "deliveryTime"</em></li>
<li><em>Missing field "hasMerchantReturnPolicy" (in "offers")</em></li>
<li><em>Missing field "image"</em></li>
<li><em>Missing field "priceRange"</em></li>
<li><em>Missing field "review"</em></li>
<li><em>Missing field "shippingDetails" (in "offers")</em></li>
<li><em>Missing field "telephone"</em></li>
<li><em>No global identifier provided (e.g. gtin mpn isbn)</em></li>
<li><em>Not a known valid target type for the itemReviewed property</em></li>
<li><em>Price Mismatched value (page crawl): (price [price])</em></li>
</ul>

<p><strong>Optimized image sizes for social sites and search engines:</strong></p>

<ul>
<li>Commerce Manager Catalog Feed XML (Facebook and Instagram)</li>
<li>Google Merchant Feed XML</li>
<li>Open Graph (Facebook and oEmbed)</li>
<li>Pinterest Pin It</li>
<li>Schema 1:1 (Google Rich Results)</li>
<li>Schema 4:3 (Google Rich Results)</li>
<li>Schema 16:9 (Google Rich Results)</li>
<li>Schema Thumbnail</li>
<li>Video Preview Image</li>
<li>X (Twitter) Summary Card</li>
<li>X (Twitter) Summary Card Large Image</li>
</ul>

<p><strong>Reads additional information from active plugins, including:</strong></p>

<ul>
<li><a href="https://wordpress.org/plugins/co-authors-plus/">Co-Authors Plus</a></li>
<li><a href="https://wordpress.org/plugins/elementor/">Elementor Website Builder</a></li>
<li>Gravity Forms</li>
<li>Gravity View</li>
<li><a href="https://wordpress.org/plugins/jetpack/">Jetpack</a></li>
<li><a href="https://wordpress.org/plugins/jetpack-boost/">Jetpack Boost</a></li>
<li><a href="https://wordpress.org/plugins/judgeme-product-reviews-woocommerce/">Judge.me Product Reviews for WooCommerce</a></li>
<li><a href="https://wordpress.org/plugins/wp-retina-2x/">Perfect Images</a></li>
<li><a href="https://wordpress.org/plugins/perfect-woocommerce-brands/">Perfect Brands for WooCommerce</a></li>
<li><a href="https://wordpress.org/plugins/polylang/">Polylang</a></li>
<li>Product GTIN (EAN, UPC, ISBN) for WooCommerce</li>
<li><a href="https://wordpress.org/plugins/publishpress-authors">PublishPress Authors</a></li>
<li>qTranslate-XT</li>
<li><a href="https://wordpress.org/plugins/rate-my-post/">Rate my Post</a></li>
<li><a href="https://wordpress.org/plugins/simple-job-board/">Simple Job Board</a></li>
<li><a href="https://wordpress.org/plugins/the-events-calendar/">The Events Calendar</a></li>
<li><a href="https://wordpress.org/plugins/ultimate-member/">Ultimate Member</a></li>
<li><a href="https://wordpress.org/plugins/woocommerce/">WooCommerce</a></li>
<li>WooCommerce Brands</li>
<li>WooCommerce Currency Switcher</li>
<li>WooCommerce UPC, EAN, and ISBN</li>
<li><a href="https://wordpress.org/plugins/wp-job-manager/">WP Job Manager</a></li>
<li><a href="https://wordpress.org/plugins/wp-postratings/">WP-PostRatings</a></li>
<li>WP Product Review</li>
<li><a href="https://wordpress.org/plugins/wp-recipe-maker/">WP Recipe Maker</a></li>
<li>WPML</li>
<li><a href="https://wordpress.org/plugins/yith-woocommerce-brands-add-on/">YITH WooCommerce Brands Add-on</a></li>
<li><a href="https://wordpress.org/plugins/yotpo-social-reviews-for-woocommerce/">Yotpo Social Reviews for WooCommerce</a></li>
</ul>

<p><strong>Supports additional WooCommerce product attributes:</strong></p>

<ul>
<li>Product Adult Type</li>
<li>Product Age Group</li>
<li>Product Availability</li>
<li>Product Brand</li>
<li>Product Google Category ID</li>
<li>Product Color</li>
<li>Product Condition</li>
<li>Product Currency</li>
<li>Product Energy Rating</li>
<li>Product Fluid Volume</li>
<li>Product GTIN-14</li>
<li>Product GTIN-13 (EAN)</li>
<li>Product GTIN-12 (UPC)</li>
<li>Product GTIN-8</li>
<li>Product GTIN</li>
<li>Product Net Height</li>
<li>Product ISBN</li>
<li>Product Net Len. / Depth</li>
<li>Product Material</li>
<li>Product MPN</li>
<li>Product Min Advert Price</li>
<li>Product Pattern</li>
<li>Product Price</li>
<li>Product Price Type</li>
<li>Product SKU</li>
<li>Product Shipping Height</li>
<li>Product Shipping Length</li>
<li>Product Shipping Weight</li>
<li>Product Shipping Width</li>
<li>Product Size</li>
<li>Product Size Group</li>
<li>Product Size System</li>
<li>Product Target Gender</li>
<li>Product Net Weight</li>
<li>Product Net Width</li>
</ul>

<p><strong>Optionally improves the structured data markup of other SEO plugins:</strong></p>

<p>WPSSO Core and its add-ons can also run in combination with other SEO plugins to improve their performance and structured data markup.</p>

<ul>
<li>All in One SEO Pack</li>
<li>Rank Math SEO</li>
<li>SEOPress</li>
<li>The SEO Framework</li>
<li>WP Meta SEO</li>
<li>Yoast SEO</li>
</ul>

<p><strong>Premium edition can retrieve data from service APIs automatically, including:</strong></p>

<ul>
<li>Bitly Short URL</li>
<li>DLMY.App Short URL</li>
<li>Facebook Video Data</li>
<li>Gravatar Image Data</li>
<li>Judge.me Review Data</li>
<li>Ow.ly Short URL</li>
<li>Shopper Approved Review Data</li>
<li>Slideshare Presentation Data</li>
<li>Soundcloud Track Data</li>
<li>Stamped.io Review Data</li>
<li>TinyURL Short URL</li>
<li>Vimeo Video Data</li>
<li>Wistia Video Data</li>
<li>WP Media Library Video Block Data</li>
<li>WP Media Library Video Shortcode Data</li>
<li>Your Own URL Shortener (YOURLS) Short URL</li>
<li>YouTube Video and Playlist Data</li>
</ul>

<h2>Installation</h2>

<h3 class="top">Install and Uninstall</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/install-the-plugin/">Install the WPSSO Core Plugin</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/uninstall-the-plugin/">Uninstall the WPSSO Core Plugin</a></li>
</ul>

<h3>Plugin Setup</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/setup-guide/">Setup Guide</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/developer-special-buy-one-get-one-free/">Developer Special: Buy one, Get one Free</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/better-schema-for-woocommerce/">Better Schema Markup for WooCommerce</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/installation/troubleshooting-guide/">Troubleshooting Guide</a></li>
</ul>

<h2>Frequently Asked Questions</h2>

<h3 class="top">Frequently Asked Questions</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/does-linkedin-read-the-open-graph-meta-tags/">Does LinkedIn read Facebook / Open Graph meta tags?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-a-err_too_many_redirects-error/">How can I fix a ERR_TOO_MANY_REDIRECTS error?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-a-generic-http-500-error/">How can I fix a generic HTTP 500 error?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-a-php-fatal-out-of-memory-error/">How can I fix a PHP fatal "out of memory" error?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-fix-an-http-error-when-uploading-images/">How can I fix an HTTP error when uploading images?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-have-smaller-dimensions-for-the-default-image/">How can I have smaller dimensions for the default image?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-can-i-see-what-the-facebook-crawler-sees/">How can I see what the Facebook crawler sees?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-create-a-schema-faqpage/">How do I create a Schema FAQPage?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-enable-wordpress-wp_debug/">How do I enable WordPress WP_DEBUG?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-do-i-remove-duplicate-meta-tags/">How do I remove duplicate meta tags?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-does-wpsso-find-detect-select-images/">How does WPSSO Core find and select images?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/how-does-wpsso-find-detect-select-videos/">How does WPSSO Core find and select videos?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/w3c-says-there-is-no-attribute-property/">W3C says "there is no attribute 'property'"</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-are-some-html-elements-missing-misaligned-different/">Why are some HTML elements missing or misaligned?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-does-facebook-show-the-wrong-image-text/">Why does Facebook show the wrong image / text?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-does-google-structured-data-testing-tool-show-errors/">Why does the Schema Markup Validator show errors?</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/faqs/why-shouldnt-i-upload-small-images-to-the-media-library/">Why shouldn't I upload small images to the media library?</a></li>
</ul>

<h3>Notes and Documentation</h3>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/">Developer Resources</a>

<ul>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/the-mod-variable/">$mod Variable</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/actions/">Actions</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/constants/">Constants</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/developer/filters/">Filters</a></li>
</ul></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/inline-variables/">Inline Variables</a></li>
<li><a href="https://wpsso.com/docs/plugins/wpsso/notes/multisite-network-support/">Multisite / Network Support</a></li>
</ul>

