<?php

/**
 * Se dispara durante la desactivación del plugin.
 *
 * Esta clase define todo el código necesario para ejecutarse durante la desactivación del plugin.
 *
 * @package    Wporlogin
 * @subpackage Wporlogin/includes
 * @author     Oregoom <tu-email@oregoom.com>
 */
class Wporlogin_Deactivator {

    /**
     * Ejecuta las tareas de limpieza necesarias al desactivar el plugin.
     *
     * Nota: No borramos las opciones de la base de datos aquí. 
     * Eso se debe hacer en 'uninstall.php' solo si el usuario borra el plugin definitivamente.
     * Al desactivar, preservamos la configuración para cuando el usuario regrese.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Aquí puedes agregar lógica si en el futuro añades tareas programadas (Cron Jobs).
        // Por ahora, no es necesario realizar ninguna acción crítica, 
        // ya que al desactivar el plugin, los hooks de seguridad dejan de ejecutarse automáticamente.
    }

}