<?php
/**
 * Vista para la subpágina de configuración de Redirecciones.
 */
?>

<div class="wrap"> 
    
    <div style="width: 95%; margin-left: auto; margin-right: auto; background-color: #ffffff; padding-top: 5px; border-bottom-left-radius: 10px; border-bottom-right-radius: 10px; margin-top: -10px; box-shadow: 0 1px 2px rgba(0,0,0,0.16), 0 1px 2px rgba(0,0,0,0.23);">
        <img src="<?php echo WPORLOGIN_URL . 'assets/img/logo-wporlogin.png'; ?>" style="margin-left: 20px; height: 48px;">
    </div>

    <div style="width: 95%; margin-left: auto; margin-right: auto; position: relative;">
    
        <h1 style="text-align: center; font-size: 34px; padding-top: 30px; font-weight: bold; font-family: 'Roboto', sans-serif;"><strong><?php _e('Session Redirection Settings', 'wporlogin'); ?></strong></h1>  
    
        <p style="margin-bottom: 20px; text-align: center; font-family: 'Roboto', sans-serif; font-size: 16px; margin-top: 5px; margin-bottom: 40px;"><?php _e('Set up automatic redirects for users when they log in or log out of WordPress.', 'wporlogin'); ?></p>
 
    
        <?php settings_errors(); ?>

        <form method="post" action="<?php echo esc_url(admin_url('options.php') ); ?>">
        
            <?php 
            wp_nonce_field(basename(__FILE__), 'redirects_wporlogin_form_nonce'); 
            ?>
            
            <?php settings_fields( 'redirects_wporlogin_custom_admin_settings_group' ); ?>
            <?php do_settings_sections( 'redirects_wporlogin_custom_admin_settings_group' ); ?>
            
            <div style="padding-top: 15px; padding-bottom: 50px; background-color: #ffffff; border-radius: 10px; box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);">
                        
                <div class="wporlogin-container-design" style="width: 90%; margin-left: auto; margin-right: auto;">

                    <div style="border-bottom: 1px solid #e5e7e8; padding-bottom: 15px; padding-top: 10px;">
                        <span><?php _e('Need help? ', 'wporlogin'); ?><a href="#" target="_blank"><?php _e('Watch the video', 'wporlogin'); ?></a></span>
                    </div>
                                        
                    <h2 class="title"><?php _e('Redirect After Login', 'wporlogin'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row"><?php _e('Enable redirection after login', 'wporlogin'); ?></th>
                                <td>
                                    <fieldset>
                                        <label for="wporlogin_enable_login_redirect">
                                            <input type="checkbox" id="wporlogin_enable_login_redirect" name="wporlogin_enable_login_redirect" value="1" <?php checked(get_option('wporlogin_enable_login_redirect'), '1'); ?> />
                                            <?php _e('Yes, enable redirection', 'wporlogin'); ?>
                                        </label>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('Page to redirect users after login (URL)', 'wporlogin'); ?></th>
                                <td>
                                    <input type="text" name="wporlogin_login_redirect" value="<?php echo esc_attr(get_option('wporlogin_login_redirect')); ?>" class="regular-text" />
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('Apply redirection to administrators as well', 'wporlogin'); ?></th>
                                <td>
                                    <fieldset>
                                        <label for="wporlogin_enable_admin_redirect">
                                            <input type="checkbox" id="wporlogin_enable_admin_redirect" name="wporlogin_enable_admin_redirect" value="1" <?php checked(get_option('wporlogin_enable_admin_redirect'), '1'); ?> />
                                            <?php _e('Yes, redirect administrators too', 'wporlogin'); ?>
                                        </label>
                                    </fieldset>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <h2 class="title"><?php _e('Redirect on Logout', 'wporlogin'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row"><?php _e('Enable redirection after logout', 'wporlogin'); ?></th>
                                <td>
                                    <fieldset>
                                        <label for="wporlogin_enable_logout_redirect">
                                            <input type="checkbox" id="wporlogin_enable_logout_redirect" name="wporlogin_enable_logout_redirect" value="1" <?php checked(get_option('wporlogin_enable_logout_redirect'), '1'); ?> />
                                            <?php _e('Yes, enable redirection', 'wporlogin'); ?>
                                        </label>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('Page to redirect users after logout (URL)', 'wporlogin'); ?></th>
                                <td>
                                    <input type="text" name="wporlogin_logout_redirect" value="<?php echo esc_attr(get_option('wporlogin_logout_redirect')); ?>" class="regular-text" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <?php
                // CORREGIDO: Ruta segura y chequeo de existencia
                if ( file_exists( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ) ) {
                    include( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ); 
                }
                ?>
                </div>
            
            <?php submit_button(); ?>
            
        </form>
        
    </div>

</div>