<?php
/**
 * Vista para la subpágina de Limit Login Attempts.
 */
?>

<div class="wrap"> 
    
    <div style="width: 95%; margin-left: auto; margin-right: auto; background-color: #ffffff; padding-top: 5px; border-bottom-left-radius: 10px; border-bottom-right-radius: 10px; margin-top: -10px; box-shadow: 0 1px 2px rgba(0,0,0,0.16), 0 1px 2px rgba(0,0,0,0.23);">
        <img src="<?php echo WPORLOGIN_URL . 'assets/img/logo-wporlogin.png'; ?>" style="margin-left: 20px; height: 48px;">
    </div>

    <div style="width: 95%; margin-left: auto; margin-right: auto; position: relative;">
    
        <h1 style="text-align: center; font-size: 34px; padding-top: 30px; font-weight: bold; font-family: 'Roboto', sans-serif;"><strong><?php _e('Limit Login Attempts', 'wporlogin'); ?></strong></h1>  
    
        <p style="margin-bottom: 20px; text-align: center; font-family: 'Roboto', sans-serif; font-size: 16px; margin-top: 5px; margin-bottom: 40px;"><?php _e('Protect your site from brute force attacks by limiting the number of login attempts.', 'wporlogin'); ?></p>
 
        <?php settings_errors(); ?>

        <form method="post" action="<?php echo esc_url(admin_url('options.php') ); ?>">
        
            <?php 
                settings_fields( 'wporlogin_limit_settings_group' ); 
                do_settings_sections( 'wporlogin_limit_settings_group' );
            ?>
            
            <div style="padding-top: 15px; padding-bottom: 50px; background-color: #ffffff; border-radius: 10px; box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23); margin-bottom: 30px;">
                        
                <div class="wporlogin-container-design" style="width: 90%; margin-left: auto; margin-right: auto;">

                    <div style="border-bottom: 1px solid #e5e7e8; padding-bottom: 15px; padding-top: 10px;">
                        <span><?php _e('Need help? ', 'wporlogin'); ?><a href="#" target="_blank"><?php _e('Watch the video', 'wporlogin'); ?></a></span>
                    </div>
                                        
                    <h2 class="title"><?php _e('Security Settings', 'wporlogin'); ?></h2>
                    <table class="form-table">
                        <tbody>
                            <tr>
                                <th scope="row"><?php _e('Enable Limit Login', 'wporlogin'); ?></th>
                                <td>
                                    <fieldset>
                                        <label for="wporlogin_limit_enable">
                                            <input type="checkbox" id="wporlogin_limit_enable" name="wporlogin_limit_enable" value="1" <?php checked(get_option('wporlogin_limit_enable'), '1'); ?> />
                                            <?php _e('Yes, enable protection', 'wporlogin'); ?>
                                        </label>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('Max Retries Allowed', 'wporlogin'); ?></th>
                                <td>
                                    <input type="number" name="wporlogin_limit_max_retries" value="<?php echo esc_attr(get_option('wporlogin_limit_max_retries', 3)); ?>" class="small-text" min="1" max="50" />
                                    <p class="description"><?php _e('Number of allowed attempts before lockout.', 'wporlogin'); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('Lockout Time (Minutes)', 'wporlogin'); ?></th>
                                <td>
                                    <input type="number" name="wporlogin_limit_lock_time" value="<?php echo esc_attr(get_option('wporlogin_limit_lock_time', 20)); ?>" class="small-text" min="1" />
                                    <p class="description"><?php _e('How long the IP remains blocked.', 'wporlogin'); ?></p>
                                </td>
                            </tr>
                             <tr>
                                <th scope="row"><?php _e('Custom Error Message', 'wporlogin'); ?></th>
                                <td>
                                    <textarea name="wporlogin_limit_message" rows="3" class="large-text code"><?php echo esc_textarea(get_option('wporlogin_limit_message', __('You have exceeded the maximum number of login attempts. Please try again later.', 'wporlogin'))); ?></textarea>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>

                <?php
                 if ( file_exists( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ) ) {
                     include( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ); 
                 }
                 ?>

            </div>

            <div style="padding-top: 15px; padding-bottom: 50px; background-color: #ffffff; border-radius: 10px; box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);">
                 <div class="wporlogin-container-design" style="width: 90%; margin-left: auto; margin-right: auto;">
                    
                    <h2 class="title" style="color: #d63638;"><?php _e('Blocked IPs Report', 'wporlogin'); ?></h2>
                    <p><?php _e('List of IP addresses currently blocked by the system.', 'wporlogin'); ?></p>

                    <table class="wp-list-table widefat fixed striped">
                        <thead>
                            <tr>
                                <th><?php _e('IP Address (Geo)', 'wporlogin'); ?></th>
                                <th><?php _e('Blocked At', 'wporlogin'); ?></th>
                                <th><?php _e('Time Remaining', 'wporlogin'); ?></th>
                                <th><?php _e('Status', 'wporlogin'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            if (!class_exists('Wporlogin_Public_Limit_Login')) {
                                require_once WPORLOGIN_PATH . 'public/class-wporlogin-public-limit-login.php';
                            }
                            
                            $blocked_ips = Wporlogin_Public_Limit_Login::get_blocked_ips_report();
                            
                            if ( ! empty( $blocked_ips ) ) {
                                foreach ( $blocked_ips as $record ) {
                                    // Truco Experto: Enlace a servicio GeoIP externo
                                    // Esto carga instantáneo y da Mapa + País + Ciudad + ISP
                                    $geo_url = 'https://whatismyipaddress.com/ip/' . esc_attr($record['ip']);
                                    
                                    echo '<tr>';
                                    
                                    // Columna 1: IP con enlace
                                    echo '<td>';
                                    echo '<a href="' . esc_url($geo_url) . '" target="_blank" title="' . __('Check Country/Location', 'wporlogin') . '" style="font-weight:bold; text-decoration:none;">';
                                    echo esc_html( $record['ip'] ) . ' <span class="dashicons dashicons-location" style="font-size:14px; color:#555;"></span>';
                                    echo '</a>';
                                    echo '</td>';

                                    // Columna 2: Cuándo fue bloqueado
                                    echo '<td>' . esc_html( $record['start_date'] ) . '</td>';

                                    // Columna 3: Tiempo restante
                                    echo '<td>' . esc_html( $record['time_left'] ) . '</td>';

                                    // Columna 4: Estado
                                    echo '<td><span class="dashicons dashicons-lock" style="color:#d63638"></span> <strong>' . __('Blocked', 'wporlogin') . '</strong></td>';
                                    echo '</tr>';
                                }
                            } else {
                                echo '<tr><td colspan="4" style="text-align:center;">' . __('No IPs currently blocked.', 'wporlogin') . '</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                 </div>                 
                 
            </div>
            
            <?php submit_button(); ?>
            
        </form>
        
    </div>

</div>