<?php
/**
 * Provee la vista de administración para el plugin.
 *
 * Este archivo se utiliza para marcar los aspectos de administración del plugin.
 */
?>

<style type="text/css">
    .wporlogin_container_select_option{
        width: 90% !important; 
        margin-left: auto !important; 
        margin-right: auto !important; 
        text-align: center !important;
    }   
    .wporlogin_container_select_option label {  
        font-family: 'Roboto', sans-serif !important;
        cursor: pointer !important;
        margin: 0 10px 0 10px !important;
    }
</style>

<div class="wrap"> 
    
    <div style="width: 95%; margin-left: auto; margin-right: auto; background-color: #ffffff; padding-top: 5px; border-bottom-left-radius: 10px; border-bottom-right-radius: 10px; margin-top: -10px; box-shadow: 0 1px 2px rgba(0,0,0,0.16), 0 1px 2px rgba(0,0,0,0.23);">
        <img src="<?php echo WPORLOGIN_URL . 'assets/img/logo-wporlogin.png'; ?>" style="margin-left: 20px; height: 48px;">
    </div>
    
    <div style="width: 95%; margin-left: auto; margin-right: auto; position: relative;">       
        
        <h1 style="text-align: center; font-size: 34px; padding-top: 30px; font-weight: bold; font-family: 'Roboto', sans-serif;"><strong><?php _e('Appearance', 'wporlogin'); ?></strong></h1>  
        
        <p style="margin-bottom: 20px; text-align: center; font-family: 'Roboto', sans-serif; font-size: 16px; margin-top: 5px; margin-bottom: 40px;"><?php _e('<strong>WPOrLogin</strong> allows you to customize the appearance of the WordPress login page.', 'wporlogin'); ?></p>
    
        <?php settings_errors(); ?>
                
        <form method="post" action="<?php echo esc_url(admin_url('options.php') ); ?>">
            
            <?php 
            wp_nonce_field(basename(__FILE__), 'wporlogin_form_nonce'); 
            ?>
            
            <?php settings_fields( 'wporlogin_custom_admin_settings_group' ); ?>
            <?php do_settings_sections( 'wporlogin_custom_admin_settings_group' ); ?>
            
            <div style="padding-top: 15px; padding-bottom: 50px; background-color: #ffffff; border-radius: 10px; box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23);">
                
                <div style="width: 90%; margin-left: auto; margin-right: auto; text-align: center;">
                    <h2 style="font-size: 20px; font-family: 'Roboto', sans-serif; color: #0073AA;"><?php _e('Select an option', 'wporlogin'); ?></h2>
                </div>     

                <div class="wporlogin_container_select_option" style="display: flex; justify-content: center;">
                    
                    <div>
                        <div style="margin-bottom: 5px;">
                            <label for="wporlogin_design_basic">
                                <input <?php checked( 'wporlogin_design_basic', get_option( 'wporlogin_design' ) ); ?> type="radio" id="wporlogin_design_basic" class="wporlogin-option-input wporlogin-radio" name="wporlogin_design" value="wporlogin_design_basic">
                                <?php _e('Basic', 'wporlogin'); ?>
                            </label>
                        </div>                        
                        <div id="wporlogin-container-basic-triangulo" style="width: 0; height: 0; border-right: 15px solid transparent; border-bottom: 15px solid #AEB6BF; border-left: 15px solid transparent; margin-left: auto; margin-right: auto; <?php if(get_option('wporlogin_design') != 'wporlogin_design_basic'){ echo 'display: none;';} ?>"></div>
                    </div>            
                        
                    <div>
                        <div style="margin-bottom: 5px;">
                            <label for="wporlogin_design_standard">
                                <input <?php checked( 'wporlogin_design_standard', get_option( 'wporlogin_design' ) ); ?> type="radio" id="wporlogin_design_standard" class="wporlogin-option-input wporlogin-radio" name="wporlogin_design" value="wporlogin_design_standard">
                                <?php _e('Standard', 'wporlogin'); ?>
                            </label>
                        </div>
                        <div id="wporlogin-container-standard-triangulo" style="width: 0; height: 0; border-right: 15px solid transparent; border-bottom: 15px solid #AEB6BF; border-left: 15px solid transparent; margin-left: auto; margin-right: auto; <?php if(get_option('wporlogin_design') != 'wporlogin_design_standard'){ echo 'display: none;';} ?>"></div>
                    </div>
                                

                    <div>
                        <div style="margin-bottom: 5px;">
                            <label for="wporlogin_design_premium">
                                <input <?php checked( 'wporlogin_design_premium', get_option( 'wporlogin_design' ) ); ?> type="radio" id="wporlogin_design_premium" class="wporlogin-option-input wporlogin-radio" name="wporlogin_design" value="wporlogin_design_premium">
                                <?php _e('Premium', 'wporlogin'); ?>
                            </label>
                        </div>
                        <div id="wporlogin-container-premium-triangulo" style="width: 0; height: 0; border-right: 15px solid transparent; border-bottom: 15px solid #AEB6BF; border-left: 15px solid transparent; margin-left: auto; margin-right: auto; <?php if(get_option('wporlogin_design') != 'wporlogin_design_premium'){ echo 'display: none;';} ?>"></div>
                    </div>                    

                </div>
                
                
                <div style="background-color: #AEB6BF; padding-top: 50px; padding-bottom: 50px; <?php if(get_option('wporlogin_design') != 'wporlogin_design_basic'){ echo 'display: none'; } ?>" class="wporlogin-container-design" id="wporlogin-container-basic">
                    
                    <div style="text-align: center;">
                         <img src="<?php echo WPORLOGIN_URL . 'assets/img/wporlogin-design-basic.jpg'; ?>" style="box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23); max-width: 100%; height: auto;">
                    </div>
                    
                </div><div style="background-color: #AEB6BF; padding-top: 50px; padding-bottom: 50px; <?php if(get_option('wporlogin_design') != 'wporlogin_design_standard'){ echo 'display: none'; } ?>"  class="wporlogin-container-design" id="wporlogin-container-standard">
                    
                    <div style="text-align: center;">
                         <img src="<?php echo WPORLOGIN_URL . 'assets/img/wporlogin-design-standard.jpg'; ?>" style="box-shadow: 0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23); max-width: 100%; height: auto;">
                    </div>
                    
                </div><div style="background-color: #AEB6BF; padding-top: 50px; padding-bottom: 50px; <?php if(get_option('wporlogin_design') != 'wporlogin_design_premium'){ echo 'display: none'; } ?>"  class="wporlogin-container-design" id="wporlogin-container-premium">
                    
                    <div style="display: flex; flex-wrap: wrap; justify-content: space-around;">

                        <div style="position: relative; margin-bottom: 15px;">
                            <input <?php checked( 'wporlogin_design_img_premium_one', get_option( 'wporlogin-design-img-premium' ) ); ?> value="wporlogin_design_img_premium_one" name="wporlogin-design-img-premium" id="wporlogin-design-img-premium-one" type="radio" style="position: absolute; margin: 10px 0 0 10px;">
                             <img onclick="wporloginimgclick('wporlogin-design-img-premium-one')" id="wporlogin-design-img-premium-one" src="<?php echo WPORLOGIN_URL . 'assets/img/wporlogin-design-premium-one.jpg'; ?>" style="margin-bottom: 10px; max-width: 100%; height: auto; cursor: pointer;">
                        </div>

                        <div style="position: relative; margin-bottom: 15px;">
                            <input <?php checked( 'wporlogin_design_img_premium_two', get_option( 'wporlogin-design-img-premium' ) ); ?> value="wporlogin_design_img_premium_two" name="wporlogin-design-img-premium" id="wporlogin-design-img-premium-two" type="radio" style="position: absolute; margin: 10px 0 0 10px;">
                             <img onclick="wporloginimgclick('wporlogin-design-img-premium-two')" id="wporlogin-design-img-premium-two" src="<?php echo WPORLOGIN_URL . 'assets/img/wporlogin-design-premium-two.jpg'; ?>" style="margin-bottom: 10px; max-width: 100%; height: auto; cursor: pointer;">
                        </div>

                        <div style="position: relative; margin-bottom: 15px;">
                            <input <?php checked( 'wporlogin_design_img_premium_three', get_option( 'wporlogin-design-img-premium' ) ); ?> value="wporlogin_design_img_premium_three" name="wporlogin-design-img-premium" id="wporlogin-design-img-premium-three" type="radio" style="position: absolute; margin: 10px 0 0 10px;">
                             <img onclick="wporloginimgclick('wporlogin-design-img-premium-three')" id="wporlogin-design-img-premium-three" src="<?php echo WPORLOGIN_URL . 'assets/img/wporlogin-design-premium-three.jpg'; ?>" style="margin-bottom: 10px; max-width: 100%; height: auto; cursor: pointer;">
                        </div>

                        <?php if ($wporlogin_is_premium): 

                            do_action('wporlogin_pro_admin_design_img_premium'); ?>                            

                        <?php else: ?>    

                        <?php endif; ?>

                        
                        <script>
                            function wporloginimgclick(valor){
                                document.getElementById(valor).checked=true;
                            }
                        </script>

                    </div>
                    
                </div><div class="wporlogin-container-design-premium" style="padding-top: 40px; width: 90%; margin-left: auto; margin-right: auto;">
                    
                    <table class="form-table" role="presentation">
                
                        <thead>

                        <tr>
                            <th scope="row">
                                <label style="font-size: 1.5em;"><strong><?php _e('Brand Color', 'wporlogin'); ?></strong></label>
                            </th>
                            <td><hr></td>
                        </tr>

                        <tr>
                            <th scope="row">
                                <label for="wporlogin_color_principal_marca"><?php _e('Primary Color', 'wporlogin'); ?></label>
                            </th>
                            <td>
                            <input type="text" id="wporlogin_color_principal_marca" name="wporlogin_color_principal_marca" 
                                value="<?php echo esc_attr(get_option('wporlogin_color_principal_marca', '#1a73e8')); ?>" 
                                class="wporlogin-color-picker" data-default-color="#1a73e8" />
                                <p class="description" id="tagline-description"><?php _e('Define the primary color of your brand. It will be used in buttons and highlighted elements.', 'wporlogin'); ?></p>
                            </td>
                        </tr>

                        </thead>

                        <tbody id="wporlogin-container-standard-premium" style="<?php if(get_option('wporlogin_design') != 'wporlogin_design_standard' && get_option('wporlogin_design') != 'wporlogin_design_premium'){ echo 'display: none;'; } ?> ">
                
                        <tr>
                            <th scope="row">
                                <label style="font-size: 1.5em;"><strong><?php _e('Logo', 'wporlogin'); ?></strong></label>
                            </th>
                            <td><hr></td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_url_logotipo_text"><?php _e('Logo', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <?php
                                if(esc_url(get_option('wporlogin_url_logotipo'))){
                                ?>
                                <img id="wporlogin_url_logotipo_img" src="<?php echo esc_url(get_option('wporlogin_url_logotipo')); ?>" style="<?php if(get_option('wporlogin_design') == 'wporlogin_design_premium' ) { echo 'background-color: #D6DBDF;'; } else { echo 'background-color: #ffffff;'; }  ?> margin-bottom: 10px; width: 220px; padding: 10px;  border: 2px dashed rgba(0,0,0,.1);"><br>
                                <?php
                                }
                                ?>
                                <input aria-label="Close" id="wporlogin_url_logotipo_text" type="text" name="wporlogin_url_logotipo" class="regular-text" style="margin-bottom: 10px;" value="<?php echo esc_url(get_option('wporlogin_url_logotipo')); ?>"/><br>
                                <input id="wporlogin_url_logotipo_button" type="button" class="button" value="<?php _e('Upload logo', 'wporlogin'); ?>" />
                                <p class="description" id="tagline-description"><?php _e('You can upload your logo here. A maximum width of <strong>300 pixels</strong> is recommended.', 'wporlogin'); ?></p>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_width_logotipo_text"><?php _e('Logo width', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <input id="wporlogin_width_logotipo_text" type="number" name="wporlogin_width_logotipo_text" class="small-text" value="<?php echo esc_html(get_option('wporlogin_width_logotipo_text')); ?>"/>
                                <span class="description" id="tagline-description"><?php _e('Specify the logo width in pixels.', 'wporlogin'); ?></span>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_height_logotipo_text"><?php _e('Logo height', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <input id="wporlogin_height_logotipo_text" type="number" name="wporlogin_height_logotipo_text" class="small-text" value="<?php echo esc_html(get_option('wporlogin_height_logotipo_text')); ?>"/>
                                <span class="description" id="tagline-description"><?php _e('Specify the logo height in pixels.', 'wporlogin'); ?></span>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_background_position_logotipo_select"><?php _e('Logo position', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <select name="wporlogin_background_position_logotipo_select" id="wporlogin_background_position_logotipo_select" class="regular">
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '0'); ?> value="0"><?php _e('Top left', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '1'); ?> value="1"><?php _e('Center left', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '2'); ?> value="2"><?php _e('Bottom left', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '3'); ?> value="3"><?php _e('Top right', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '4'); ?> value="4"><?php _e('Center right', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '5'); ?> value="5"><?php _e('Bottom right', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '6'); ?> value="6"><?php _e('Top center', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '7'); ?> value="7"><?php _e('Center', 'wporlogin'); ?></option>  
                                    <option <?php selected(get_option('wporlogin_background_position_logotipo_select'), '8'); ?> value="8"><?php _e('Bottom center', 'wporlogin'); ?></option>                                                           
                                </select>
                                <span class="description" id="tagline-description"><?php _e('Set the initial position of the logo on the login page.', 'wporlogin'); ?></span>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_background_size_logotipo_select"><?php _e('Background size', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <select name="wporlogin_background_size_logotipo_select" id="wporlogin_background_size_logotipo_select" class="regular">
                                    <option <?php selected(get_option('wporlogin_background_size_logotipo_select'), '0'); ?> value="0"><?php _e('None → No background size adjustment.', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_size_logotipo_select'), '1'); ?> value="1"><?php _e('Cover → The image will cover the entire background without losing proportion.', 'wporlogin'); ?></option>
                                    <option <?php selected(get_option('wporlogin_background_size_logotipo_select'), '2'); ?> value="2"><?php _e('Contain → The image will fit within the background without being cropped.', 'wporlogin'); ?></option>                                       
                                </select>
                                <span class="description" id="tagline-description"><?php _e('Adjust how the background image is displayed.', 'wporlogin'); ?></span>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin_ruta_url_logotipo_text"><?php _e('Logo URL', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <input id="wporlogin_ruta_url_logotipo_text" type="text" name="wporlogin_ruta_url_logotipo" class="regular-text" placeholder="https://ejemplo.com" value="<?php echo esc_html(get_option('wporlogin_ruta_url_logotipo')); ?>"/><br>
                                <p class="description" id="tagline-description"><?php _e('Specify the URL where the logo will redirect when clicked.', 'wporlogin'); ?></p>
                            </td>
                        </tr>
                
                        <tr>                                 
                            <th scope="row">
                                <label for="wporlogin_titulo_logotipo_text"><?php _e('Logo title', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <input id="wporlogin_titulo_logotipo_text" type="text" name="wporlogin_titulo_logotipo" class="regular-text" value="<?php echo esc_html(get_option('wporlogin_titulo_logotipo')); ?>"/><br>
                                <p class="description" id="tagline-description"><?php _e('Set the alternative title for the logo (useful for accessibility and SEO).', 'wporlogin'); ?></p>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label style="font-size: 1.5em;"><strong><?php _e('Background image', 'wporlogin'); ?></strong></label>
                            </th>
                            <td><hr></td>
                        </tr>
                
                        <tr>
                            <th scope="row">
                                <label for="wporlogin-img-fondo"><?php _e('Background image', 'wporlogin'); ?></label>
                            </th>
                            <td>
                                <div style="margin-bottom: 20px;">
                                    <input type="radio" id="wporlogin_free_images" name="wporlogin_background_images" value="wporlogin_free_images" <?php checked(get_option('wporlogin_background_images'), 'wporlogin_free_images'); ?>>
                                    <label id="wporlogin_free_images" for="wporlogin_free_images"><?php _e('Free images', 'wporlogin'); ?></label>
                
                                    <input type="radio" id="wporlogin_my_images" name="wporlogin_background_images" value="wporlogin_my_images" <?php checked(get_option('wporlogin_background_images'), 'wporlogin_my_images'); ?> style="margin-left: 20px;">
                                    <label id="wporlogin_my_images" for="wporlogin_my_images"><?php _e('My images', 'wporlogin'); ?></label>
                                </div>                                        
                
                                <div id="wporlogin-container-background-my-image" style="<?php if( (get_option('wporlogin_background_images') == 'wporlogin_free_images' )){ echo 'display: none;'; } ?>">
                                    <?php
                                    if(esc_url(get_option('wporlogin_url_img_fondo'))){ ?>
                                        <img id="wporlogin_url_img_fondo_img" src="<?php echo esc_url(get_option('wporlogin_url_img_fondo')); ?>" style="margin-bottom: 10px; width: 220px; padding: 10px; background-color: #ffffff; border: 2px dashed rgba(0,0,0,.1);"><br>
                                    <?php } ?>
                                    <input id="wporlogin_url_img_fondo_text" type="text" name="wporlogin_url_img_fondo" class="regular-text" style="margin-bottom: 10px;" value="<?php echo esc_html(get_option('wporlogin_url_img_fondo')); ?>"/><br>
                                    <input id="wporlogin_url_img_fondo_button" type="button" class="button" value="<?php _e('Upload or Select Background Image', 'wporlogin'); ?>" />
                                    <p class="description" id="tagline-description"><?php _e('Select a background image from here. For the best results, use images with a resolution of <strong>1920x1080 pixels</strong>.', 'wporlogin'); ?>.</p>
                                </div>
                                <div id="wporlogin-container-background-free-image" style="<?php if( get_option('wporlogin_background_images') == 'wporlogin_my_images' ){ echo 'display: none;'; } ?>">
                                    <p class="description"><?php _e('You can select a background image from here', 'wporlogin'); ?></p>
                                    <br><br>
                
                                    <div style="overflow: hidden;">
                                        <?php 
                                        $count_images = count($default_backgrounds);
                                        
                                        // Recuperamos la opción guardada (puede ser vieja)
                                        $saved_free_image = get_option('wporlogin-background-free-image');
                                        
                                        // Extraemos SOLO el nombre del archivo guardado (ej: 'fondo-1.jpg')
                                        // Así ignoramos si la ruta es vieja (/img/) o nueva (/assets/img/)
                                        $saved_filename = basename($saved_free_image);

                                        for($i=0; $i<$count_images; $i++){ 
                                            // URL Nueva para mostrar
                                            $current_url = $default_backgrounds[$i];
                                            // Nombre actual para comparar
                                            $current_filename = basename($current_url);
                                            
                                            // Lógica de "Checked": Si los nombres coinciden, o si es la primera y no hay nada guardado.
                                            $is_checked = ($saved_filename === $current_filename) || ($i == 0 && empty($saved_free_image));
                                        ?>
                                        <div style="float: left;">
                                            <input type="radio" 
                                                   id="wporlogin-background-free-image-<?php echo $i; ?>" 
                                                   name="wporlogin-background-free-image" 
                                                   value="<?php echo esc_url($current_url); ?>" 
                                                   <?php checked( $is_checked, true ); ?>
                                            >
                                            <label for="wporlogin-background-free-image-<?php echo $i; ?>"><?php _e('Image ', 'wporlogin'); ?><?php echo $i+1; ?></label>
                                            <div style="padding-top: 10px; margin-right: 15px;">
                                                <img onclick="wporloginimgfreeclick('wporlogin-background-free-image-<?php echo $i; ?>')" 
                                                     id="wporlogin_url_img_fondo_img" 
                                                     src="<?php echo esc_url($current_url); ?>" 
                                                     style="margin-bottom: 10px; width: 220px; padding: 10px; background-color: #ffffff; border: 2px dashed rgba(0,0,0,.1);"
                                                ><br>
                                            </div>
                                        </div>
                                        <?php } ?>
                                        <script>
                                            function wporloginimgfreeclick(valor){
                                                document.getElementById(valor).checked=true;
                                            }
                                        </script>
                                    </div>
                                    <p class="description"><?php _e('Images from Unsplash and Pixabay are free to use. You can download more images from <a href="https://unsplash.com/" target="_blank"><strong>Unsplash</strong></a> and <a href="https://pixabay.com/" target="_blank"><strong>Pixabay</strong></a>.', 'wporlogin'); ?></p>
                                </div>   
                            </td>
                        </tr>  
                        </tbody>
                    </table>  
                </div><?php
                // CORREGIDO: Uso de constante segura y chequeo de existencia
                if ( file_exists( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ) ) {
                    include( WPORLOGIN_PATH . 'includes/templates/wporlogin-paypal-done.php' ); 
                }
                ?>
                </div>
            
            <?php submit_button(); ?>
            
        </form>
        
    </div>    
    
</div>