<?php
	// Exit if accessed directly
	if( !defined( 'ABSPATH' ) ) exit;
?>

<div class="wpfl-1 wpforo-section">

    <div class="wpforo-post-head">
        <?php wpforo_topic_head($forum, $topic); ?>
    </div>

    <?php wpforo_moderation_tools(); ?>

    <?php

	foreach($posts as $key => $post) : ?>

  <?php $member = wpforo_member($post); $wpf_is_anon = function_exists('wpforo_is_anonymous_mask_member') ? wpforo_is_anonymous_mask_member($member) : false; $post_url = wpforo_post($post['postid'],'url'); ?>
	  	<div id="post-<?php echo wpforo_bigintval($post['postid']) ?>" data-postid="<?php echo wpforo_bigintval($post['postid']) ?>" data-userid="<?php echo wpforo_bigintval($member['userid']) ?>" data-mention="<?php echo esc_attr( ( wpforo_setting( 'profiles', 'mention_nicknames' ) ? $member['user_nicename'] : '' ) ) ?>" data-isowner="<?php echo esc_attr( (int) (bool) wpforo_is_owner($member['userid']) ) ?>" class="post-wrap wpfn-<?php echo ($key+1); ?><?php if( $post['is_first_post'] ) echo ' wpfp-first' ?>">
          <?php wpforo_share_toggle($post_url, $post['body']); ?>
	      <div class="wpforo-post wpfcl-1">
	        <div class="wpf-left">
            	<?php if( WPF()->usergroup->can('va') && wpforo_setting( 'profiles', 'avatars' ) ): ?>
	            	<div class="author-avatar"><?php echo wpforo_user_avatar( $member, 80 ) ?></div>
	            <?php endif ?>
                <div class="author-data">
                    <div class="author-name"><span><?php WPF()->member->show_online_indicator($member['userid']) ?></span>&nbsp;<?php wpforo_member_link($member); ?></div>
                    <?php if( empty($wpf_is_anon) ) { wpforo_member_nicename($member, '@'); } ?>
                    <?php if( (int) wpfval($member, 'userid') ) : ?>
                    <div class="author-title"><?php wpforo_member_title($member) ?></div>
                    <?php wpforo_member_badge($member) ?>
                    <?php endif; ?>
                    <?php if( empty($wpf_is_anon) ): ?><div class="author-joined"><?php wpforo_phrase('Joined') ?>: <?php wpforo_date($member['user_registered']); ?></div><?php endif; ?>
                    <?php if( empty($wpf_is_anon) ): ?><div class="author-posts"><?php wpforo_phrase('Posts') ?>: <?php echo intval($member['posts']) ?></div><?php endif; ?>
	            </div>
                <div class="wpf-clear"></div>
            	<div id="wpforo-memberinfo-<?php echo intval($post['postid']) ?>" class="wpforo-memberinfo">
                		<?php if( (int) wpfval($member, 'userid') ) : ?>
                		<div class="wpf-member-profile-buttons">
                        <?php WPF()->tpl->member_buttons($member) ?>
                        <?php WPF()->tpl->member_social_buttons($member) ?>
                    </div>
                    <?php endif; ?>
                </div>
		        <?php do_action( 'wpforo_post_left_end', $post, $topic, $forum, 1 ); ?>
	        </div><!-- left -->
	        <div class="wpf-right">
	            <div class="wpforo-post-content-top">
	                <?php if($post['status']): ?>
                        <span class="wpf-mod-message"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> <?php wpforo_phrase('Awaiting moderation') ?></span>
                    <?php endif; ?>
                    <?php wpforo_topic_starter($topic, $post) ?>
                    <span class="wpf-post-date"><?php wpforo_date($post['created'], 'd/m/Y g:i a'); ?></span> &nbsp;
		            <?php wpforo_post_buttons( 'icon', array('custom-top', 'bookmark', 'report', 'link'), $forum, $topic, $post ); ?>
                    <?php wpforo_share_toggle($post_url, $post['body'], 'top'); ?>
	            </div><!-- wpforo-post-content-top -->
	            <div class="wpforo-post-content">
					<?php wpforo_content($post); ?>
	            </div>
	            <?php wpforo_post_edited($post); ?>
                <?php do_action( 'wpforo_tpl_post_loop_after_content', $post, $member ) ?>
                <?php if( wpforo_setting( 'profiles', 'signature' ) ): ?>
	            	<?php if($member['signature']): ?><div class="wpforo-post-signature"><?php wpforo_signature( $member ) ?></div><?php endif; ?>
                <?php endif; ?>
	        </div><!-- right -->
	        <br class="wpf-clear" />
	        <div class="bottom">
                <?php do_action( 'wpforo_post_bottom_start', $post, $topic, $forum, 1 ); ?>
	            <div class="bright">
	            	<?php wpforo_post_buttons( 'icon-text', [ 'custom-bottom', 'reply', 'quote', 'approved', 'edit', 'delete' ], $forum, $topic, $post ); ?>
                </div>
	            <div class="wpf-clear"></div>
	        </div><!-- bottom -->
	      </div><!-- wpforo-post -->
	 	</div><!-- post-wrap -->

        <?php if( $post['is_first_post'] ): ?>
            <div class="wpforo-topic-meta">
                <?php wpforo_tags( $topic ); ?>
            </div>
        <?php endif; ?>

	 	<?php do_action( 'wpforo_loop_hook', $key ) ?>

	<?php endforeach; ?>

</div><!-- wpfl-1 -->
