<?php

/**
 * WPB WooCommerce Product slider
 * By WpBean
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Adding scripts
 */

if( !function_exists('wpb_wps_adding_scripts') ){
	function wpb_wps_adding_scripts() {
		wp_register_script( 'wpb-wps-owl-carousel', WPB_WPS_URI.'/assets/js/owl.carousel.js', array('jquery'), '2.2.1', true );
		wp_register_style( 'wpb_wps_owl_carousel', WPB_WPS_URI.'/assets/css/owl.carousel.css', '', '2.2.1', false );
		wp_register_script( 'wpb_wps_main_script', WPB_WPS_URI.'/assets/js/main.js', array('jquery'), '1.0', true );
		wp_register_style( 'wpb_wps_main_style', WPB_WPS_URI.'/assets/css/main.css', '', '1.0', false );


		if( wpb_wps_get_option( 'wpb_wps_force_scripts_loading', 'wpb_wps_advanced' ) == 'on' ){
			wp_enqueue_script( 'wpb-wps-owl-carousel' );	
			wp_enqueue_style( 'wpb_wps_owl_carousel' );	
			wp_enqueue_script( 'wpb_wps_main_script' );
			wp_enqueue_style( 'wpb_wps_main_style' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'wpb_wps_adding_scripts' ); 




/**
 * Enqueue CSS For Admin
 */

if( !function_exists('wpb_wps_adding_admin_style') ){
	function wpb_wps_adding_admin_style() {
		wp_register_style( 'wpb-wps-admin', WPB_WPS_URI.'/admin/assets/css/admin-style.css', '', '1.0', false );
	}
}
add_action( 'admin_enqueue_scripts', 'wpb_wps_adding_admin_style' );