<?php
$app_data = get_wpappninja_option('app');
$app_name = isset($app_data['name']) ? $app_data['name'] : get_bloginfo('name');
$app_theme_primary = isset($app_data['theme']['primary']) ? $app_data['theme']['primary'] : "#0f53a6";
$app_theme_accent = isset($app_data['theme']['accent']) ? $app_data['theme']['accent'] : "#dd9933";
?>
<!DOCTYPE html>
<html class="wpappninja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black">

  <?php wp_head(); ?>
  <?php $theme_main = wpappninja_get_hex_color(); $theme_color = wpappninja_get_hex_color(true); ?>

  <style type="text/css">#wpadminbar {background-color:<?php echo $theme_main;?>!important;overflow: hidden;} .theme-wpappninja .button:not(.button-fill) {border-color: <?php echo $theme_color;?>; color: <?php echo $theme_color;?>; } .theme-wpappninja .button:not(.button-fill) {color: <?php echo $theme_color;?>; } .theme-wpappninja .navbar .button:not(.button-fill), .theme-wpappninja.navbar .button:not(.button-fill), .theme-wpappninja .toolbar .button:not(.button-fill), .theme-wpappninja.toolbar .button:not(.button-fill), .theme-wpappninja .subnavbar .button:not(.button-fill), .theme-wpappninja.subnavbar .button:not(.button-fill) {color: #fff; }.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover{background: <?php echo $theme_color;?>; } .theme-wpappninja .button.button-fill {background: <?php echo $theme_color;?>; color: #fff; } html:not(.watch-active-state) .theme-wpappninja .button.button-fill:active,html:not(.watch-active-state) .theme-wpappninja .button.button-fill:hover, .theme-wpappninja .button.button-fill.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .progressbar.theme-wpappninja, .theme-wpappninja .progressbar {background-color:<?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .progressbar.theme-wpappninja span, .theme-wpappninja .progressbar span {background-color: <?php echo $theme_color;?>; } .progressbar-infinite.theme-wpappninja, .theme-wpappninja .progressbar-infinite {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .progressbar-infinite.theme-wpappninja:after, .theme-wpappninja .progressbar-infinite:after, .progressbar-infinite.theme-wpappninja:before, .theme-wpappninja .progressbar-infinite:before {background-color: <?php echo $theme_color;?>; } .color-wpappninja i.icon, i.icon.color-wpappninja {color: <?php echo $theme_color;?>; } i.icon-next.color-wpappninja, i.icon-next.theme-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20fill%3D'%23e91e63'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M10%206L8.59%207.41%2013.17%2012l-4.58%204.59L10%2018l6-6z'%2F%3E%3Cpath%20d%3D'M0%200h24v24H0z'%20fill%3D'none'%2F%3E%3C%2Fsvg%3E"); } i.icon-prev.color-wpappninja, i.icon-prev.theme-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20fill%3D'%23e91e63'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M15.41%207.41L14%206l-6%206%206%206%201.41-1.41L10.83%2012z'%2F%3E%3Cpath%20d%3D'M0%200h24v24H0z'%20fill%3D'none'%2F%3E%3C%2Fsvg%3E"); } i.icon-back.color-wpappninja, i.icon-back.theme-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M20%2011H7.83l5.59-5.59L12%204l-8%208%208%208%201.41-1.41L7.83%2013H20v-2z'%20fill%3D'%23e91e63'%2F%3E%3C%2Fsvg%3E"); } i.icon-forward.color-wpappninja, i.icon-forward.theme-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M12%204l-1.41%201.41L16.17%2011H4v2h12.17l-5.58%205.59L12%2020l8-8z'%20fill%3D'%23e91e63'%2F%3E%3C%2Fsvg%3E"); } i.icon-bars.color-wpappninja, i.icon-bars.theme-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M3%2018h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z'%20fill%3D'%23e91e63'%2F%3E%3C%2Fsvg%3E"); } .theme-wpappninja a, .theme-wpappninja .card a {color: <?php echo $theme_color;?>; } .theme-wpappninja .navbar, .navbar.theme-wpappninja, .theme-wpappninja .toolbar, .toolbar.theme-wpappninja, .theme-wpappninja .subnavbar, .subnavbar.theme-wpappninja, .theme-wpappninja .searchbar, .searchbar.theme-wpappninja {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .label-switch input[type="checkbox"]:checked + .checkbox, .label-switch.theme-wpappninja input[type="checkbox"]:checked + .checkbox {background-color:<?php echo wpappninja_adjustBrightness($theme_color, 40);?>; } .theme-wpappninja .label-switch input[type="checkbox"]:checked + .checkbox:after, .label-switch.theme-wpappninja input[type="checkbox"]:checked + .checkbox:after {background-color: <?php echo $theme_color;?>; } .theme-wpappninja label.label-checkbox i.icon-form-checkbox:after, label.label-checkbox.theme-wpappninja i.icon-form-checkbox:after {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20fill%3D'%23ffffff'%20width%3D'24'%20height%3D'24'%20viewBox%3D'0%200%2024%2024'%3E%3Cpath%20d%3D'M9%2016.17L4.83%2012l-1.42%201.41L9%2019%2021%207l-1.41-1.41z'%2F%3E%3C%2Fsvg%3E"); } .theme-wpappninja label.label-checkbox input[type="checkbox"]:checked + .item-media i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="checkbox"]:checked + .item-media i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="radio"]:checked + .item-media i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="radio"]:checked + .item-media i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="checkbox"]:checked ~ .item-after i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="checkbox"]:checked ~ .item-after i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="radio"]:checked ~ .item-after i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="radio"]:checked ~ .item-after i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="checkbox"]:checked ~ .item-inner i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="checkbox"]:checked ~ .item-inner i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="radio"]:checked ~ .item-inner i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="radio"]:checked ~ .item-inner i.icon-form-checkbox {border-color: <?php echo $theme_color;?>; background-color: <?php echo $theme_color;?>; } .theme-wpappninja label.label-radio i.icon-form-radio:after, label.label-radio.theme-wpappninja i.icon-form-radio:after {background-color: <?php echo $theme_color;?>; } .theme-wpappninja label.label-radio input[type="checkbox"]:checked + .item-media i.icon-form-radio, label.label-radio.theme-wpappninja input[type="checkbox"]:checked + .item-media i.icon-form-radio, .theme-wpappninja label.label-radio input[type="radio"]:checked + .item-media i.icon-form-radio, label.label-radio.theme-wpappninja input[type="radio"]:checked + .item-media i.icon-form-radio, .theme-wpappninja label.label-radio input[type="checkbox"]:checked ~ .item-after i.icon-form-radio, label.label-radio.theme-wpappninja input[type="checkbox"]:checked ~ .item-after i.icon-form-radio, .theme-wpappninja label.label-radio input[type="radio"]:checked ~ .item-after i.icon-form-radio, label.label-radio.theme-wpappninja input[type="radio"]:checked ~ .item-after i.icon-form-radio, .theme-wpappninja label.label-radio input[type="checkbox"]:checked ~ .item-inner i.icon-form-radio, label.label-radio.theme-wpappninja input[type="checkbox"]:checked ~ .item-inner i.icon-form-radio, .theme-wpappninja label.label-radio input[type="radio"]:checked ~ .item-inner i.icon-form-radio, label.label-radio.theme-wpappninja input[type="radio"]:checked ~ .item-inner i.icon-form-radio {border-color: <?php echo $theme_color;?>; } .theme-wpappninja label.label-radio input[type="checkbox"]:checked + .item-media i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="checkbox"]:checked + .item-media i.icon-form-radio:after, .theme-wpappninja label.label-radio input[type="radio"]:checked + .item-media i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="radio"]:checked + .item-media i.icon-form-radio:after, .theme-wpappninja label.label-radio input[type="checkbox"]:checked ~ .item-after i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="checkbox"]:checked ~ .item-after i.icon-form-radio:after, .theme-wpappninja label.label-radio input[type="radio"]:checked ~ .item-after i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="radio"]:checked ~ .item-after i.icon-form-radio:after, .theme-wpappninja label.label-radio input[type="checkbox"]:checked ~ .item-inner i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="checkbox"]:checked ~ .item-inner i.icon-form-radio:after, .theme-wpappninja label.label-radio input[type="radio"]:checked ~ .item-inner i.icon-form-radio:after, label.label-radio.theme-wpappninja input[type="radio"]:checked ~ .item-inner i.icon-form-radio:after {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .form-checkbox input[type="checkbox"]:checked ~ i, .form-checkbox.theme-wpappninja input[type="checkbox"]:checked ~ i {border-color: <?php echo $theme_color;?>; background-color: <?php echo $theme_color;?>; } .theme-wpappninja .form-radio input[type="radio"]:checked ~ i, .form-radio.theme-wpappninja input[type="radio"]:checked ~ i {border-color: <?php echo $theme_color;?>; } .theme-wpappninja .form-radio input[type="radio"]:checked ~ i:after, .form-radio.theme-wpappninja input[type="radio"]:checked ~ i:after {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .form-checkbox .ripple-wave, .theme-wpappninja .form-radio .ripple-wave {background: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .theme-wpappninja .focus-state .label, .theme-wpappninja .focus-state .floating-label {color: <?php echo $theme_color;?>; } .theme-wpappninja .item-input-field.focus-state:after, .theme-wpappninja .input-field.focus-state:after, .theme-wpappninja .item-input-field.not-empty-state:after, .theme-wpappninja .input-field.not-empty-state:after {background: <?php echo $theme_color;?>; } .theme-wpappninja .picker-calendar-day.picker-calendar-day-today span {color: <?php echo $theme_color;?>; } .theme-wpappninja .picker-calendar-day.picker-calendar-day-selected span {background-color: <?php echo $theme_color;?>; color: #fff; } .theme-wpappninja .picker-calendar-day.picker-calendar-day-has-events span:after {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .picker-header {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .modal-button {color: <?php echo $theme_color;?>; } .theme-wpappninja .timeline-horizontal .timeline-item-date, .timeline-horizontal.theme-wpappninja .timeline-item-date {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .timeline-year-title, .theme-wpappninja .timeline-month-title {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .statusbar-overlay {background-color: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .theme-wpappninja .data-table .data-table-header-selected, .data-table.theme-wpappninja .data-table-header-selected {background:<?php echo wpappninja_adjustBrightness($theme_color, 40);?>; } .theme-wpappninja .data-table .data-table-title-selected, .data-table.theme-wpappninja .data-table-title-selected {color: <?php echo $theme_color;?>; } .swiper-pagination.color-wpappninja .swiper-pagination-bullet-active, .theme-wpappninja .swiper-pagination .swiper-pagination-bullet-active {background-color: <?php echo $theme_color;?>; } .swiper-pagination.color-wpappninja .swiper-pagination-progressbar, .theme-wpappninja .swiper-pagination .swiper-pagination-progressbar {background-color: <?php echo $theme_color;?>; } .swiper-pagination.swiper-pagination-progress.bg-wpappninja {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .swiper-button-next.color-wpappninja, .swiper-container-rtl .swiper-button-prev.color-wpappninja, .theme-wpappninja .swiper-button-next, .theme-wpappninja .swiper-container-rtl .swiper-button-prev {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2027%2044'%3E%3Cpath%20d%3D'M27%2C22L27%2C22L5%2C44l-2.1-2.1L22.8%2C22L2.9%2C2.1L5%2C0L27%2C22L27%2C22z'%20fill%3D'%23e91e63'%2F%3E%3C%2Fsvg%3E"); } .swiper-button-prev.color-wpappninja, .swiper-container-rtl .swiper-button-next.color-wpappninja, .theme-wpappninja .swiper-button-prev, .theme-wpappninja .swiper-container-rtl .swiper-button-next {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2027%2044'%3E%3Cpath%20d%3D'M0%2C22L22%2C0l2.1%2C2.1L4.2%2C22l19.9%2C19.9L22%2C44L0%2C22L0%2C22L0%2C22z'%20fill%3D'%23e91e63'%2F%3E%3C%2Fsvg%3E"); } .theme-wpappninja .floating-button, .theme-wpappninja .speed-dial-buttons a, .floating-button.theme-wpappninja, .speed-dial-buttons a.theme-wpappninja {color: #fff; background: <?php echo $theme_color;?>; } html:not(.watch-active-state) .theme-wpappninja .floating-button:active, html:not(.watch-active-state) .theme-wpappninja .speed-dial-buttons a:active, html:not(.watch-active-state) .floating-button.theme-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.theme-wpappninja:active, .theme-wpappninja .floating-button.active-state, .theme-wpappninja .speed-dial-buttons a.active-state, .floating-button.theme-wpappninja.active-state, .speed-dial-buttons a.theme-wpappninja.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .theme-wpappninja .floating-button i, .theme-wpappninja .speed-dial-buttons a i, .floating-button.theme-wpappninja i, .speed-dial-buttons a.theme-wpappninja i {color: inherit; } .theme-wpappninja .range-slider input[type="range"]::-webkit-slider-thumb:before, .range-slider.theme-wpappninja input[type="range"]::-webkit-slider-thumb:before {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .range-slider input[type="range"]::-webkit-slider-thumb, .range-slider.theme-wpappninja input[type="range"]::-webkit-slider-thumb {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .range-slider input[type="range"]::-ms-thumb, .range-slider.theme-wpappninja input[type="range"]::-ms-thumb {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .range-slider input[type="range"]::-ms-fill-lower, .range-slider.theme-wpappninja input[type="range"]::-ms-fill-lower {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .range-slider input[type="range"]::-moz-range-thumb, .range-slider.theme-wpappninja input[type="range"]::-moz-range-thumb {background-color: <?php echo $theme_color;?>; } .badge.theme-wpappninja {background-color: <?php echo $theme_color;?>; color: #fff; } .color-wpappninja {color: <?php echo $theme_color;?>; } .list-block .item-link.list-button.color-wpappninja, .list-button.color-wpappninja, .list-block .item-link.color-wpappninja, .tabbar a.active.color-wpappninja, a.color-wpappninja {color: <?php echo $theme_color;?>; } .label-switch input[type="checkbox"]:checked + .checkbox.color-wpappninja, .label-switch.color-wpappninja input[type="checkbox"]:checked + .checkbox {background-color: <?php echo $theme_color;?>; } .button.color-wpappninja:not(.button-fill), .color-wpappninja.buttons-row .button:not(.button-fill) {color: <?php echo $theme_color;?> !important; } .button.button-fill.bg-wpappninja, .button.button-fill.color-wpappninja {background: <?php echo $theme_color;?> !important; color: #fff; } html:not(.watch-active-state) .button.button-fill.bg-wpappninja:active, html:not(.watch-active-state) .button.button-fill.color-wpappninja:active, .button.button-fill.bg-wpappninja.active-state, .button.button-fill.color-wpappninja.active-state {background:<?php echo wpappninja_adjustBrightness($theme_color, -50);?> !important; } .progressbar.color-wpappninja, .progressbar.bg-wpappninja {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .progressbar.color-wpappninja span, .progressbar.bg-wpappninja span {background-color: <?php echo $theme_color;?>; } .progressbar-infinite.color-wpappninja, .progressbar-infinite.bg-wpappninja {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .progressbar-infinite.color-wpappninja:after, .progressbar-infinite.bg-wpappninja:after, .progressbar-infinite.color-wpappninja:before, .progressbar-infinite.bg-wpappninja:before {background-color: <?php echo $theme_color;?>; } .color-wpappninja i.icon, i.icon.color-wpappninja {color: <?php echo $theme_color;?>; } .preloader.color-wpappninja svg circle, .preloader.preloader-wpappninja svg circle {stroke: <?php echo $theme_color;?>; } .preloader.color-wpappninja .preloader-inner-gap, .preloader.preloader-wpappninja .preloader-inner-gap, .preloader.color-wpappninja .preloader-inner-half-circle, .preloader.preloader-wpappninja .preloader-inner-half-circle {border-color: <?php echo $theme_color;?>; } .bg-wpappninja, a.bg-wpappninja, .list-block .swipeout-actions-left a.bg-wpappninja, .list-block .swipeout-actions-right a.bg-wpappninja {background-color: <?php echo $theme_color;?>; } html:not(.watch-active-state) .list-block .bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block a.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block .list-block .swipeout-actions-left a.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block .list-block .swipeout-actions-right a.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-blocka.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block.list-block .swipeout-actions-left a.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block.list-block .swipeout-actions-right a.bg-wpappninja .item-link:active, html:not(.watch-active-state) .list-block .item-link.bg-wpappninja:active, html:not(.watch-active-state) .list-block .item-linka.bg-wpappninja:active, html:not(.watch-active-state) .list-block .item-link.list-block .swipeout-actions-left a.bg-wpappninja:active, html:not(.watch-active-state) .list-block .item-link.list-block .swipeout-actions-right a.bg-wpappninja:active, .list-block .bg-wpappninja .item-link.active-state, .list-block a.bg-wpappninja .item-link.active-state, .list-block .list-block .swipeout-actions-left a.bg-wpappninja .item-link.active-state, .list-block .list-block .swipeout-actions-right a.bg-wpappninja .item-link.active-state, .list-block.bg-wpappninja .item-link.active-state, .list-blocka.bg-wpappninja .item-link.active-state, .list-block.list-block .swipeout-actions-left a.bg-wpappninja .item-link.active-state, .list-block.list-block .swipeout-actions-right a.bg-wpappninja .item-link.active-state, .list-block .item-link.bg-wpappninja.active-state, .list-block .item-linka.bg-wpappninja.active-state, .list-block .item-link.list-block .swipeout-actions-left a.bg-wpappninja.active-state, .list-block .item-link.list-block .swipeout-actions-right a.bg-wpappninja.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .border-wpappninja {border-color: <?php echo $theme_color;?>; } .list-block .border-wpappninja.item-inner:after, .list-block ul.border-wpappninja:after, .border-wpappninja:after, .list-block .border-wpappninja.item-inner:before, .list-block ul.border-wpappninja:before, .border-wpappninja:before {background-color: <?php echo $theme_color;?>; } .floating-button.color-wpappninja, .speed-dial-buttons a.color-wpappninja, .floating-button.bg-wpappninja, .speed-dial-buttons a.bg-wpappninja {color: #fff; background: <?php echo $theme_color;?>; } html:not(.watch-active-state) .floating-button.color-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.color-wpappninja:active, html:not(.watch-active-state) .floating-button.bg-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.bg-wpappninja:active, .floating-button.color-wpappninja.active-state, .speed-dial-buttons a.color-wpappninja.active-state, .floating-button.bg-wpappninja.active-state, .speed-dial-buttons a.bg-wpappninja.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .floating-button.color-wpappninja i, .speed-dial-buttons a.color-wpappninja i, .floating-button.bg-wpappninja i, .speed-dial-buttons a.bg-wpappninja i {color: inherit; } .ripple-wpappninja .ripple-wave {background-color:<?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .range-slider.color-wpappninja input[type="range"]::-webkit-slider-thumb:before {background-color: <?php echo $theme_color;?>; } .range-slider.color-wpappninja input[type="range"]::-webkit-slider-thumb {background-color: <?php echo $theme_color;?>; } .range-slider.color-wpappninja input[type="range"]::-ms-thumb {background-color: <?php echo $theme_color;?>; } .range-slider.color-wpappninja input[type="range"]::-ms-fill-lower {background-color: <?php echo $theme_color;?>; } .range-slider.color-wpappninja input[type="range"]::-moz-range-thumb {background-color: <?php echo $theme_color;?>; } .badge.color-wpappninja {background-color: <?php echo $theme_color;?>; color: #fff; } html:not(.watch-active-state) .theme-wpappninja .button:not(.button-fill):active, .theme-wpappninja .button:not(.button-fill).active-state {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .theme-wpappninja .button:not(.button-fill).active {background-color: <?php echo $theme_color;?>; color: #fff; } .theme-wpappninja .button.button-fill {background: <?php echo $theme_color;?>; color: #fff; } .progressbar.theme-wpappninja span, .theme-wpappninja .progressbar span {background-color: <?php echo $theme_color;?>; } .progressbar-infinite.theme-wpappninja:before, .theme-wpappninja .progressbar-infinite:before {background-color: <?php echo $theme_color;?>; } .theme-wpappninja i.icon, i.icon.theme-wpappninja {color: <?php echo $theme_color;?>; } i.icon-next.color-wpappninja, i.icon-next.theme-wpappninja, .theme-wpappninja i.icon-next {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2015%2015'%3E%3Cg%3E%3Cpath%20fill%3D'%23ff2d55'%20d%3D'M1%2C1.6l11.8%2C5.8L1%2C13.4V1.6%20M0%2C0v15l15-7.6L0%2C0L0%2C0z'%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E"); } i.icon-prev.color-wpappninja, i.icon-prev.theme-wpappninja, .theme-wpappninja i.icon-prev {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2015%2015'%3E%3Cg%3E%3Cpath%20fill%3D'%23ff2d55'%20d%3D'M14%2C1.6v11.8L2.2%2C7.6L14%2C1.6%20M15%2C0L0%2C7.6L15%2C15V0L15%2C0z'%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E"); } i.icon-back.color-wpappninja, i.icon-back.theme-wpappninja, .theme-wpappninja i.icon-back {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2012%2020'%3E%3Cpath%20d%3D'M10%2C0l2%2C2l-8%2C8l8%2C8l-2%2C2L0%2C10L10%2C0z'%20fill%3D'%23ff2d55'%2F%3E%3C%2Fsvg%3E"); } i.icon-forward.color-wpappninja, i.icon-forward.theme-wpappninja, .theme-wpappninja i.icon-forward {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2012%2020'%3E%3Cpath%20d%3D'M2%2C20l-2-2l8-8L0%2C2l2-2l10%2C10L2%2C20z'%20fill%3D'%23ff2d55'%2F%3E%3C%2Fsvg%3E"); } i.icon-bars.color-wpappninja, i.icon-bars.theme-wpappninja, .theme-wpappninja i.icon-bars {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2021%2014'%3E%3Cpath%20fill%3D'%23ff2d55'%20d%3D'M0%2C0h2v2H0V0z%20M4%2C0h17v1H4V0z%20M0%2C6h2v2H0V6z%20M4%2C6h17v1H4V6z%20M0%2C12h2v2H0V12z%20M4%2C12h17v1H4V12z'%2F%3E%3C%2Fsvg%3E"); } @media (-webkit-min-device-pixel-ratio: 2) {i.icon-bars.color-wpappninja, i.icon-bars.theme-wpappninja, .theme-wpappninja i.icon-bars {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2042%2026'%3E%3Cpath%20fill%3D'%23ff2d55'%20d%3D'M0%2C0h4v4H0V0z%20M8%2C1h34v2H8V1z%20M0%2C11h4v4H0V11z%20M8%2C12h34v2H8V12z%20M0%2C22h4v4H0V22z%20M8%2C23h34v2H8V23z'%2F%3E%3C%2Fsvg%3E"); } } .theme-wpappninja a, .theme-wpappninja .item-link.list-button, .theme-wpappninja .list-button {color: <?php echo $theme_color;?>; } .theme-wpappninja .tabbar a, .tabbar.theme-wpappninja a, .theme-wpappninja .tabbar a i, .tabbar.theme-wpappninja a i {color: inherit; } .theme-wpappninja .tabbar a.active, .tabbar.theme-wpappninja a.active, .theme-wpappninja .tabbar a.active i, .tabbar.theme-wpappninja a.active i {color: <?php echo $theme_color;?>; } .theme-wpappninja .messagebar .messagebar-send-link {background-color: <?php echo $theme_color;?>; } .theme-wpappninja label.label-checkbox input[type="checkbox"]:checked + .item-media i.icon-form-checkbox, .theme-wpappninja label.label-checkbox input[type="radio"]:checked + .item-media i.icon-form-checkbox, .theme-wpappninja .form-checkbox input[type="checkbox"]:checked ~ i, label.label-checkbox.theme-wpappninja input[type="checkbox"]:checked + .item-media i.icon-form-checkbox, label.label-checkbox.theme-wpappninja input[type="radio"]:checked + .item-media i.icon-form-checkbox, .form-checkbox.theme-wpappninja input[type="checkbox"]:checked ~ i {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .form-radio input[type="radio"]:checked ~ i, .theme-wpappninja label.label-radio input[type="checkbox"]:checked ~ .item-inner, .theme-wpappninja label.label-radio input[type="radio"]:checked ~ .item-inner, .form-radio.theme-wpappninja input[type="radio"]:checked ~ i, label.label-radio.theme-wpappninja input[type="checkbox"]:checked ~ .item-inner, label.label-radio.theme-wpappninja input[type="radio"]:checked ~ .item-inner {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2013%2010'%3E%3Cpolygon%20fill%3D'%23ff2d55'%20points%3D'11.6%2C0%204.4%2C7.2%201.4%2C4.2%200%2C5.6%204.4%2C10%204.4%2C10%204.4%2C10%2013%2C1.4%20'%2F%3E%3C%2Fsvg%3E"); } .theme-wpappninja .picker-calendar-day.picker-calendar-day-selected span {background-color: <?php echo $theme_color;?> !important; } .theme-wpappninja .data-table .data-table-header-selected, .data-table.theme-wpappninja .data-table-header-selected {background: <?php echo wpappninja_adjustBrightness($theme_color, 40);?>; } .theme-wpappninja .data-table .data-table-title-selected, .data-table.theme-wpappninja .data-table-title-selected {color: <?php echo $theme_color;?>; } .swiper-pagination.color-wpappninja .swiper-pagination-bullet-active, .theme-wpappninja .swiper-pagination .swiper-pagination-bullet-active {background-color: <?php echo $theme_color;?>; } .swiper-pagination.color-wpappninja .swiper-pagination-progressbar, .theme-wpappninja .swiper-pagination .swiper-pagination-progressbar {background-color: <?php echo $theme_color;?>; } .swiper-pagination.swiper-pagination-progress.bg-wpappninja {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .swiper-button-next.color-wpappninja, .swiper-container-rtl .swiper-button-prev.color-wpappninja, .theme-wpappninja .swiper-button-next, .theme-wpappninja .swiper-container-rtl .swiper-button-prev {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2027%2044'%3E%3Cpath%20d%3D'M27%2C22L27%2C22L5%2C44l-2.1-2.1L22.8%2C22L2.9%2C2.1L5%2C0L27%2C22L27%2C22z'%20fill%3D'%23ff2d55'%2F%3E%3C%2Fsvg%3E"); } .swiper-button-prev.color-wpappninja, .swiper-container-rtl .swiper-button-next.color-wpappninja, .theme-wpappninja .swiper-button-prev, .theme-wpappninja .swiper-container-rtl .swiper-button-next {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2027%2044'%3E%3Cpath%20d%3D'M0%2C22L22%2C0l2.1%2C2.1L4.2%2C22l19.9%2C19.9L22%2C44L0%2C22L0%2C22L0%2C22z'%20fill%3D'%23ff2d55'%2F%3E%3C%2Fsvg%3E"); } .theme-wpappninja .floating-button, .theme-wpappninja .speed-dial-buttons a, .floating-button.theme-wpappninja, .speed-dial-buttons a.theme-wpappninja {color: #fff; background: <?php echo $theme_color;?>; } html:not(.watch-active-state) .theme-wpappninja .floating-button:active, html:not(.watch-active-state) .theme-wpappninja .speed-dial-buttons a:active, html:not(.watch-active-state) .floating-button.theme-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.theme-wpappninja:active, .theme-wpappninja .floating-button.active-state, .theme-wpappninja .speed-dial-buttons a.active-state, .floating-button.theme-wpappninja.active-state, .speed-dial-buttons a.theme-wpappninja.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .theme-wpappninja .floating-button i, .theme-wpappninja .speed-dial-buttons a i, .floating-button.theme-wpappninja i, .speed-dial-buttons a.theme-wpappninja i {color: inherit; } .theme-wpappninja .range-slider input[type="range"]::-webkit-slider-thumb:before, .range-slider.theme-wpappninja input[type="range"]::-webkit-slider-thumb:before {background-color: <?php echo $theme_color;?>; } .theme-wpappninja .range-slider input[type="range"]::-ms-fill-lower, .range-slider.theme-wpappninja input[type="range"]::-ms-fill-lower {background-color: <?php echo $theme_color;?>; } .badge.theme-wpappninja {background-color: <?php echo $theme_color;?>; color: #fff; } .color-wpappninja {color: <?php echo $theme_color;?>; } .list-block .item-link.list-button.color-wpappninja, .list-button.color-wpappninja, .tabbar a.active.color-wpappninja, a.color-wpappninja {color: <?php echo $theme_color;?>; } .label-switch input[type="checkbox"]:checked + .checkbox.color-wpappninja, .label-switch.color-wpappninja input[type="checkbox"]:checked + .checkbox {background-color: <?php echo $theme_color;?>; } .color-wpappninja.button:not(.button-fill), .color-wpappninja.buttons-row .button {border-color: <?php echo $theme_color;?>; } html:not(.watch-active-state) .color-wpappninja.button:not(.button-fill):active, html:not(.watch-active-state) .color-wpappninja.buttons-row .button:active, .color-wpappninja.button:not(.button-fill).active-state, .color-wpappninja.buttons-row .button.active-state {background-color: <?php echo wpappninja_adjustBrightness($theme_color, 20);?>; } .color-wpappninja.button:not(.button-fill).active, .color-wpappninja.buttons-row .button.active {background-color: <?php echo $theme_color;?>; color: #fff; } .button.button-fill.color-wpappninja {background: <?php echo $theme_color;?>; color: #fff; } .progressbar.color-wpappninja span, .progressbar.bg-wpappninja span {background-color: <?php echo $theme_color;?>; } .progressbar-infinite.color-wpappninja:before, .progressbar-infinite.bg-wpappninja:before {background-color: <?php echo $theme_color;?>; } .color-wpappninja i.icon, i.icon.color-wpappninja {color: <?php echo $theme_color;?>; } .preloader.color-wpappninja, .preloader.preloader-wpappninja {background-image: url("data:image/svg+xml;charset=utf-8,%3Csvg%20viewBox%3D'0%200%20120%20120'%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20xmlns%3Axlink%3D'http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink'%3E%3Cdefs%3E%3Cline%20id%3D'l'%20x1%3D'60'%20x2%3D'60'%20y1%3D'7'%20y2%3D'27'%20stroke%3D'%23ff2d55'%20stroke-width%3D'11'%20stroke-linecap%3D'round'%2F%3E%3C%2Fdefs%3E%3Cg%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%20transform%3D'rotate(30%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%20transform%3D'rotate(60%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%20transform%3D'rotate(90%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%20transform%3D'rotate(120%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.27'%20transform%3D'rotate(150%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.37'%20transform%3D'rotate(180%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.46'%20transform%3D'rotate(210%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.56'%20transform%3D'rotate(240%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.66'%20transform%3D'rotate(270%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.75'%20transform%3D'rotate(300%2060%2C60)'%2F%3E%3Cuse%20xlink%3Ahref%3D'%23l'%20opacity%3D'.85'%20transform%3D'rotate(330%2060%2C60)'%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E"); } .bg-wpappninja, .button.button-fill.bg-wpappninja, a.bg-wpappninja, .list-block .swipeout-actions-left a.bg-wpappninja, .list-block .swipeout-actions-right a.bg-wpappninja {background-color: <?php echo $theme_color;?>; } .border-wpappninja {border-color: <?php echo $theme_color;?>; } .list-block .border-wpappninja.item-inner:after, .list-block ul.border-wpappninja:after, .border-wpappninja:after, .list-block .border-wpappninja.item-inner:before, .list-block ul.border-wpappninja:before, .border-wpappninja:before {background-color: <?php echo $theme_color;?>; } .floating-button.color-wpappninja, .speed-dial-buttons a.color-wpappninja, .floating-button.bg-wpappninja, .speed-dial-buttons a.bg-wpappninja {color: #fff; background: <?php echo $theme_color;?>; } html:not(.watch-active-state) .floating-button.color-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.color-wpappninja:active, html:not(.watch-active-state) .floating-button.bg-wpappninja:active, html:not(.watch-active-state) .speed-dial-buttons a.bg-wpappninja:active, .floating-button.color-wpappninja.active-state, .speed-dial-buttons a.color-wpappninja.active-state, .floating-button.bg-wpappninja.active-state, .speed-dial-buttons a.bg-wpappninja.active-state {background: <?php echo wpappninja_adjustBrightness($theme_color, -50);?>; } .floating-button.color-wpappninja i, .speed-dial-buttons a.color-wpappninja i, .floating-button.bg-wpappninja i, .speed-dial-buttons a.bg-wpappninja i {color: inherit; } .range-slider.color-wpappninja input[type="range"]::-webkit-slider-thumb:before {background-color: <?php echo $theme_color;?>; } .range-slider.color-wpappninja input[type="range"]::-ms-fill-lower {background-color: <?php echo $theme_color;?>; } .badge.color-wpappninja {background-color: <?php echo $theme_color;?>; color: #fff; } .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button {color: <?php echo $theme_color;?>; border: 1px solid <?php echo $theme_color;?>; } .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt {color: <?php echo $theme_color;?>; }</style>

</head>
<body <?php body_class(); ?>>


  <!-- Your main view, should have "view-main" class -->
  <div class="view view-main">

    <div class="content-block">
      <div class="content-block-inner">
        <?php dynamic_sidebar('wpappninja-before'); ?>
      </div>
    </div>