<?php

namespace WeDevs\Wpuf\Free;

use WeDevs\Wpuf\Admin\Forms\Post\Templates\Post_Form_Template_WooCommerce;
use WeDevs\Wpuf\Admin\Forms\Post\Templates\Pro_Form_Preview_Artwork;
use WeDevs\Wpuf\Admin\Forms\Post\Templates\Pro_Form_Preview_EDD;
use WeDevs\Wpuf\Admin\Forms\Post\Templates\Pro_Form_Preview_Press_Release;
use WeDevs\Wpuf\Admin\Forms\Post\Templates\Pro_Form_Preview_Professional_Video;
use WeDevs\Wpuf\Pro\Admin\Coupon_Elements;
use WeDevs\Wpuf\Hooks\Form_Settings_Cleanup;

class Free_Loader extends Pro_Prompt {

    public $edit_profile = null;

    /**
     * Run the hooks to load free elements on places
     *
     * @since 4.1.4
     *
     * @return void
     */
    public function run_hooks() {
        add_action( 'add_meta_boxes_wpuf_forms', [ $this, 'add_meta_box_post' ], 99 );

        add_action( 'wpuf_form_buttons_custom', [ $this, 'wpuf_form_buttons_custom_runner' ] );
        add_action( 'wpuf_form_buttons_other', [ $this, 'wpuf_form_buttons_other_runner' ] );
        add_action( 'wpuf_edit_form_area_profile', [ $this, 'wpuf_edit_form_area_profile_runner' ] );
        add_action( 'registration_setting', [ $this, 'registration_setting_runner' ] );
        add_action( 'wpuf_check_post_type', [ $this, 'wpuf_check_post_type_runner' ], 10, 2 );
        add_action( 'wpuf_form_custom_taxonomies', [ $this, 'wpuf_form_custom_taxonomies_runner' ] );
        add_action( 'wpuf_conditional_field_render_hook', [ $this, 'wpuf_conditional_field_render_hook_runner' ], 10, 3 );

        //coupon
        add_action( 'wpuf_coupon_settings_form', [ $this, 'wpuf_coupon_settings_form_runner' ] );
        add_action( 'wpuf_check_save_permission', [ $this, 'wpuf_check_save_permission_runner' ], 10, 2 );

        // admin menu
        add_action( 'wpuf_admin_menu', [ $this, 'admin_menu' ] );
        add_action( 'wpuf_admin_menu_top', [ $this, 'admin_menu_top' ] );
        add_action( 'wpuf_form_setting', [ $this, 'form_setting_runner' ], 10, 2 );
        add_action( 'wpuf_form_post_expiration', [ $this, 'wpuf_form_post_expiration_runner' ] );
        add_action( 'wpuf_form_settings_post_notification', [ $this, 'post_notification_hook_runner' ] );

        // plugin settings
        add_filter( 'wpuf_settings_sections', [ $this, 'pro_sections' ] );
        add_filter( 'wpuf_settings_fields', [ $this, 'pro_settings' ] );

        // post form templates
        add_filter( 'wpuf_get_post_form_templates', [ $this, 'post_form_templates' ] );
        add_filter( 'wpuf_get_pro_form_previews', [ $this, 'pro_form_previews' ] );

        // post form settings
        add_filter( 'wpuf_form_builder_settings_general', [ $this, 'form_settings_preview_general' ] );
        add_filter( 'wpuf_form_builder_settings_notification', [ $this, 'form_settings_preview_notification' ] );
        add_filter( 'wpuf_form_builder_settings_display', [ $this, 'form_settings_preview_display' ] );
        add_filter( 'wpuf_form_builder_settings_advanced', [ $this, 'form_settings_preview_advanced' ] );
        add_filter( 'wpuf_form_builder_settings_post_expiration', [ $this, 'form_settings_preview_post_expiration' ] );
        add_filter( 'wpuf_form_builder_post_settings_menu_items', [ $this, 'form_settings_modules' ] );

        // payment gateway added for previewing
        add_filter( 'wpuf_payment_gateways', [ $this, 'wpuf_payment_gateways' ] );

        // navigation tabs added for previewing in Subscription > Add/Edit Subscription
        add_action( 'wpuf_admin_subs_nav_tab', [ $this, 'subscription_tabs' ] );
        add_action( 'wpuf_admin_subs_nav_content', [ $this, 'subscription_tab_contents' ] );

        // subscription
        add_action( 'wpuf_admin_subscription_detail', [ $this, 'wpuf_admin_subscription_detail_runner' ], 10, 4 );
        add_filter( 'wpuf_subscription_section_advanced', [ $this, 'add_taxonomy_restriction_section' ] );
        add_filter( 'wpuf_subscriptions_fields', [ $this, 'add_taxonomy_restriction_fields' ], 11 );
    }

    public function includes() {
        // class files to include pro elements
        require_once WPUF_INCLUDES . '/functions/user/edit-user.php';
        require_once WPUF_INCLUDES . '/Hooks/Form_Settings_Cleanup.php';
    }

    public function instantiate() {
        $this->edit_profile = new Edit_Profile();

        if ( is_admin() ) {

            /**
             * Conditionally load the Free loader
             *
             * @since 2.5.7
             *
             * @var bool
             */
            $load_free = apply_filters( 'wpuf_free_loader', true );

            if ( $load_free ) {
                new WPUF_Admin_Form_Free();
                new Form_Settings_Cleanup();
            }
        }
    }

    public function admin_menu_top() {
        $capability     = wpuf_admin_role();
        $reg_forms_hook = add_submenu_page(
            wpuf()->admin->menu->parent_slug,
            __( 'Registration Forms', 'wp-user-frontend' ),
            __( 'Registration Forms', 'wp-user-frontend' ),
            $capability,
            'wpuf-profile-forms',
            [ $this, 'admin_reg_forms_page' ]
        );
        $modules        = add_submenu_page( wpuf()->admin->menu->parent_slug, __( 'Modules', 'wp-user-frontend' ), __( 'Modules', 'wp-user-frontend' ), $capability, 'wpuf-modules', [ $this, 'modules_preview_page' ] );

        // add this menu to all menu hooks
        wpuf()->admin->menu->add_submenu_hooks( 'registration_forms', $reg_forms_hook );
        wpuf()->admin->menu->add_submenu_hooks( 'modules', $modules );

        add_action( "load-$reg_forms_hook", [ $this, 'reg_form_menu_action' ] );
        add_action( "load-$modules", [ $this, 'module_menu_action' ] );

        add_action( 'wpuf_load_module_page', [ $this, 'load_modules_scripts' ] );
        add_action( 'wpuf_load_module_page', [ $this, 'modules_page_contents' ] );
    }

    public function module_menu_action() {
        /**
         * Backdoor for calling the menu hook.
         * This hook won't get translated even the site language is changed
         */
        do_action( 'wpuf_load_module_page' );
    }

    /**
     * The action to run just after the menu is created
     *
     * @since 4.0.0
     *
     * @return void
     */
    public function reg_form_menu_action() {
        wp_enqueue_style( 'wpuf-admin' );
        wp_enqueue_style( 'wpuf-registration-forms' );
        wp_enqueue_script( 'wpuf-registration-forms' );
        /**
         * Backdoor for calling the menu hook.
         * This hook won't get translated even the site language is changed
         */
        do_action( 'wpuf_load_registration_forms' );
    }

    public function admin_menu() {
        if ( 'on' === wpuf_get_option( 'enable_payment', 'wpuf_payment', 'on' ) ) {
            $capability = wpuf_admin_role();
            add_submenu_page(
                wpuf()->admin->menu->parent_slug,
                __( 'Coupons', 'wp-user-frontend' ),
                __( 'Coupons', 'wp-user-frontend' ),
                $capability,
                'wpuf_coupon',
                [ $this, 'admin_coupon_page' ],
                4
            );
        }
    }

    public function admin_reg_forms_page() {
        $file_location = __DIR__ . '/templates/page-registration-form.php';

        wpuf_require_once( $file_location );
    }

    /**
     * The pro settings preview on the Free version
     *
     * @since 3.6.0
     *
     * @param $sections
     *
     * @return array
     */
    public function pro_sections( $sections ) {
        $crown_icon_path = WPUF_ROOT . '/assets/images/pro-badge.svg';
        $new_sections    = [
            [
                'id'             => 'wpuf_sms',
                'title'          => __( 'SMS', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-format-status',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'wpuf_social_api',
                'title'          => __( 'Social Login', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-share',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'user_directory',
                'title'          => __( 'User Directory', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-list-view',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'wpuf_payment_invoices',
                'title'          => __( 'Invoices', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-media-spreadsheet',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'wpuf_payment_tax',
                'title'          => __( 'Tax', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-media-text',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'wpuf_content_restriction',
                'title'          => __( 'Content Filtering', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-admin-network',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'id'             => 'wpuf_seo_settings',
                'title'          => __( 'SEO Settings', 'wp-user-frontend' ) . '<span class="pro-icon-title"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'icon'           => 'dashicons-search',
                'class'          => 'pro-preview-html',
                'is_pro_preview' => true,
            ]
        ];

        return array_merge( $sections, $new_sections );
    }

    /**
     * The pro settings preview on the Free version
     *
     * @since 3.6.0
     *
     * @param $settings_fields
     *
     * @return array
     */
    public function pro_settings( $settings_fields ) {
        $crown_icon_path = WPUF_ROOT . '/assets/images/pro-badge.svg';
        $settings_fields['wpuf_general'][] = [
            'name'           => 'comments_per_page',
            'label'          => __( 'Comments Per Page',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'Show how many comments per page in comments add-on', 'wp-user-frontend' ),
            'type'           => 'number',
            'default'        => '20',
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_general'][] = [
            'name'           => 'ipstack_key',
            'label'          => __( 'Ipstack API Key',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => sprintf(
            // translators: %1$s: opening anchor tag, %2$s: closing anchor tag
                __( '%1$sRegister here%2$s to get your free ipstack api key', 'wp-user-frontend' ),
                '<a target="_blank" href="https://ipstack.com/dashboard">', '</a>'
            ),
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_general'][] = [
            'name'           => 'gmap_api_key',
            'label'          => __( 'Google Map API',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( '<a target="_blank" href="https://developers.google.com/maps/documentation/javascript/get-api-key">API</a> key is needed to render Google Maps',
                                    'wp-user-frontend' ),
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_my_account'][] = [
            'name'           => 'show_edit_profile_menu',
            'label'          => __( 'Edit Profile',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'Allow user to update their profile information from the account page',
                                    'wp-user-frontend' ),
            'type'           => 'checkbox',
            'default'        => 'off',
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_my_account'][] = [
            'name'           => 'edit_profile_form',
            'label'          => __( 'Profile Form',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'User will use this form to update their information from the account page,',
                                    'wp-user-frontend' ),
            'type'           => 'select',
            'options'        => [ 'Default Form' ],
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_profile'][] = [
            'name'           => 'avatar_size',
            'label'          => __( 'Avatar Size',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'Avatar size to crop when upload using the registration/profile form.(e.g:100x100)',
                                    'wp-user-frontend' ),
            'type'           => 'text',
            'default'        => '100x100',
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_profile'][] = [
            'name'           => 'pending_user_message',
            'label'          => __( 'Pending User Message',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'Pending user will see this message when try to log in.', 'wp-user-frontend' ),
            'default'        => __( '<strong>ERROR:</strong> Your account has to be approved by an administrator before you can login.',
                                    'wp-user-frontend' ),
            'type'           => 'textarea',
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_profile'][] = [
            'name'           => 'denied_user_message',
            'label'          => __( 'Denied User Message',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'desc'           => __( 'Denied user will see this message when try to log in.', 'wp-user-frontend' ),
            'default'        => __( '<strong>ERROR:</strong> Your account has been denied by an administrator, please contact admin to approve your account.',
                                    'wp-user-frontend' ),
            'type'           => 'textarea',
            'class'          => 'pro-preview',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'subscription_setting',
            'label'          => __( '<span class="dashicons dashicons-money"></span> Subscription',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'subscription-setting pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'email_setting',
            'label'          => __( '<span class="dashicons dashicons-admin-generic"></span> Template Settings',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'email-setting pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'reset_email_setting',
            'label'          => __( '<span class="dashicons dashicons-unlock"></span> Reset Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'reset-email-setting pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'confirmation_email_setting',
            'label'          => __( '<span class="dashicons dashicons-email-alt"></span> Resend Confirmation Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'confirmation-email-setting pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'pending_user_email',
            'label'          => __( '<span class="dashicons dashicons-groups"></span> Pending User Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'pending-user-email pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'denied_user_email',
            'label'          => __( '<span class="dashicons dashicons-dismiss"></span> Denied User Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'denied-user-email pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'approved_user_email',
            'label'          => __( '<span class="dashicons dashicons-smiley"></span> Approved User Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'approved-user-email pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'account_activated_user_email',
            'label'          => __( '<span class="dashicons dashicons-smiley"></span> Account Activated Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'account-activated-user-email pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_mails'][] = [
            'name'           => 'approved_post_email',
            'label'          => __( '<span class="dashicons dashicons-saved"></span> Approved Post Email',
                                    'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
            'type'           => 'html',
            'class'          => 'approved-post-email pro-preview-html',
            'is_pro_preview' => true,
        ];
        $settings_fields['wpuf_sms'] = [
            [
                'name'           => 'clickatell_name',
                'label'          => __( 'Clickatell name', 'wp-user-frontend' ),
                'desc'           => __( 'Clickatell name', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'clickatell_password',
                'label'          => __( 'Clickatell Password', 'wp-user-frontend' ),
                'desc'           => __( 'Clickatell Password', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'clickatell_api',
                'label'          => __( 'Clickatell api', 'wp-user-frontend' ),
                'desc'           => __( 'Clickatell api', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'smsglobal_name',
                'label'          => __( 'SMSGlobal Name', 'wp-user-frontend' ),
                'desc'           => __( 'SMSGlobal Name', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'smsglobal_password',
                'label'          => __( 'SMSGlobal Passord', 'wp-user-frontend' ),
                'desc'           => __( 'SMSGlobal Passord', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'nexmo_api',
                'label'          => __( 'Nexmo API', 'wp-user-frontend' ),
                'desc'           => __( 'Nexmo API', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'nexmo_api_Secret',
                'label'          => __( 'Nexmo API Secret', 'wp-user-frontend' ),
                'desc'           => __( 'Nexmo API Secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'twillo_number',
                'label'          => __( 'Twillo From Number', 'wp-user-frontend' ),
                'desc'           => __( 'Twillo From Number', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'twillo_sid',
                'label'          => __( 'Twillo Account SID', 'wp-user-frontend' ),
                'desc'           => __( 'Twillo Account SID', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'twillo_token',
                'label'          => __( 'Twillo Authro Token', 'wp-user-frontend' ),
                'desc'           => __( 'Twillo Authro Token', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
        ];
        $settings_fields['wpuf_social_api'] = [
            'enabled'              => [
                'name'           => 'enabled',
                'label'          => __( 'Enable Social Login', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'desc'           => __( 'Enabling this will add Social Icons under registration form to allow users to login or register using Social Profiles',
                                        'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            'facebook_app_label'   => [
                'name'  => 'fb_app_label',
                'label' => __( 'Facebook App Settings', 'wp-user-frontend' ),
                'type'  => 'html',
                'desc'  => '<a target="_blank" href="https://developers.facebook.com/apps/">' . __( 'Create an App',
                                                                                                    'wp-user-frontend' ) . '</a>' . __( ' if you don\'t have one and fill App ID and App Secret below. ',
                                                                                                                                'wp-user-frontend' ),
            ],
            'facebook_app_url'     => [
                'name'           => 'fb_app_url',
                'label'          => __( 'Redirect URI', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => "<input class='regular-text' type='text' disabled value=''>",
                'is_pro_preview' => true,
            ],
            'facebook_app_id'      => [
                'name'           => 'fb_app_id',
                'label'          => __( 'App Id', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'facebook_app_secret'  => [
                'name'           => 'fb_app_secret',
                'label'          => __( 'App Secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'twitter_app_label'    => [
                'name'           => 'twitter_app_label',
                'label'          => __( 'Twitter App Settings', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => '<a target="_blank" href="https://apps.twitter.com/">' . __( 'Create an App',
                                                                                                 'wp-user-frontend' ) . '</a>' . __( ' if you don\'t have one and fill Consumer key and Consumer Secret below.',
                                                                                                                                     'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            'twitter_app_url'      => [
                'name'           => 'twitter_app_url',
                'label'          => __( 'Callback URL', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => "<input class='regular-text' type='text' disabled value=''>",
                'is_pro_preview' => true,
            ],
            'twitter_app_id'       => [
                'name'           => 'twitter_app_id',
                'label'          => __( 'Consumer Key', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'twitter_app_secret'   => [
                'name'           => 'twitter_app_secret',
                'label'          => __( 'Consumer Secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'google_app_label'     => [
                'name'           => 'google_app_label',
                'label'          => __( 'Google App Settings', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => '<a target="_blank" href="https://console.developers.google.com/project">' . __( 'Create an App',
                                                                                                                     'wp-user-frontend' ) . '</a>' . __( ' if you don\'t have one and fill Client ID and Client Secret below.',
                                                                                                                                                         'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            'google_app_url'       => [
                'name'           => 'google_app_url',
                'label'          => __( 'Redirect URI', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => "<input class='regular-text' type='text' disabled value=''>",
                'is_pro_preview' => true,
            ],
            'google_app_id'        => [
                'name'           => 'google_app_id',
                'label'          => __( 'Client ID', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'google_app_secret'    => [
                'name'           => 'google_app_secret',
                'label'          => __( 'Client secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'linkedin_app_label'   => [
                'name'           => 'linkedin_app_label',
                'label'          => __( 'Linkedin App Settings', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => '<a target="_blank" href="https://www.linkedin.com/developer/apps">' . __( 'Create an App',
                                                                                                               'wp-user-frontend' ) . '</a>' . __( ' if you don\'t have one and fill Client ID and Client Secret below.',
                                                                                                                                                   'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            'linkedin_app_url'     => [
                'name'           => 'linkedin_app_url',
                'label'          => __( 'Redirect URL', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => "<input class='regular-text' type='text' disabled value=''>",
                'is_pro_preview' => true,
            ],
            'linkedin_app_id'      => [
                'name'           => 'linkedin_app_id',
                'label'          => __( 'Client ID', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'linkedin_app_secret'  => [
                'name'           => 'linkedin_app_secret',
                'label'          => __( 'Client Secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'instagram_app_label'  => [
                'name'           => 'instagram_app_label',
                'label'          => __( 'Instagram App Settings', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => '<a target="_blank" href="https://www.instagram.com/developer/">' . __( 'Create an App',
                                                                                                            'wp-user-frontend' ) . '</a>' . __( ' if you don\'t have one and fill Client ID and Client Secret below.',
                                                                                                                                                'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            'instagram_app_url'    => [
                'name'           => 'instagram_app_url',
                'label'          => __( 'Redirect URI', 'wp-user-frontend' ),
                'type'           => 'html',
                'desc'           => "<input class='regular-text' type='text' disabled value=''>",
                'is_pro_preview' => true,
            ],
            'instagram_app_id'     => [
                'name'           => 'instagram_app_id',
                'label'          => __( 'Client ID', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            'instagram_app_secret' => [
                'name'           => 'instagram_app_secret',
                'label'          => __( 'Client Secret', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
        ];
        $settings_fields['user_directory'] = [
            [
                'name'           => 'pro_img_size',
                'label'          => __( 'Profile Gallery Image Size ', 'wp-user-frontend' ),
                'desc'           => __( 'Set the image size of picture gallery in frontend', 'wp-user-frontend' ),
                'type'           => 'select',
                'options'        => wpuf_get_image_sizes(),
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'avatar_size',
                'label'          => __( 'Avatar Size ', 'wp-user-frontend' ),
                'desc'           => __( 'Set the image size of profile picture in frontend', 'wp-user-frontend' ),
                'type'           => 'select',
                'options'        => [ '32' => '32 x 32', ],
                'is_pro_preview' => true,
            ],
            [
                'name'    => 'profile_header_template',
                'label'   => __( 'Profile Header Template', 'wp-user-frontend' ),
                'type'    => 'radio',
                'default' => 'layout',
                'options' => [
                    'layout'  => '<img class="profile-header" src="' . WPUF_ASSET_URI . '/images/profile-header-template-1.jpg' . '" />',
                    'layout1' => '<img class="profile-header" src="' . WPUF_ASSET_URI . '/images/profile-header-template-2.jpg' . '" />',
                    'layout2' => '<img class="profile-header" src="' . WPUF_ASSET_URI . '/images/profile-header-template-3.jpg' . '" />',
                ],
                'is_pro_preview' => true,
            ],
            [
                'name'    => 'user_listing_template',
                'label'   => __( 'User Listing Template', 'wp-user-frontend' ),
                'type'    => 'radio',
                'default' => 'list',
                'options' => [
                    'list'  => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-1.jpg' . '" />',
                    'list1' => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-2.jpg' . '" />',
                    'list2' => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-3.jpg' . '" />',
                    'list3' => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-4.jpg' . '" />',
                    'list4' => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-5.jpg' . '" />',
                    'list5' => '<img class="user-listing" src="' . WPUF_ASSET_URI . '/images/user-listing-template-6.jpg' . '" />',
                ],
                'is_pro_preview' => true,
            ],
        ];
        $settings_fields['wpuf_payment_invoices'] = [
            [
                'name'           => 'enable_invoices',
                'label'          => __( 'Enable Invoices', 'wp-user-frontend' ),
                'desc'           => __( 'Enable sending invoices for completed payments', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'on',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'show_invoices',
                'label'          => __( 'Show Invoices', 'wp-user-frontend' ),
                'desc'           => __( 'Show Invoices option where <code>[wpuf_account]</code> is located',
                                        'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'on',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_logo',
                'label'          => __( 'Set Invoice Logo', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the company Logo to be used in Invoice', 'wp-user-frontend' ),
                'type'           => 'file',
                'default'        => false,
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_color',
                'label'          => __( 'Set Invoice Color', 'wp-user-frontend' ),
                'desc'           => __( 'Set color code to be used in invoice', 'wp-user-frontend' ),
                'type'           => 'text',
                'default'        => '#e435226',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_from_address',
                'label'          => __( 'From Address', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the provider information of the Invoice. Note: use the <xmp class="wpuf-xmp-tag"><br></xmp> tag to enter line breaks.',
                                        'wp-user-frontend' ),
                'type'           => 'textarea',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_title',
                'label'          => __( 'Invoice Title', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the payment information title of the Invoice', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_paragraph',
                'label'          => __( 'Invoice Paragraph', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the payment information paragraph of the Invoice',
                                        'wp-user-frontend' ),
                'type'           => 'textarea',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_footernote',
                'label'          => __( 'Invoice Footer', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the footer of the Invoice', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_filename',
                'label'          => __( 'Invoice Filename Prefix', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the filename prefix of the Invoice', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_mail_sub',
                'label'          => __( 'Set Invoice Mail Subject', 'wp-user-frontend' ),
                'desc'           => __( 'This sets the mail subject of the Invoice', 'wp-user-frontend' ),
                'type'           => 'text',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'set_mail_body',
                'label'          => __( 'Set Invoice Mail Body', 'wp-user-frontend' ),
                'desc'           => sprintf(
                    /* translators: 1: line break, 2: strong tag open, 3: strong tag close, 4-9: code tags for invoice placeholders */
                    __( 'This sets the mail body of the Invoice.%1$s%2$sYou may use:%3$s %4$s %5$s %6$s %7$s %8$s %9$s', 'wp-user-frontend' ),
                    '<br>',
                    '<strong>',
                    '</strong>',
                    '<code>{username}</code>',
                    '<code>{user_email}</code>',
                    '<code>{display_name}</code>',
                    '<code>{invoice_id}</code>',
                    '<code>{payment_amount}</code>',
                    '<code>{payment_type}</code>',
                ),
                'type'           => 'wysiwyg',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'send_attachment',
                'label'          => __( 'Send Invoice as Attachment', 'wp-user-frontend' ),
                'desc'           => __( 'Enable to send the invoice PDF as an email attachment', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'on',
                'is_pro_preview' => true,
            ],
        ];
        $settings_fields['wpuf_payment_tax'] = [
            [
                'name'    => 'tax_help',
                'label'   => __( 'Need help?', 'wp-user-frontend' ),
                'desc'    => sprintf(
                // translators: %1$s: opening anchor tag, %2$s: closing anchor tag
                    __( 'Visit the %1$sTax setup documentation%2$s for guidance on how to setup tax.', 'wp-user-frontend' ), '<a href="https://wedevs.com/docs/wp-user-frontend-pro/settings/tax/" target="_blank">',
                    '</a>'
                ),
                'callback'    => 'wpuf_descriptive_text',
            ],
            [
                'name'           => 'enable_tax',
                'label'          => __( 'Enable Tax', 'wp-user-frontend' ),
                'desc'           => __( 'Enable tax on payments', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'on',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'wpuf_base_country_state',
                'label'          => '<strong>' . __( 'Base Country and State', 'wp-user-frontend' ) . '</strong>',
                'desc'           => __( 'Select your base country and state', 'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'wpuf_tax_rates',
                'label'          => '<strong>' . __( 'Tax Rates', 'wp-user-frontend' ) . '</strong>',
                'desc'           => __( 'Add tax rates for specific regions. Enter a percentage, such as 5 for 5%',
                                        'wp-user-frontend' ),
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'fallback_tax_rate',
                'label'          => '<strong>' . __( 'Fallback Tax Rate', 'wp-user-frontend' ) . '</strong>',
                'desc'           => __( 'Customers not in a specific rate will be charged this tax rate. Enter a percentage, such as 5 for 5%',
                                        'wp-user-frontend' ),
                'type'           => 'number',
                'default'        => 0,
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'prices_include_tax',
                'label'          => __( 'Show prices with tax', 'wp-user-frontend' ),
                'desc'           => __( 'If frontend prices will include tax or not', 'wp-user-frontend' ),
                'type'           => 'radio',
                'default'        => 'yes',
                'options'        => array(
                    'yes' => __( 'Show prices with tax', 'wp-user-frontend' ),
                    'no'  => __( 'Show prices without tax', 'wp-user-frontend' ),
                ),
                'is_pro_preview' => true,
            ],
        ];
        $settings_fields['wpuf_content_restriction'] = [
            [
                'name'           => 'enable_content_filtering',
                'label'          => __( 'Enable Content Filtering', 'wp-user-frontend' ),
                'desc'           => __( 'Enable Content Filtering in frontend', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'off',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'keyword_dictionary',
                'label'          => __( 'Keyword Dictionary', 'wp-user-frontend' ),
                'desc'           => __( 'Enter Keywords to Remove. Separate keywords with commas.', 'wp-user-frontend' ),
                'type'           => 'textarea',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'filter_contents',
                'label'          => __( 'Filter main content', 'wp-user-frontend' ),
                'desc'           => __( 'Choose which content to filter.', 'wp-user-frontend' ),
                'type'           => 'multicheck',
                'options'        => array(
                    'post_title'   => __( 'Post Titles', 'wp-user-frontend' ),
                    'post_content' => __( 'Post Content', 'wp-user-frontend' ),
                ),
                'default'        => array( 'post_content', 'post_title' ),
                'is_pro_preview' => true,
            ],
        ];

        // SEO Settings
        $settings_fields['wpuf_seo_settings'] = [
            [
                'name'  => 'user_directory_section',
                'label' => __( 'User Directory SEO Settings', 'wp-user-frontend' ),
                'type'  => 'html',
                'class' => 'pro-preview-html',
                'is_pro_preview' => true,
            ],
            [
                'name'           => 'avoid_indexing_profiles',
                'label'          => __( 'Avoid indexing profile by search engines', 'wp-user-frontend' ) . '<span class="pro-icon"> ' . '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' . '</span>',
                'desc'           => __( 'Enable this to add a noindex meta tag to all user profile pages across directories. Useful if you want some profiles hidden from search engines.', 'wp-user-frontend' ),
                'type'           => 'checkbox',
                'default'        => 'off',
                'class'          => 'pro-preview',
                'is_pro_preview' => true,
            ],
        ];

        return $settings_fields;
    }

    /**
     * Add meta boxes to post form builder
     *
     * @return void
     */
    public function add_meta_box_post() {
        add_meta_box( 'wpuf-metabox-fields-banner', __( 'Upgrade to Pro', 'wp-user-frontend' ), [$this, 'show_banner_metabox'], 'wpuf_forms', 'side', 'core' );
    }

    public function show_banner_metabox() {
        printf( 'Upgrade to in <a href="%s" target="_blank">Pro Version</a> to get more fields and features.',esc_url( self::get_pro_url() )  );
    }

    public function wpuf_form_buttons_custom_runner() {
        //add formbuilder widget pro buttons
        Form_Element::add_form_custom_buttons();
    }

    public function wpuf_form_buttons_other_runner() {
        Form_Element::add_form_other_buttons();
    }

    public function wpuf_form_post_expiration_runner() {
        Form_Element::render_form_expiration_tab();
    }

    public function form_setting_runner( $form_settings, $post ) {
        Form_Element::add_form_settings_content( $form_settings, $post );
    }

    public function post_notification_hook_runner() {
        Form_Element::add_post_notification_content();
    }

    public function wpuf_edit_form_area_profile_runner() {
        Form_Element::render_registration_form();
    }

    public function registration_setting_runner() {
        Form_Element::render_registration_settings();
    }

    public function wpuf_check_post_type_runner( $post, $update ) {
        Form_Element::check_post_type( $post, $update );
    }

    public function wpuf_form_custom_taxonomies_runner() {
        Form_Element::render_custom_taxonomies_element();
    }

    public function wpuf_conditional_field_render_hook_runner( $field_id, $con_fields, $obj ) {
        Form_Element::render_conditional_field( $field_id, $con_fields, $obj );
    }

    //subscription
    public function wpuf_admin_subscription_detail_runner( $sub_meta, $hidden_recurring_class, $hidden_trial_class, $obj ) {
        Subscription_Element::add_subscription_element( $sub_meta, $hidden_recurring_class, $hidden_trial_class, $obj );
    }

    //coupon
    public function wpuf_coupon_settings_form_runner( $obj ) {
        Coupon_Elements::add_coupon_elements( $obj );
    }

    public function wpuf_check_save_permission_runner( $post, $update ) {
        Coupon_Elements::check_saving_capability( $post, $update );
    }

    /**
     * Post form templates
     *
     * @since 2.4
     *
     * @param array $integrations
     *
     * @return array
     */
    public function post_form_templates( $integrations ) {
        $integrations['post_form_template_woocommerce']     = new Post_Form_Template_WooCommerce();

        // Enable Events Calendar template with new integration
        if ( class_exists( 'Tribe__Events__Main' ) ) {
            $integrations['post_form_template_events_calendar'] = new \WeDevs\Wpuf\Integrations\Events_Calendar\Templates\Event_Form_Template();
        }

        return $integrations;
    }

    /**
     * Pro form templates for previewing
     *
     * @since 3.6.0
     *
     * @param array $integrations
     *
     * @return array
     */
    public function pro_form_previews( $integrations ) {
        $integrations['WPUF_Pro_Form_Preview_EDD'] = new Pro_Form_Preview_EDD();
        $integrations['WPUF_Pro_Form_Preview_Press_Release'] = new Pro_Form_Preview_Press_Release();
        $integrations['WPUF_Pro_Form_Preview_Professional_Video'] = new Pro_Form_Preview_Professional_Video();
        $integrations['WPUF_Pro_Form_Preview_Artwork'] = new Pro_Form_Preview_Artwork();

        return $integrations;
    }

    /**
     * A preview page to show the Pro Modules of WPUF
     *
     * @since 3.6.0
     *
     * @return void
     */
    public function modules_preview_page() {
        $modules = $this->pro_modules_info();

        $diamond_icon = file_exists( WPUF_ROOT . '/assets/images/diamond.svg' ) ? file_get_contents( WPUF_ROOT . '/assets/images/diamond.svg' ) : '';
        $check_icon   = file_exists( WPUF_ROOT . '/assets/images/check.svg' ) ? file_get_contents( WPUF_ROOT . '/assets/images/check.svg' ) : '';
        $crown_icon   = file_exists( WPUF_ROOT . '/assets/images/pro-badge.svg' ) ? file_get_contents( WPUF_ROOT . '/assets/images/pro-badge.svg' ) : '';
        $close_icon   = file_exists( WPUF_ROOT . '/assets/images/x.svg' ) ? file_get_contents( WPUF_ROOT . '/assets/images/x.svg' ) : '';
        $suffix       = '.min';

        ?>
        <div id="wpuf-upgrade-popup" class="wpuf-popup-window">
            <div class="modal-window">
                <div class="modal-window-inner">
                    <div class="content-area">
                        <div class="popup-close-button">
                            <?php echo wp_kses( $close_icon, array( 'svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,] , 'path' => ['d' => true, 'fill' => true,] ) ); ?>
                        </div>
                        <div class="popup-diamond">
                            <?php echo wp_kses( $diamond_icon , array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'stroke' => true, 'stroke-linecap' => true,] ) ); ?>
                        </div>
                        <div class="wpuf-popup-header">
                            <h2 class="font-orange header-one">Upgrade to</h2>
                            <h2 class="header-two">WP User Frontend <span class="font-bold">Pro</span></h2>
                            <h2 class="header-three font-gray">to experience even more powerful<span class="line-break"></span>features 🎉</h2>
                        </div>
                        <div class="wpuf-popup-list-area">
                            <div class="single-checklist">
                                <div class="check-icon">
                                    <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?>
                                </div>
                                <div class="check-list">
                                    <p>Get custom <span class="bold font-black">Post Type</span> and <span class="bold font-black">Taxonomy</span> support with
                                        <span class="line-break"></span> subscription-based <span class="bold font-black">restrictions</span> for post <span class="line-break"></span> submission.</p>
                                </div>
                            </div>
                            <div class="single-checklist">
                                <div class="check-icon">
                                    <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?>
                                </div>
                                <div class="check-list">
                                    <p>Enable <span class="bold font-black">conditional logic</span> and <span class="bold font-black">multi-step</span><span class="line-break"></span> functionalities on your forms.</p>
                                </div>
                            </div>
                            <div class="single-checklist">
                                <div class="check-icon">
                                    <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?>
                                </div>
                                <div class="check-list">
                                    <p>Show or hide <span class="bold font-black">menus, pages,</span> and <span class="bold font-black">content</span> based on<span class="line-break"></span> user roles or login status of a user.</p>
                                </div>
                            </div>
                            <div class="single-checklist">
                                <div class="check-icon">
                                <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?>
                                </div>
                                <div class="check-list">
                                    <p><span class="bold font-black">20+ Premium Modules</span> (Social Login, User<span class="line-break"></span> Directory, User Activity, Stripe, MailChimp, Private<span class="line-break"></span> Messaging, Zapier, & more)</p>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo esc_url( self::get_upgrade_to_pro_popup_url() ); ?>"
                           target="_blank"
                           class="wpuf-button button-upgrade-to-pro">
                            <?php esc_html_e( 'Upgrade to PRO', 'wp-user-frontend' ); ?>
                            <?php printf( '<span class="pro-icon"> %s</span>', wp_kses( $crown_icon, array('svg' => [ 'xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true ], 'path' => [ 'd' => true, 'fill' => true ], 'circle' => [ 'cx' => true, 'cy' => true, 'r' => true ], ) ) );  ?>
                        </a>
                    </div>
                    <div class="slider-area">
                        <div class="wpuf-slider slider-indicators-outside slider-indicators-round slider-nav-mousedrag slider-nav-autoplay slider-nav-autopause"" id="wpuf-slider">
                        <div class="swiffy-slider">
                            <ul class="slider-container">
                                <li><img src="<?php echo esc_url( WPUF_ASSET_URI . '/images/woocommerce-form-template.png' ); ?>"></li>
                                <li><img src="<?php echo esc_url( WPUF_ASSET_URI . '/images/conditional-form.png' ); ?>"></li>
                                <li><img src="<?php echo esc_url( WPUF_ASSET_URI . '/images/content-restriction.png' ); ?>"></li>
                                <li><img src="<?php echo esc_url( WPUF_ASSET_URI . '/images/modules.png' ); ?>"></li>
                            </ul>

                            <div class="slider-indicators">
                                <button class="active"></button>
                                <button></button>
                                <button></button>
                                <button></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="footer-feature">
                    <p>
                        <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?> Industry leading 24x7 support
                    </p>
                    <p>
                        <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?> 14 days no questions asked refund policy
                    </p>
                    <p>
                        <?php echo wp_kses( $check_icon, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, 'fill-rule' => true, 'clip-rule' => true,] ) ); ?> Secured payment
                    </p>

                </div>
            </div>
        </div>
        </div>
        <div class="wrap wpuf-modules">
            <h1><?php esc_attr_e( 'Modules', 'wp-user-frontend' ); ?></h1>
            <div class="wp-list-table widefat wpuf-modules">
                <?php if ( $modules ) {
                    foreach ( $modules as $slug => $module ) {
                        ?>
                        <div class="plugin-card">
                            <div class="plugin-card-top">
                                <div class="name column-name">
                                    <h3>
                                        <span class="plugin-name"><a href="<?php echo esc_url( $module['plugin_uri'] ); ?>" target="_blank"><?php echo esc_html( $module['name'] ); ?></a></span>
                                        <a href="<?php echo esc_url( $module['plugin_uri'] ); ?>" target="_blank"><img class="plugin-icon" src="<?php echo esc_url( WPUF_ASSET_URI . '/images/modules/' . $module['thumbnail'] ); ?>" alt="" /></a>
                                    </h3>
                                </div>

                                <div class="action-links">
                                    <ul class="plugin-action-buttons">
                                        <li data-module="<?php echo esc_attr( $slug ); ?>">
                                            <label class="wpuf-toggle-switch">
                                                <input type="checkbox" name="module_toggle" class="wpuf-toggle-module" disabled>
                                                <span class="slider round"></span>
                                            </label>
                                        </li>
                                    </ul>
                                    <div class="wpuf-doc-link" ><a href="<?php echo esc_url( $module['plugin_uri'] ); ?>" target="_blank">Documentation</a></div>
                                </div>

                                <div class="desc column-description">
                                    <p>
                                        <?php echo esc_html( $module['description'] ); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
            <div class="form-create-overlay">
                <a href="https://wedevs.com/wp-user-frontend-pro/pricing/?utm_source=freeplugin&amp;utm_medium=prompt&amp;utm_term=wpuf_free_plugin&amp;utm_content=textlink&amp;utm_campaign=pro_prompt" target="_blank">
                    <img src="<?php echo esc_url( WPUF_ASSET_URI . '/images/pro-badge.svg' ); ?>" alt="pro icon" class="wpuf-module-pro-badge">
                </a>
            </div>
        </div>
        <?php
    }

    /**
     * Load required style and js for Modules page
     *
     * @since 3.6.0
     *
     * @return void
     */
    public function load_modules_scripts() {
        wp_enqueue_style( 'wpuf-admin' );
        wp_enqueue_style( 'wpuf-module' );
        wp_enqueue_style( 'wpuf-swiffy-slider' );
        wp_enqueue_script( 'wpuf-admin' );
        wp_enqueue_script( 'wpuf-subscriptions' );
        wp_enqueue_script( 'wpuf-swiffy-slider' );
        wp_enqueue_script( 'wpuf-swiffy-slider-extensions' );
        wp_enqueue_script( 'wpuf-module' );
    }

    /**
     * Get the info of the pro modules as an array
     *
     * @since 3.6.0
     *
     * @return string[][]
     */
    public function pro_modules_info() {
        return [
            'campaign-monitor/campaign-monitor.php' => [
                'name'        => 'Campaign Monitor',
                'description' => 'Subscribe a contact to Campaign Monitor when a form is submited',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/campaign-monitor/',
                'thumbnail'   => 'campaign_monitor.png',
            ],
            'social-login/wpuf-social-login.php' => [
                'name'        => 'Social Login & Registration',
                'description' => 'Add Social Login and registration feature in WP User Frontend',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/social-login-registration/',
                'thumbnail'   => 'Social-Media-Login.png',
            ],
            'bp-profile/wpuf-bp.php' => [
                'name'        => 'BuddyPress Profile',
                'description' => 'Register and upgrade user profiles and sync data with BuddyPress',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/buddypress-profile-integration/',
                'thumbnail'   => 'wpuf-buddypress.png',
            ],
            'comments/comments.php' => [
                'name'        => 'Comments Manager',
                'description' => 'Handle comments in frontend',
                'plugin_uri'  => 'https://wedevs.com/wp-user-frontend-pro/modules/comments-manager/',
                'thumbnail'   => 'wpuf-comment.png',
            ],
            'mailpoet/wpuf-mailpoet.php' => [
                'name'        => 'Mailpoet',
                'description' => 'Add subscribers to mailpoet mailing list when they registers via WP User Frontend Pro',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/mailpoet/',
                'thumbnail'   => 'wpuf-mailpoet.png',
            ],
            'pmpro/wpuf-pmpro.php' => [
                'name'        => 'Paid Membership Pro Integration',
                'description' => 'Membership Integration of WP User Frontend PRO with Paid Membership Pro',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/install-and-configure-pmpro-add-on-for-wpuf/',
                'thumbnail'   => 'wpuf-pmpro.png',
            ],
            'sms-notification/wpuf-sms.php' => [
                'name'        => 'SMS Notification',
                'description' => 'SMS notification for post',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/sms-notification/',
                'thumbnail'   => 'wpuf-sms.png',
            ],
            'email-templates/email-templates.php' => [
                'name'        => 'HTML Email Templates',
                'description' => 'Send Email Notifications with HTML Template',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/html-email-templates/',
                'thumbnail'   => 'email-templates.png',
            ],
            'getresponse/getresponse.php' => [
                'name'        => 'GetResponse',
                'description' => 'Subscribe a contact to GetResponse when a form is submited',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/get-response/',
                'thumbnail'   => 'getresponse.png',
            ],
            'zapier/zapier.php' => [
                'name'        => 'Zapier',
                'description' => 'Subscribe a contact to Zapier when a form is submited',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/zapier/',
                'thumbnail'   => 'zapier.png',
            ],
            'convertkit/convertkit.php' => [
                'name'        => 'ConvertKit',
                'description' => 'Subscribe a contact to ConvertKit when a form is submited',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/convertkit/',
                'thumbnail'   => 'convertkit.png',
            ],
            'private-message/private-message.php' => [
                'name'        => 'Private Message',
                'description' => 'User to user message from Frontend',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/private-messaging/',
                'thumbnail'   => 'message.gif',
            ],
            'user-analytics/wpuf-user-analytics.php' => [
                'name'        => 'User Analytics',
                'description' => 'Show user tracking info during post and registration from Frontend',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/user-analytics/',
                'thumbnail'   => 'wpuf-ua.png',
            ],
            'mailchimp/wpuf-mailchimp.php' => [
                'name'        => 'Mailchimp',
                'description' => 'Add subscribers to Mailchimp mailing list when they registers via WP User Frontend Pro',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/add-users-to-mailchimp-subscribers-list-upon-registration-from-frontend/',
                'thumbnail'   => 'wpuf-mailchimp.png',
            ],
            'user-activity/user_activity.php' => [
                'name'        => 'User Activity',
                'description' => 'Handle user activity in frontend',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/user-activity/',
                'thumbnail'   => 'wpuf-activity.png',
            ],
            'report/wpuf-report.php' => [
                'name'        => 'Reports',
                'description' => 'Show various reports in WP User Frontend menu',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/reports/',
                'thumbnail'   => 'reports.png',
            ],
            'qr-code-field/wpuf-qr-code.php' => [
                'name'        => 'QR Code',
                'description' => 'Post Qr code generator plugin',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/qr-code/',
                'thumbnail'   => 'wpuf-qr.png',
            ],
            'mailpoet3/wpuf-mailpoet-3.php' => [
                'name'        => 'Mailpoet 3',
                'description' => 'Add subscribers to mailpoet mailing list when they registers via WP User Frontend Pro',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/mailpoet3/',
                'thumbnail'   => 'mailpoet3.png',
            ],
            'user-directory/userlisting.php' => [
                'name'        => 'User Directory',
                'description' => 'Handle user listing and user profile in frontend',
                'plugin_uri'  => 'https://wedevs.com/products/plugins/wp-user-frontend-pro/user-listing-profile/',
                'thumbnail'   => 'wpuf-ul.png',
            ],
            'stripe/wpuf-stripe.php' => [
                'name'        => 'Stripe Payment',
                'description' => 'Stripe payment gateway for WP User Frontend',
                'plugin_uri'  => 'https://wedevs.com/docs/wp-user-frontend-pro/modules/stripe/',
                'thumbnail'   => 'wpuf-stripe.png',
            ],
            'seo/wpuf-seo.php' => [
                'name'        => 'SEO Settings',
                'description' => 'SEO settings for user directory and profiles',
                'plugin_uri'  => 'https://wedevs.com/products/plugins/wp-user-frontend-pro/seo-settings/',
                'thumbnail'   => 'wpuf-seo.png',
            ],
        ];
    }

    /**
     * The content of the module page
     *
     * @since 3.6.0
     *
     * @param array $modules
     *
     * @return void
     */
    public function modules_page_contents() {

    }

    /**
     * payment gateways for previewing in the Free version
     *
     * @since 3.6.0
     *
     * @param $gateways
     *
     * @return void
     */
    public function wpuf_payment_gateways( $gateways ) {
        $crown_icon = WPUF_ROOT . '/assets/images/pro-badge.svg';
        $crown      = '';

        if ( file_exists( $crown_icon ) ) {
            $crown = sprintf( '<span class="pro-icon-title"> %s</span>', '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' );
        }

        $gateways['stripe'] = [
            'admin_label'    => sprintf(
                // translators: %s is the crown symbol
                __( 'Credit Card %s', 'wp-user-frontend' ),
                $crown
            ),
            'checkout_label' => __( 'Credit Card', 'wp-user-frontend' ),
            'label_class'    => 'pro-preview',
        ];

        return $gateways;
    }

    /**
     * The subscription tabs from User Frontend > Subscription > Add/Edit Subscription
     *
     * @since 3.6.0
     *
     * @return void
     */
    public function subscription_tabs() {
        $crown_icon = WPUF_ROOT . '/assets/images/pro-badge.svg';
        $crown      = '';

        if ( file_exists( $crown_icon ) ) {
            $crown = sprintf( '<span class="pro-icon-title"> %s</span>', '<img src="' . WPUF_ASSET_URI . '/images/pro-badge.svg" alt="PRO">' );
        }

        echo '<li><a href="#taxonomy-restriction"><span class="dashicons dashicons-image-filter"></span> ' . esc_html(__( 'Taxonomy Restriction ', 'wp-user-frontend' ) ) . wp_kses($crown, array('svg' => ['xmlns' => true, 'width' => true, 'height' => true, 'viewBox' => true, 'fill' => true,], 'path' => ['d' => true, 'fill' => true, ] ) ) . '</a></li>';
    }

    /**
     * The subscription tab contents from User Frontend > Subscription > Add/Edit Subscription
     *
     * @since 3.6.0
     *
     * @return void
     */
    public function subscription_tab_contents() {
        $allowed_tax_id_arr = get_post_meta( get_the_ID(), '_sub_allowed_term_ids', true );
        if ( ! $allowed_tax_id_arr ) {
            $allowed_tax_id_arr = [];
        }
        ?>
        <section id="taxonomy-restriction" class="pro-preview-html">
            <table class='form-table' method='post'>
                <tr><?php esc_html_e( 'Choose the taxonomy terms you want to enable for this pack:', 'wp-user-frontend' ); ?></tr>
                <tr>
                    <td>
                        <?php
                        $cts = get_taxonomies( [ '_builtin' => true ], 'objects' );
                        ?>
                        <?php
                        foreach ( $cts as $ct ) {
                            if ( is_taxonomy_hierarchical( $ct->name ) ) {
                                ?>
                                <div class="metabox-holder" style="float:left; padding:5px;">
                                    <div class="postbox">
                                        <h3 class="handle"><span><?php echo esc_html( $ct->label ); ?></span></h3>
                                        <div class="inside" style="padding:0 10px;">
                                            <div class="taxonomydiv">
                                                <div class="tabs-panel" style="height: 200px; overflow-y:auto">
                                                    <?php
                                                    $tax_terms = get_terms(
                                                        [
                                                            'taxonomy' => $ct->name,
                                                            'hide_empty' => false,
                                                        ]
                                                    );
                                                    foreach ( $tax_terms as $tax_term ) {
                                                        $selected[] = $tax_term;
                                                        ?>
                                                        <ul class="categorychecklist form-no-clear">
                                                            <input type="checkbox" class="tax-term-class" name="allowed-term[]" value="<?php echo esc_attr( $tax_term->term_id ); ?>" <?php echo in_array( $tax_term->term_id, $allowed_tax_id_arr, true ) ? ' checked="checked"' : ''; ?> name="<?php echo esc_attr( $tax_term->name ); ?>" disabled> <?php echo esc_html( $tax_term->name ); ?>
                                                        </ul>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <p style="padding-left:10px;">
                                                <strong><?php echo count( $selected ); ?></strong> <?php echo ( count( $selected ) > 1 || 0 === count( $selected ) ) ? 'categories' : 'category'; ?> total
                                                <span class="list-controls" style="float:right; margin-top: 0;">
                                                <input type="checkbox" class="select-all" disabled> Select All
                                            </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </td>

                    <?php
                    $cts = get_taxonomies( [ '_builtin' => false ], 'objects' );
                    ?>
                    <?php
                    foreach ( $cts as $ct ) {
                        if ( is_taxonomy_hierarchical( $ct->name ) ) {
                            $selected = array();
                            ?>
                            <td>
                                <div class="metabox-holder" style="float:left; padding:5px;">
                                    <div class="postbox">
                                        <h3 class="handle"><span><?php echo esc_html( $ct->label ); ?></span></h3>
                                        <div class="inside" style="padding:0 10px;">
                                            <div class="taxonomydiv">
                                                <div class="tabs-panel" style="height: 200px; overflow-y:auto">
                                                    <?php
                                                    $tax_terms = get_terms(
                                                        [
                                                            'taxonomy'   => $ct->name,
                                                            'hide_empty' => false,
                                                        ]
                                                    );
                                                    foreach ( $tax_terms as $tax_term ) {
                                                        $selected[] = $tax_term;
                                                        ?>
                                                        <ul class="categorychecklist form-no-clear">
                                                            <input
                                                                type="checkbox"
                                                                class="tax-term-class"
                                                                name="allowed-term[]"
                                                                value="<?php echo esc_attr( $tax_term->term_id ); ?>" <?php echo in_array( $tax_term->term_id, $allowed_tax_id_arr, true ) ? ' checked="checked"' : ''; ?>
                                                                name="<?php echo esc_attr( $tax_term->name ); ?>"
                                                                disabled> <?php echo esc_html( $tax_term->name ); ?>
                                                        </ul>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <p style="padding-left:10px;">
                                                <strong><?php echo count( $selected ); ?></strong> <?php echo ( count( $selected ) > 1 || 0 === count( $selected ) ) ? 'categories' : 'category'; ?> total
                                                <span class="list-controls" style="float:right; margin-top: 0;">
                                                <input type="checkbox" class="select-all" disabled> Select All
                                            </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <?php
                        }
                    }
                    ?>
                </tr>
            </table>
            <?php
                echo wp_kses_post( wpuf_get_pro_preview_html() );
            ?>
        </section>

        <?php
    }

    public function admin_coupon_page() {
        ?>
        <h2><?php esc_html_e( 'Coupons', 'wp-user-frontend' ); ?></h2>

        <div class="wpuf-notice" style="padding: 20px; background: #fff; border: 1px solid #ddd;">
            <p>
                <?php esc_html_e( 'Use Coupon codes for subscription for discounts.', 'wp-user-frontend' ); ?>
            </p>

            <p>
                <?php esc_html_e( 'This feature is only available in the Pro Version.', 'wp-user-frontend' ); ?>
            </p>

            <p>
                <a href="<?php echo esc_url( Pro_Prompt::get_pro_url() ); ?>" target="_blank" class="button-primary"><?php esc_html_e( 'Upgrade to Pro Version', 'wp-user-frontend' ); ?></a>
                <a href="https://wedevs.com/docs/wp-user-frontend-pro/subscription-payment/coupons/" target="_blank" class="button"><?php esc_html_e( 'Learn more about Coupons', 'wp-user-frontend' ); ?></a>
            </p>
        </div>

        <?php
    }

    /**
     * Add taxonomy restriction options
     *
     * @since 4.0.11
     *
     * @param array $sections
     *
     * @return array
     */
    public function add_taxonomy_restriction_section( $sections ) {
        $sections['advanced_configuration'][] = [
            'id'        => 'taxonomy_restriction',
            'label'     => __( 'Taxonomy Access', 'wp-user-frontend' ),
            'sub_label' => __( '(Control user access to specific taxonomies)', 'wp-user-frontend' ),
            'is_pro'    => true,
        ];

        return $sections;
    }

    /**
     * Add taxonomy restriction fields
     *
     * @since 4.0.11
     *
     * @param array $fields
     *
     * @return array
     */
    public function add_taxonomy_restriction_fields( $fields ) {
        $cts = get_taxonomies( [], 'objects' );

        foreach ( $cts as $ct ) {
            if ( ! is_taxonomy_hierarchical( $ct->name ) ) {
                continue;
            }

            $fields['advanced_configuration']['taxonomy_restriction'][ $ct->name ] = [
                'id'          => $ct->name,
                'name'        => $ct->name,
                'type'        => 'multi-select',
                'label'       => $ct->label,
                'term_fields' => [],
                'is_pro'      => true,
            ];
        }

        return $fields;
    }

    /**
     * Add general settings pro fields preview
     *
     * @since 4.1.0
     *
     * @param array $general_settings
     *
     * @return array
     */
    public function form_settings_preview_general( $general_settings ) {
        $general_settings['section']['before_post_settings']['pro_preview']['fields'] = [
            'enable_multistep'           => [
                'label'     => __( 'Enable Multi-Step', 'wp-user-frontend' ),
                'type'      => 'toggle',
                'value'     => 'on',
                'help_text' => __(
                    'If checked, form will be displayed in frontend in multiple steps.', 'wp-user-frontend'
                ),
                'link'      => esc_url_raw(
                    'https://wedevs.com/docs/wp-user-frontend-pro/posting-forms/how-to-add-multi-step-form/'
                ),
            ],
            'multistep_progressbar_type' => [
                'label'     => __( 'Multistep Progressbar Type', 'wp-user-frontend' ),
                'type'      => 'select',
                'help_text' => __( 'Choose how you want the progressbar', 'wp-user-frontend' ),
                'options'   => [
                    'progressive'  => __( 'Progressbar', 'wp-user-frontend' ),
                    'step_by_step' => __( 'Step by Step', 'wp-user-frontend' ),
                ],
            ],
            'ms_ac_txt_color'            => [
                'label'     => __( 'Active Text Color', 'wp-user-frontend' ),
                'type'      => 'color-picker',
                'help_text' => __( 'Text color for active step.', 'wp-user-frontend' ),
                'default'   => '#fff',
            ],
            'ms_active_bgcolor'          => [
                'label'     => __( 'Active Background Color', 'wp-user-frontend' ),
                'type'      => 'color-picker',
                'help_text' => __( 'Background color for progressbar or active step.', 'wp-user-frontend' ),
                'default'   => '#00a0d2',
            ],
            'ms_bgcolor'                 => [
                'label'     => __( 'Background Color', 'wp-user-frontend' ),
                'type'      => 'color-picker',
                'help_text' => __( 'Background color for normal steps.', 'wp-user-frontend' ),
                'default'   => '#E4E4E4',
            ],
        ];

        return $general_settings;
    }

    /**
     * Add notification settings pro fields preview
     *
     * @since 4.1.0
     *
     * @param array $notification_settings
     *
     * @return array
     */
    public function form_settings_preview_notification( $notification_settings ) {
        $notification_settings['section']['update_post']['pro_preview']['fields'] = [
            'notification_edit'         => [
                'label' => __( 'Enable Update Post Notification', 'wp-user-frontend' ),
                'type'  => 'toggle',
                'value' => 'on',
            ],
            'notification_edit_to'      => [
                'label' => __( 'To', 'wp-user-frontend' ),
                'type'  => 'text',
                'value' => get_option( 'admin_email' ),
            ],
            'notification_edit_subject' => [
                'label' => __( 'Subject', 'wp-user-frontend' ),
                'type'  => 'text',
                'value' => __( 'A post has been edited', 'wp-user-frontend' ),
            ],
            'notification_edit_body'    => [
                'label'     => __( 'Email Body', 'wp-user-frontend' ),
                'type'      => 'textarea',
                'value'     => "Hi Admin, \r\n\r\nThe post \"{post_title}\" has been updated. \r\n\r\nHere is the details: \r\nPost Title: {post_title} \r\nContent: {post_content} \r\nAuthor: {author} \r\nPost URL: {permalink} \r\nEdit URL: {editlink}",
                'long_help' => '<h4 class="wpuf-m-0">You may use in to, subject & message:</h4>
                                         <p class="wpuf-leading-8">
                                         <span data-clipboard-text="{post_title}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{post_title}</span>
                                         <span data-clipboard-text="{post_content}" class="wpuf-post-content wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{post_content}</span>
                                         <span data-clipboard-text="{post_excerpt}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{post_excerpt}</span>
                                         <span data-clipboard-text="{tags}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{tags}</span>
                                         <span data-clipboard-text="{category}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{category}</span>
                                         <span data-clipboard-text="{author}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{author}</span>
                                         <span data-clipboard-text="{author_email}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{author_email}</span>
                                         <span data-clipboard-text="{author_bio}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{author_bio}</span>
                                         <span data-clipboard-text="{sitename}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{sitename}</span>
                                         <span data-clipboard-text="{siteurl}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{siteurl}</span>
                                         <span data-clipboard-text="{permalink}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{permalink}</span>
                                         <span data-clipboard-text="{editlink}" class="wpuf-pill-green hover:wpuf-cursor-pointer wpuf-template-text">{editlink}</span>
                                         <span class="wpuf-pill-green">{custom_{NAME_OF_CUSTOM_FIELD}}</span>
                                         e.g: <span class="wpuf-pill-green">{custom_website_url}</span> for <i>website_url</i> meta field</p>',
            ],
        ];

        return $notification_settings;
    }

    /**
     * Add advance settings pro fields preview
     *
     * @since 4.1.0
     *
     * @param array $advanced_settings
     *
     * @return array
     */
    public function form_settings_preview_advanced( $advanced_settings ) {
        $advanced_settings['pro_preview']['fields'] = [
            'conditional_logic' => [
                'label' => __( 'Conditional Logic on Submit', 'wp-user-frontend' ),
                'type'  => 'toggle',
                'value' => 'off',
            ],
        ];

        return $advanced_settings;
    }

    /**
     * Add notification settings pro fields preview
     *
     * @since 4.1.0
     *
     * @param array $display_settings
     *
     * @return array
     */
    public function form_settings_preview_display( $display_settings ) {
        $display_settings['section']['custom_form_style']['pro_preview']['fields'] = [
            'form_layout'         => [
                'label'     => __( 'Choose Form Style', 'wp-user-frontend' ),
                'type'      => 'pic-radio',
                'help_text' => __(
                    'If selected a form template, it will try to execute that integration options when new post created and updated.',
                    'wp-user-frontend'
                ),
                'options'   => [
                    'layout1' => [
                        'label' => __( 'Post Form', 'wp-user-frontend' ),
                        'image' => WPUF_ASSET_URI . '/images/forms/layout1.png',
                    ],
                    'layout2' => [
                        'label' => __( 'Post Form', 'wp-user-frontend' ),
                        'image' => WPUF_ASSET_URI . '/images/forms/layout2.png',
                    ],
                    'layout3' => [
                        'label' => __( 'Post Form', 'wp-user-frontend' ),
                        'image' => WPUF_ASSET_URI . '/images/forms/layout3.png',
                    ],
                    'layout4' => [
                        'label' => __( 'Post Form', 'wp-user-frontend' ),
                        'image' => WPUF_ASSET_URI . '/images/forms/layout4.png',
                    ],
                    'layout5' => [
                        'label' => __( 'Post Form', 'wp-user-frontend' ),
                        'image' => WPUF_ASSET_URI . '/images/forms/layout5.png',
                    ],
                ],
            ],
        ];

        return $display_settings;
    }

    /**
     * Add post expiration settings pro fields preview
     *
     * @since 4.1.0
     *
     * @param array $expiration_settings
     *
     * @return array
     */
    public function form_settings_preview_post_expiration( $expiration_settings ) {
        $expiration_settings['pro_preview']['fields'] = [
            'enable_post_expiration'    => [
                'label' => __( 'Enable Post Expiration', 'wp-user-frontend' ),
                'type'  => 'toggle',
                'value' => 'on',
            ],
            'inline_fields'             => [
                'fields' => [
                    'expiration_time_value' => [
                        'label' => __( 'Post Expiration Time', 'wp-user-frontend' ),
                        'type'  => 'number',
                        'value' => '7',
                    ],
                    'expiration_time_type'  => [
                        'label'   => __( 'Duration Type', 'wp-user-frontend' ),
                        'type'    => 'select',
                        'options' => [
                            'day'   => __( 'Day(s)', 'wp-user-frontend' ),
                            'week'  => __( 'Week(s)', 'wp-user-frontend' ),
                            'month' => __( 'Month(s)', 'wp-user-frontend' ),
                        ],
                    ],
                ],
            ],
            'enable_mail_after_expired' => [
                'label'     => __( 'Send post expiration email to author', 'wp-user-frontend' ),
                'type'      => 'checkbox',
                'help_text' => __( 'Verification of email addresses will be mandatory', 'wp-user-frontend' ),
            ],
            'post_expiration_message'   => [
                'label' => __( 'Form Expired Message', 'wp-user-frontend' ),
                'type'  => 'textarea',
            ],
        ];

        return $expiration_settings;
    }

    /**
     * Add module settings pro fields preview
     *
     * @since 4.1.0
 *
     * @param array $settings
     *
     * @return array
     */
    public function form_settings_modules( $settings ) {
        $settings['modules'] = [
            'label'     => __( 'Modules', 'wp-user-frontend' ),
            'icon'      => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.42857 9.75L2.25 12L6.42857 14.25M6.42857 9.75L12 12.75L17.5714 9.75M6.42857 9.75L2.25 7.5L12 2.25L21.75 7.5L17.5714 9.75M17.5714 9.75L21.75 12L17.5714 14.25M17.5714 14.25L21.75 16.5L12 21.75L2.25 16.5L6.42857 14.25M17.5714 14.25L12 17.25L6.42857 14.25" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>',
        ];

        return $settings;
    }
}
