;(function($) {
    'use strict';

    /**
     * Only proceed if current page is a 'Post Forms' form builder page
     */
    if (!$('#wpuf-form-builder.wpuf-form-builder-post').length) {
        return;
    }

    window.wpuf_forms_mixin_root = {
        data: function () {
            return {
                validation_error_msg: wpuf_form_builder.i18n.any_of_three_needed
            };
        },

        methods: {
            // wpuf_forms must have either 'post_title', 'post_content' or 'post_excerpt'
            // field template
            validate_form_before_submit: function () {
                var is_valid = false;

                _.each(this.form_fields, function (form_field) {
                    // Check if form_field exists and has template property
                    if (!form_field || !form_field.template) {
                        return;
                    }

                    if (_.indexOf(['post_title', 'post_content', 'post_excerpt'], form_field.template) >= 0) {
                        is_valid = true;
                        return;
                    }

                    // check in column field
                    if (form_field.template.match(/^(column|repeat)_field$/)) {
                        var innerColumnFields = form_field.inner_fields;

                        if (innerColumnFields) {
                            for (const columnFields in innerColumnFields) {
                                if (innerColumnFields.hasOwnProperty(columnFields)) {
                                    var columnFieldIndex = 0;

                                    //console.log(innerColumnFields[columnFields].length);
                                    while (columnFieldIndex < innerColumnFields[columnFields].length) {
                                        var innerField = innerColumnFields[columnFields][columnFieldIndex];
                                        if (innerField && innerField.template && _.indexOf(['post_title', 'post_content', 'post_excerpt'], innerField.template) >= 0) {
                                            is_valid = true;
                                            return;
                                        }
                                        columnFieldIndex++;
                                    }
                                }
                            }
                        }
                    }
                });

                 // Check if payment options are enabled
                 var paymentEnabled = $('[name="wpuf_settings[payment_options]"]').is(':checked');
                 if (!paymentEnabled) {
                    return is_valid; // Skip validation if payments are disabled
                 }
 
                 // Get the selected payment option
                 var choosePaymentOption = $('[name="wpuf_settings[choose_payment_option]"]').val();
                 
                 // Check if force pack purchase is selected
                 if (choosePaymentOption === 'force_pack_purchase') {
                     // Check if fallback PPP is enabled
                     var fallbackEnabled = $('[name="wpuf_settings[fallback_ppp_enable]"]').is(':checked');
                     if (fallbackEnabled) {
                         // Check if fallback cost is provided
                         var fallbackCost = $('[name="wpuf_settings[fallback_ppp_cost]"]').val();
                         if (!fallbackCost || fallbackCost.trim() === '' || parseFloat(fallbackCost) <= 0) {
                             this.validation_error_msg = 'Cost for each additional post after pack limit is reached is required when Pay-per-post billing when limit exceeds is enabled.';
                             return false;
                         }
                     }
                 }

                 // Check if enable_pay_per_post is selected and validate pay_per_post_cost
                 if (choosePaymentOption === 'enable_pay_per_post') {
                     var payPerPostCost = $('[name="wpuf_settings[pay_per_post_cost]"]').val();
                     if (!payPerPostCost || payPerPostCost.trim() === '' || parseFloat(payPerPostCost) <= 0) {
                         this.validation_error_msg = 'Charge for each post is required when Pay as you post is selected.';
                         return false;
                     }
                 }
 
                return is_valid;
            }
        }
    };

    window.wpuf_forms_mixin_builder_stage = {
        data: function () {
            return {
                label_type: 'left',
                post_form_settings: {
                    submit_text: '',
                    draft_post: false,
                }
            };
        },

        mounted: function () {
            var self = this;

            // submit button text
            this.post_form_settings.submit_text = $('[name="wpuf_settings[submit_text]"]').val();

            $('[name="wpuf_settings[submit_text]"]').on('change', function () {
                self.post_form_settings.submit_text = $(this).val();
            });

            $('[name="wpuf_settings[label_position]"]').on('change', function () {
                self.label_type = $(this).val();
            });

            $('[name="wpuf_settings[label_position]"]').trigger('change');

            // draft post text
            this.post_form_settings.draft_post = $('[type="checkbox"][name="wpuf_settings[draft_post]"]').is(':checked') ? true : false;
            $('[type="checkbox"][name="wpuf_settings[draft_post]"]').on('change', function () {
                self.post_form_settings.draft_post = $(this).is(':checked') ? true : false;
            });

            // set taxonomies according to selected post type
            var post_type_dropdown = $('select[name="wpuf_settings[post_type]"]'),
                post_type          = post_type_dropdown.val();

            this.set_taxonomies(post_type);

            post_type_dropdown.on('change', function () {
                self.set_taxonomies($(this).val());
            });
        },

        methods: {
            set_taxonomies: function (post_type) {
                var self       = this,
                    taxonomies = wpuf_form_builder.wp_post_types[post_type],
                    tax_names  = taxonomies ? Object.keys(taxonomies) : [];

                self.$store.commit('set_panel_section_fields', {
                    id: 'taxonomies',
                    fields: tax_names
                });

                // Bind jquery ui draggable. But first destroy any previous binding
                Vue.nextTick(function () {
                    var buttons = $('#panel-form-field-buttons-taxonomies .wpuf-field-button');

                    buttons.each(function () {
                        if ($(this).draggable('instance')) {
                            $(this).draggable('destroy');
                        }
                    });

                    buttons.draggable({
                        connectToSortable: '#form-preview-stage, #form-preview-stage .wpuf-form, .wpuf-column-inner-fields .wpuf-column-fields-sortable-list',
                        helper: 'clone',
                        revert: 'invalid',
                        cancel: '.button-faded',
                    }).disableSelection();
                });
            },

            // executed in 'builder-stage' component by 'is_template_available' method
            is_post_tags_template_available: function () {
                return true;
            },

            // executed in 'builder-stage' component by 'is_template_available' method
            is_taxonomy_template_available: function (field) {
                return this.field_settings[field.name] ? true : false;
            }
        }
    };

    window.wpuf_forms_mixin_field_options = {
        methods: {
            form_field_post_tags_title: function () {
                return this.$store.state.field_settings.post_tag.title;
            },

            form_field_taxonomy_title: function (form_field) {
                return this.$store.state.field_settings[form_field.name].title;
            },

            settings_post_tags: function () {
                return this.$store.state.field_settings.post_tag.settings;
            },

            settings_taxonomy: function (form_field) {
                return this.$store.state.field_settings[form_field.name].settings;
            }
        }
    };
})(jQuery);
