<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Numbers\V1;

use Twilio\Options;
use Twilio\Values;

abstract class PortingAllPortInOptions
{
    /**
     * @param string $token Page start token, if null then it will start from the beginning
     * @param int $size Number of items per page
     * @param string $portInRequestSid Filter by Port in request SID, supports multiple values separated by comma
     * @param string $portInRequestStatus Filter by Port In request status
     * @param \DateTime $createdBefore Find all created before a certain date
     * @param \DateTime $createdAfter Find all created after a certain date
     * @return ReadPortingAllPortInOptions Options builder
     */
    public static function read(
        
        string $token = Values::NONE,
        int $size = Values::INT_NONE,
        string $portInRequestSid = Values::NONE,
        string $portInRequestStatus = Values::NONE,
        ?\DateTime $createdBefore = null,
        ?\DateTime $createdAfter = null

    ): ReadPortingAllPortInOptions
    {
        return new ReadPortingAllPortInOptions(
            $token,
            $size,
            $portInRequestSid,
            $portInRequestStatus,
            $createdBefore,
            $createdAfter
        );
    }

}

class ReadPortingAllPortInOptions extends Options
    {
    /**
     * @param string $token Page start token, if null then it will start from the beginning
     * @param int $size Number of items per page
     * @param string $portInRequestSid Filter by Port in request SID, supports multiple values separated by comma
     * @param string $portInRequestStatus Filter by Port In request status
     * @param \DateTime $createdBefore Find all created before a certain date
     * @param \DateTime $createdAfter Find all created after a certain date
     */
    public function __construct(
        
        string $token = Values::NONE,
        int $size = Values::INT_NONE,
        string $portInRequestSid = Values::NONE,
        string $portInRequestStatus = Values::NONE,
        ?\DateTime $createdBefore = null,
        ?\DateTime $createdAfter = null

    ) {
        $this->options['token'] = $token;
        $this->options['size'] = $size;
        $this->options['portInRequestSid'] = $portInRequestSid;
        $this->options['portInRequestStatus'] = $portInRequestStatus;
        $this->options['createdBefore'] = $createdBefore;
        $this->options['createdAfter'] = $createdAfter;
    }

    /**
     * Page start token, if null then it will start from the beginning
     *
     * @param string $token Page start token, if null then it will start from the beginning
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self
    {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Number of items per page
     *
     * @param int $size Number of items per page
     * @return $this Fluent Builder
     */
    public function setSize(int $size): self
    {
        $this->options['size'] = $size;
        return $this;
    }

    /**
     * Filter by Port in request SID, supports multiple values separated by comma
     *
     * @param string $portInRequestSid Filter by Port in request SID, supports multiple values separated by comma
     * @return $this Fluent Builder
     */
    public function setPortInRequestSid(string $portInRequestSid): self
    {
        $this->options['portInRequestSid'] = $portInRequestSid;
        return $this;
    }

    /**
     * Filter by Port In request status
     *
     * @param string $portInRequestStatus Filter by Port In request status
     * @return $this Fluent Builder
     */
    public function setPortInRequestStatus(string $portInRequestStatus): self
    {
        $this->options['portInRequestStatus'] = $portInRequestStatus;
        return $this;
    }

    /**
     * Find all created before a certain date
     *
     * @param \DateTime $createdBefore Find all created before a certain date
     * @return $this Fluent Builder
     */
    public function setCreatedBefore(\DateTime $createdBefore): self
    {
        $this->options['createdBefore'] = $createdBefore;
        return $this;
    }

    /**
     * Find all created after a certain date
     *
     * @param \DateTime $createdAfter Find all created after a certain date
     * @return $this Fluent Builder
     */
    public function setCreatedAfter(\DateTime $createdAfter): self
    {
        $this->options['createdAfter'] = $createdAfter;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Numbers.V1.ReadPortingAllPortInOptions ' . $options . ']';
    }
}

