<?php
/**
 * Exit if accessed directly.
 *
 * @package WP_Travel
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Aditem Search Widget.
 *
 * @author   WenSolutions
 * @category Widgets
 * @package  WP_Travel
 * @extends  WP_Widget
 */
class WP_Travel_Widget_Search extends WP_Widget {
	/**
	 * Constructor.
	 */
	function __construct() {
		// Instantiate the parent object.
		parent::__construct( false, __( 'WP Travel Search (Deprecated)', 'wp-travel' ) );
	}

	/**
	 * Display widget.
	 *
	 * @param  Mixed $args     Arguments of widget.
	 * @param  Mixed $instance Instance value of widget.
	 */
	function widget( $args, $instance ) {

		extract( $args );
		// These are the widget options.
		$title = isset( $instance['title'] ) ? $instance['title'] : '';
		$title = apply_filters( 'wp_travel_search_widget_title', $title );

		echo wp_kses_post( $before_widget );
		echo ( $title ) ? wp_kses_post( $before_title . $title . $after_title ) : '';

		wptravel_search_form();
		echo wp_kses_post( $after_widget );
	}
	/**
	 * Update widget.
	 *
	 * @param  Mixed $new_instance New instance of widget.
	 * @param  Mixed $old_instance Old instance of widget.
	 */
	function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		return $instance;
	}

	/**
	 * Search form of widget.
	 *
	 * @param  Mixed $instance Widget instance.
	 */
	function form( $instance ) {
		// Check values.
		$title = '';
		if ( $instance ) {
			$title = esc_attr( $instance['title'] );
		} ?>
		<p> 
			<?php echo esc_html__( 'This widget will be removed from v9.0.0. Please use "[WP_TRAVEL_SEARCH]" shortcode in replace of this widget.', 'wp-travel' ); ?>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'wp-travel' ); ?>:</label>
			<input type="text" value="<?php echo esc_attr( $title ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" class="widefat">
		</p>
			
		<?php
	}
}

function wptravel_register_search_widgets() {
	register_widget( 'WP_Travel_Widget_Search' );
}
add_action( 'widgets_init', 'wptravel_register_search_widgets' );
