import * as React from 'react';
import { InjectedButtonAttributes, InjectedHeadingAttributes, InjectedPanelAttributes } from '../helpers/AccordionStore';
import { AccordionContext } from './AccordionContext';
export declare type ID = string | number;
declare type ProviderProps = {
    children?: React.ReactNode;
    uuid: ID;
    accordionContext: AccordionContext;
    dangerouslySetExpanded?: boolean;
};
export declare type ProviderWrapperProps = Pick<ProviderProps, Exclude<keyof ProviderProps, 'accordionContext'>>;
export declare type ItemContext = {
    uuid: ID;
    expanded: boolean;
    disabled: boolean;
    panelAttributes: InjectedPanelAttributes;
    headingAttributes: InjectedHeadingAttributes;
    buttonAttributes: InjectedButtonAttributes;
    toggleExpanded(): void;
};
declare const ProviderWrapper: React.FunctionComponent<ProviderWrapperProps>;
export { ProviderWrapper as Provider };
declare type ConsumerProps = {
    children(container: ItemContext): React.ReactNode;
};
export declare const Consumer: ({ children }: ConsumerProps) => JSX.Element;
