<?php
/**
 * Trip Search Form Template.
 * Content for Wte_Advanced_Search_Form Shortcode.
 */

if ( empty( wptravelengine_settings()->get( 'pages.search' ) ) ) {
	return;
}

// Search label filters.
$labels = array(
	'destination' => apply_filters( 'wte_search_destination_label', __( 'Destination', 'wp-travel-engine' ) ),
	'activities'  => apply_filters( 'wte_search_activities_label', __( 'Activities', 'wp-travel-engine' ) ),
	'duration'    => apply_filters( 'wte_search_duration_label', __( 'Duration', 'wp-travel-engine' ) ),
	'price'       => apply_filters( 'wte_search_budget_label', __( 'Budget', 'wp-travel-engine' ) ),
);

$icons = array(
	'destination' => '<svg width="12" height="15" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0C4.4087 0 2.88258 0.632141 1.75736 1.75736C0.632141 2.88258 0 4.4087 0 6C0 10.05 5.2875 14.625 5.5125 14.82C5.64835 14.9362 5.82124 15 6 15C6.17877 15 6.35165 14.9362 6.4875 14.82C6.75 14.625 12 10.05 12 6C12 4.4087 11.3679 2.88258 10.2426 1.75736C9.11742 0.632141 7.5913 0 6 0ZM6 13.2375C4.4025 11.7375 1.5 8.505 1.5 6C1.5 4.80653 1.97411 3.66193 2.81802 2.81802C3.66193 1.97411 4.80653 1.5 6 1.5C7.19347 1.5 8.33807 1.97411 9.18198 2.81802C10.0259 3.66193 10.5 4.80653 10.5 6C10.5 8.505 7.5975 11.745 6 13.2375ZM6 3C5.40666 3 4.82664 3.17595 4.33329 3.50559C3.83994 3.83524 3.45542 4.30377 3.22836 4.85195C3.0013 5.40013 2.94189 6.00333 3.05764 6.58527C3.1734 7.16721 3.45912 7.70176 3.87868 8.12132C4.29824 8.54088 4.83279 8.8266 5.41473 8.94236C5.99667 9.05811 6.59987 8.9987 7.14805 8.77164C7.69623 8.54458 8.16477 8.16006 8.49441 7.66671C8.82405 7.17336 9 6.59334 9 6C9 5.20435 8.68393 4.44129 8.12132 3.87868C7.55871 3.31607 6.79565 3 6 3ZM6 7.5C5.70333 7.5 5.41332 7.41203 5.16665 7.2472C4.91997 7.08238 4.72771 6.84811 4.61418 6.57403C4.50065 6.29994 4.47094 5.99834 4.52882 5.70736C4.5867 5.41639 4.72956 5.14912 4.93934 4.93934C5.14912 4.72956 5.41639 4.5867 5.70737 4.52882C5.99834 4.47094 6.29994 4.50065 6.57403 4.61418C6.84811 4.72771 7.08238 4.91997 7.2472 5.16665C7.41203 5.41332 7.5 5.70333 7.5 6C7.5 6.39782 7.34197 6.77936 7.06066 7.06066C6.77936 7.34196 6.39783 7.5 6 7.5Z" fill="#2183DF" /></svg>',
	'activities'  => '<svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.9192 5.06735C15.4031 5.06735 14.9092 5.16388 14.4543 5.33946C14.0979 4.54743 13.79 3.70981 13.6362 2.93056C13.3892 1.67907 12.2833 0.770752 11.0066 0.770752C10.683 0.770752 10.4206 1.0331 10.4206 1.35669C10.4206 1.68028 10.683 1.94263 11.0066 1.94263C11.146 1.94263 11.2817 1.96208 11.4111 1.99821C11.8041 2.10806 12.1377 2.37392 12.3322 2.73095C12.3165 2.75095 12.3015 2.77169 12.2882 2.79415L12.1061 3.1006L11.1852 4.65099H6.26473L5.98504 3.94704H6.10113C6.42473 3.94704 6.68707 3.6847 6.68707 3.3611C6.68707 3.03751 6.42473 2.77517 6.10113 2.77517H4.08086C3.75727 2.77517 3.49492 3.03751 3.49492 3.3611C3.49492 3.6847 3.75727 3.94704 4.08086 3.94704H4.72406L5.23539 5.23392C4.86914 5.12571 4.48172 5.06731 4.08086 5.06731C1.83066 5.06735 0 6.89802 0 9.14817C0 11.3983 1.83066 13.229 4.08082 13.229C6.13203 13.229 7.83437 11.7077 8.11941 9.73411H9.19547C9.40219 9.73411 9.59363 9.62517 9.69922 9.44743L12.7784 4.2636C12.959 4.82259 13.1851 5.38267 13.4288 5.91774C12.4621 6.6647 11.8384 7.83489 11.8384 9.14821C11.8384 11.3984 13.669 13.229 15.9192 13.229C18.1693 13.229 20 11.3984 20 9.14821C20 6.89806 18.1693 5.06735 15.9192 5.06735ZM4.08082 9.73411H6.93047C6.65859 11.0582 5.48418 12.0571 4.08082 12.0571C2.47684 12.0571 1.17188 10.7522 1.17188 9.14817C1.17188 7.54419 2.47684 6.23923 4.08082 6.23923C5.48418 6.23923 6.65859 7.23813 6.93047 8.56224H4.08082C3.75723 8.56224 3.49488 8.82458 3.49488 9.14817C3.49488 9.47177 3.75723 9.73411 4.08082 9.73411ZM8.86199 8.56224H8.11941C7.98344 7.62087 7.52504 6.78251 6.86 6.16298C6.85391 6.13946 6.84684 6.11603 6.83762 6.09286L6.73035 5.8229H10.4891L8.86199 8.56224ZM15.9192 12.0571C14.3152 12.0571 13.0102 10.7521 13.0102 9.14813C13.0102 8.29841 13.3766 7.5327 13.9595 7.00036C14.6801 8.37755 15.384 9.40419 15.437 9.48099C15.5507 9.64571 15.7336 9.73411 15.9197 9.73411C16.0345 9.73411 16.1504 9.70044 16.252 9.63032C16.5184 9.44649 16.5852 9.08157 16.4014 8.81524C16.3888 8.79696 15.6797 7.76294 14.9697 6.39911C15.2675 6.29595 15.5868 6.23915 15.9192 6.23915C17.5232 6.23915 18.8281 7.54411 18.8281 9.1481C18.8281 10.7521 17.5232 12.0571 15.9192 12.0571Z" fill="#2183DF"/></svg>',
	'trip_types'  => '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_78623_2811)"><path d="M17.9997 7.33333C19.4664 7.33333 20.6664 6.13333 20.6664 4.66667C20.6664 3.2 19.4664 2 17.9997 2C16.5331 2 15.3331 3.2 15.3331 4.66667C15.3331 6.13333 16.5331 7.33333 17.9997 7.33333ZM23.3331 14.3733C21.6931 13.88 20.3731 12.8133 19.5997 11.4667L18.2664 9.33333C17.7197 8.46667 16.7864 8 15.8131 8C14.7731 8 13.6931 8.66667 13.4397 9.92C13.1864 11.1733 9.33307 30.6667 9.33307 30.6667H12.1331L14.5331 20L17.3331 22.6667V30.6667H19.9997V20.6667L17.1997 18L17.9997 14C19.3331 15.5333 21.2131 16.68 23.3331 17.12V30.6667H25.3331V12H23.3331V14.3733ZM9.9064 17.5067L7.07973 16.96C6.35973 16.8133 5.87973 16.12 6.0264 15.4L7.03973 10.16C7.31973 8.72 8.71973 7.77333 10.1597 8.05333L11.7064 8.36L9.9064 17.5067Z" fill="black"/></g><defs><clipPath id="clip0_78623_2811"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>',
	'dates'       => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8 9.5C8.14834 9.5 8.29334 9.45601 8.41668 9.3736C8.54002 9.29119 8.63614 9.17406 8.69291 9.03701C8.74968 8.89997 8.76453 8.74917 8.73559 8.60368C8.70665 8.4582 8.63522 8.32456 8.53033 8.21967C8.42544 8.11478 8.2918 8.04335 8.14632 8.01441C8.00083 7.98547 7.85003 8.00032 7.71299 8.05709C7.57594 8.11386 7.45881 8.20999 7.3764 8.33332C7.29399 8.45666 7.25 8.60166 7.25 8.75C7.25 8.94891 7.32902 9.13968 7.46967 9.28033C7.61032 9.42098 7.80109 9.5 8 9.5ZM11.75 9.5C11.8983 9.5 12.0433 9.45601 12.1667 9.3736C12.29 9.29119 12.3861 9.17406 12.4429 9.03701C12.4997 8.89997 12.5145 8.74917 12.4856 8.60368C12.4566 8.4582 12.3852 8.32456 12.2803 8.21967C12.1754 8.11478 12.0418 8.04335 11.8963 8.01441C11.7508 7.98547 11.6 8.00032 11.463 8.05709C11.3259 8.11386 11.2088 8.20999 11.1264 8.33332C11.044 8.45666 11 8.60166 11 8.75C11 8.94891 11.079 9.13968 11.2197 9.28033C11.3603 9.42098 11.5511 9.5 11.75 9.5ZM8 12.5C8.14834 12.5 8.29334 12.456 8.41668 12.3736C8.54002 12.2912 8.63614 12.1741 8.69291 12.037C8.74968 11.9 8.76453 11.7492 8.73559 11.6037C8.70665 11.4582 8.63522 11.3246 8.53033 11.2197C8.42544 11.1148 8.2918 11.0434 8.14632 11.0144C8.00083 10.9855 7.85003 11.0003 7.71299 11.0571C7.57594 11.1139 7.45881 11.21 7.3764 11.3333C7.29399 11.4567 7.25 11.6017 7.25 11.75C7.25 11.9489 7.32902 12.1397 7.46967 12.2803C7.61032 12.421 7.80109 12.5 8 12.5ZM11.75 12.5C11.8983 12.5 12.0433 12.456 12.1667 12.3736C12.29 12.2912 12.3861 12.1741 12.4429 12.037C12.4997 11.9 12.5145 11.7492 12.4856 11.6037C12.4566 11.4582 12.3852 11.3246 12.2803 11.2197C12.1754 11.1148 12.0418 11.0434 11.8963 11.0144C11.7508 10.9855 11.6 11.0003 11.463 11.0571C11.3259 11.1139 11.2088 11.21 11.1264 11.3333C11.044 11.4567 11 11.6017 11 11.75C11 11.9489 11.079 12.1397 11.2197 12.2803C11.3603 12.421 11.5511 12.5 11.75 12.5ZM4.25 9.5C4.39834 9.5 4.54334 9.45601 4.66668 9.3736C4.79001 9.29119 4.88614 9.17406 4.94291 9.03701C4.99968 8.89997 5.01453 8.74917 4.98559 8.60368C4.95665 8.4582 4.88522 8.32456 4.78033 8.21967C4.67544 8.11478 4.5418 8.04335 4.39632 8.01441C4.25083 7.98547 4.10003 8.00032 3.96299 8.05709C3.82594 8.11386 3.70881 8.20999 3.6264 8.33332C3.54399 8.45666 3.5 8.60166 3.5 8.75C3.5 8.94891 3.57902 9.13968 3.71967 9.28033C3.86032 9.42098 4.05109 9.5 4.25 9.5ZM13.25 2H12.5V1.25C12.5 1.05109 12.421 0.860322 12.2803 0.71967C12.1397 0.579018 11.9489 0.5 11.75 0.5C11.5511 0.5 11.3603 0.579018 11.2197 0.71967C11.079 0.860322 11 1.05109 11 1.25V2H5V1.25C5 1.05109 4.92098 0.860322 4.78033 0.71967C4.63968 0.579018 4.44891 0.5 4.25 0.5C4.05109 0.5 3.86032 0.579018 3.71967 0.71967C3.57902 0.860322 3.5 1.05109 3.5 1.25V2H2.75C2.15326 2 1.58097 2.23705 1.15901 2.65901C0.737053 3.08097 0.5 3.65326 0.5 4.25V13.25C0.5 13.8467 0.737053 14.419 1.15901 14.841C1.58097 15.2629 2.15326 15.5 2.75 15.5H13.25C13.8467 15.5 14.419 15.2629 14.841 14.841C15.2629 14.419 15.5 13.8467 15.5 13.25V4.25C15.5 3.65326 15.2629 3.08097 14.841 2.65901C14.419 2.23705 13.8467 2 13.25 2ZM14 13.25C14 13.4489 13.921 13.6397 13.7803 13.7803C13.6397 13.921 13.4489 14 13.25 14H2.75C2.55109 14 2.36032 13.921 2.21967 13.7803C2.07902 13.6397 2 13.4489 2 13.25V6.5H14V13.25ZM14 5H2V4.25C2 4.05109 2.07902 3.86032 2.21967 3.71967C2.36032 3.57902 2.55109 3.5 2.75 3.5H13.25C13.4489 3.5 13.6397 3.57902 13.7803 3.71967C13.921 3.86032 14 4.05109 14 4.25V5ZM4.25 12.5C4.39834 12.5 4.54334 12.456 4.66668 12.3736C4.79001 12.2912 4.88614 12.1741 4.94291 12.037C4.99968 11.9 5.01453 11.7492 4.98559 11.6037C4.95665 11.4582 4.88522 11.3246 4.78033 11.2197C4.67544 11.1148 4.5418 11.0434 4.39632 11.0144C4.25083 10.9855 4.10003 11.0003 3.96299 11.0571C3.82594 11.1139 3.70881 11.21 3.6264 11.3333C3.54399 11.4567 3.5 11.6017 3.5 11.75C3.5 11.9489 3.57902 12.1397 3.71967 12.2803C3.86032 12.421 4.05109 12.5 4.25 12.5Z" fill="#2183DF"></path></svg>',
	'default'     => '<svg viewBox="0 0 343.5 343.5"><g><g><path d="M322.05,161.8h-182.6c-5.5,0-10,4.5-10,10s4.5,10,10,10h182.6c5.5,0,10-4.5,10-10C332.05,166.3,327.65,161.8,322.05,161.8 z"/></g></g><g><g><path d="M57.95,125.3c-25.7,0-46.5,20.8-46.5,46.5s20.8,46.5,46.5,46.5s46.5-20.8,46.5-46.5S83.65,125.3,57.95,125.3z M57.95,198.3c-14.7,0-26.5-11.9-26.5-26.5c0-14.7,11.9-26.5,26.5-26.5c14.6,0,26.5,11.9,26.5,26.5S72.55,198.3,57.95,198.3z"/></g></g><g><g><path d="M322.05,36.8h-182.6c-5.5,0-10,4.5-10,10s4.5,10,10,10h182.6c5.5,0,10-4.5,10-10C332.05,41.3,327.65,36.8,322.05,36.8z"/></g></g><g><g><path d="M57.95,0c-25.7,0-46.5,20.8-46.5,46.5c0,25.7,20.8,46.5,46.5,46.5s46.5-20.8,46.5-46.5C104.45,20.9,83.65,0.1,57.95,0z M57.95,73.1c-14.7,0-26.5-11.9-26.5-26.5c0-14.6,11.9-26.5,26.5-26.5c14.7,0,26.5,11.9,26.5,26.5 C84.45,61.2,72.55,73.1,57.95,73.1z"/></g></g><g><g><path d="M322.05,286.8h-182.6c-5.5,0-10,4.5-10,10s4.5,10,10,10h182.6c5.5,0,10-4.5,10-10S327.65,286.8,322.05,286.8z"/></g></g><g><g><path d="M57.95,250.5c-25.7,0-46.5,20.8-46.5,46.5c0,25.7,20.8,46.5,46.5,46.5s46.5-20.8,46.5-46.5 C104.45,271.4,83.65,250.5,57.95,250.5z M57.95,323.6c-14.7,0-26.5-11.9-26.5-26.5c0-14.7,11.9-26.5,26.5-26.5 c14.7,0,26.5,11.9,26.5,26.5S72.55,323.6,57.95,323.6z"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
);

$search_filters = get_object_taxonomies( 'trip', 'objects' );

array_splice(
	$search_filters,
	2,
	0,
	array(
		(object) array(
			// 'show'  => ! wte_advanced_search_hide_filters_in_search_page( 'duration' ),
			'label' => $labels['duration'],
			'name'  => 'duration',
		),
	)
);

array_splice(
	$search_filters,
	4,
	0,
	array(
		(object) array(
			'show'  => ! wte_advanced_search_hide_filters_in_search_page( 'budget' ),
			'label' => $labels['price'],
			'name'  => 'price',
		),
	)
);

array_push(
	$search_filters,
	(object) array(
		'show'  => ! wte_advanced_search_hide_filters_in_search_page( 'dates' ),
		'label' => apply_filters( 'wte-fixed-departure-dates-title', __( 'Departure Dates', 'wp-travel-engine' ) ),
		'name'  => 'dates',
	)
);

$search_filters = apply_filters( 'wptravelengine_search_form_filters', $search_filters );

?>

<div class="wpte-gblock-wrapper">
	<div class="wpte-trip-sfilter-wrapper">
		<form class="wpte-trip__search-fields <?php echo esc_attr( $direction ); ?>" action="<?php echo esc_url( wp_travel_engine_get_page_permalink( 'search' ) ); ?>">
			<?php
			$i = 1;
			foreach ( $search_filters as $_taxonomy => $args ) {

				$_args = array(
					'show'  => $args->show ?? ! wte_advanced_search_hide_filters_in_search_page( $args->name ),
					'label' => $labels[ $args->name ] ?? $args->label,
					'icon'  => array(
						'value'   => '',
						'library' => '',
					),
				);

				if ( ! $_args['show'] ) {
					continue;
				}

				$callable_filter = apply_filters( "wptravelengine_search_filter_{$args->name}", null );
				if ( is_callable( $callable_filter ) ) {
					call_user_func( $callable_filter, $_args );
					continue;
				}

				if ( isset( $args->field_content ) ) {
					echo $args->field_content;
					continue;
				}

				if ( 'dates' !== $args->name ) {
					$terms = wte_get_terms_by_id( $_taxonomy );
				} else {
					if ( wptravelengine_is_addon_active( 'fixed-starting-dates' ) && class_exists( '\WTE_Fixed_Starting_Dates_Functions' ) ) {
						$today  = new \DateTime();
						$months = \WTE_Fixed_Starting_Dates_Functions::get_trips_available_year_months();
						?>
						<div class="wpte-trip__adv-field wpte__select-field">
							<span class="icon"> <?php echo wte_esc_svg( $icons[ $args->name ] ?? $icons['default'] ); ?> </span>
							<input type="text" class="wpte__input" placeholder="<?php echo esc_attr( $_args['label'] ); ?>" />
							<input type="hidden" id="wptravelengine_search_form_field_<?php echo esc_attr( $args->name ); ?>" class="wpte__input-value" name="trip-date-select" />
							<div class="wpte__select-options">
							<ul>
								<?php
								foreach ( $months as $index => $date ) {
									if ( $today > $date ) {
										continue;
									}
									echo '<li data-value="' . esc_attr( $date->format( 'Y-m' ) ) . '" data-label="' . esc_attr( date_i18n( 'F, Y', $date->getTimestamp() ) ) . '"><span>' . esc_html( date_i18n( 'F, Y', $date->getTimestamp() ) ) . '</span></li>';
								}
								?>
							</ul>
							</div>
						</div>
						<?php
					}
					continue;
				}

				if ( is_array( $terms ) && count( $terms ) > 0 ) {
					?>
					<div class="wpte-trip__adv-field wpte__select-field">
						<span class="icon"> <?php echo wte_esc_svg( $icons[ $_taxonomy ] ?? $icons['default'] ); ?> </span>
						<input type="text" class="wpte__input" placeholder="<?php echo esc_attr( $_args['label'] ); ?>" />
						<input type="hidden" id="<?php echo esc_attr( $_taxonomy ); ?>" class="wpte__input-value" name="<?php echo esc_attr( $_taxonomy ); ?>" />
						<div class="wpte__select-options">
							<ul>
								<?php
								foreach ( $terms as $term ) {
									if ( (bool) $term->parent ) {
										continue;
									}
									printf( '<li data-value="%2$s" data-label="%3$s"><span>%1$s</span>', esc_html( $term->name ), esc_attr( $term->slug ), esc_attr( $term->name ) );
									if ( count( $term->children ) > 0 ) {
										echo '<ul>';
										foreach ( $term->children as $term_child_id ) {
											$term_child = $terms[ $term_child_id ];
											printf( '<li data-value="%2$s" data-label="%3$s"><span>%1$s</span></li>', esc_html( $term_child->name ), esc_attr( $term_child->slug ), esc_attr( $term_child->name ) );
										}
										echo '</ul>';
									}
									echo '</li>';
								}
								?>
							</ul>
						</div>
					</div>
					<?php
				}
			}
			?>
			<div class="wpte-trip__submit-field">
				<button type="submit" class="wpte-trip__search-submit"><?php echo esc_html__( 'Search', 'wp-travel-engine' ); ?></button>
			</div>
		</form>
	</div>
</div>
